/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.testrunner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteExecutionException
extends RuntimeException {
    private final String trace;
    private final StackTraceElement[] stackTrace;
    private static final Pattern TRACE_PATTERN = Pattern.compile("\\s*at\\s+([\\w\\.$_]+)\\.([\\w$_]+)(?:\\((.*\\.java):(\\d+)\\)|(\\(.*\\)))");
    private static final Pattern CAUSED_BY_PATTERN = Pattern.compile("\\s*Caused by:\\s+(.*)");
    private static final int NATIVE_METHOD_LINE_NUMBER = -2;

    public static RemoteExecutionException getExceptionFromTrace(String trace) throws IOException {
        String firstLine;
        try (BufferedReader reader = new BufferedReader(new StringReader(trace));){
            firstLine = reader.readLine();
        }
        return new RemoteExecutionException(firstLine, trace);
    }

    public RemoteExecutionException(String failure, String trace) throws NumberFormatException, IOException {
        super(failure);
        this.trace = trace;
        this.stackTrace = this.getStackTraceFromString(trace);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.trace != null) {
            s.print(this.trace);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.trace != null) {
            s.print(this.trace);
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final StackTraceElement[] getStackTraceFromString(String trace) throws NumberFormatException, IOException {
        if (trace == null) {
            return new StackTraceElement[0];
        }
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        try (BufferedReader reader = new BufferedReader(new StringReader(trace));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                char[] cbuf;
                Matcher causedByMatcher;
                Matcher traceMatcher = TRACE_PATTERN.matcher(line);
                if (traceMatcher.find()) {
                    int lineNumber;
                    String sourceFile;
                    String className = traceMatcher.group(1);
                    String methodName = traceMatcher.group(2);
                    if (traceMatcher.group(3) != null) {
                        sourceFile = traceMatcher.group(3);
                        lineNumber = traceMatcher.group(4) != null ? Integer.parseInt(traceMatcher.group(4)) : -1;
                    } else {
                        sourceFile = traceMatcher.group(5);
                        lineNumber = -2;
                    }
                    stackTraceElements.add(new StackTraceElement(className, methodName, sourceFile, lineNumber));
                }
                if (!(causedByMatcher = CAUSED_BY_PATTERN.matcher(line)).find() || reader.read(cbuf = new char[trace.length()]) <= 0) continue;
                this.initCause(new RemoteExecutionException(causedByMatcher.group(1), new String(cbuf)));
            }
        }
        return stackTraceElements.toArray(new StackTraceElement[stackTraceElements.size()]);
    }
}

