/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.installhook;

import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInstallerHookEntry
implements InstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstallerHookEntry.class);
    public static String OSGI_INSTALLER_CLASSNAME = "org.apache.sling.installer.api.OsgiInstaller";
    public static String HOOK_CLASSNAME = "org.apache.sling.installer.provider.installhook.OsgiInstallerHook";

    public void execute(InstallContext context) throws PackageException {
        try {
            Class<?> osgiInstallerClass = this.getClass().getClassLoader().loadClass(OSGI_INSTALLER_CLASSNAME);
            LOG.debug("Osgi Installer Class found: {}", osgiInstallerClass);
            this.loadAndRunInstallHook(context);
        }
        catch (ClassNotFoundException e) {
            LOG.info("Class {} not found, skipping installer hook for package {}", (Object)OSGI_INSTALLER_CLASSNAME, (Object)context.getPackage().getId());
        }
    }

    private void loadAndRunInstallHook(InstallContext context) throws PackageException {
        InstallHook actualHook = null;
        try {
            Class<?> actualHookClass = this.getClass().getClassLoader().loadClass(HOOK_CLASSNAME);
            actualHook = (InstallHook)actualHookClass.newInstance();
        }
        catch (Exception e) {
            LOG.error("Could not load/instantiate " + HOOK_CLASSNAME + ": " + e, (Throwable)e);
            return;
        }
        actualHook.execute(context);
    }
}

