/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SortingServiceTracker<T>
extends ServiceTracker<T, T> {
    private final RetryHandler listener;
    private volatile int lastCount = -1;
    private volatile int lastRefCount = -1;
    private volatile List<T> sortedServiceCache;
    private volatile List<ServiceReference<T>> sortedReferences;

    public SortingServiceTracker(BundleContext context, String clazz, RetryHandler listener) {
        super(context, clazz, null);
        this.listener = listener;
    }

    public void removedService(ServiceReference<T> reference, T service) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
        this.context.ungetService(reference);
    }

    public void modifiedService(ServiceReference<T> reference, T service) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
    }

    public T addingService(ServiceReference<T> reference) {
        this.sortedServiceCache = null;
        this.sortedReferences = null;
        Object returnValue = this.context.getService(reference);
        if (this.listener != null) {
            this.listener.scheduleRetry();
        }
        return (T)returnValue;
    }

    public List<T> getSortedServices() {
        List<T> result = this.sortedServiceCache;
        if (result == null || this.lastCount < this.getTrackingCount()) {
            this.lastCount = this.getTrackingCount();
            Object[] references = this.getServiceReferences();
            if (references == null || references.length == 0) {
                result = Collections.emptyList();
            } else {
                Arrays.sort(references);
                result = new ArrayList<T>();
                for (int i = 0; i < references.length; ++i) {
                    Object service = this.getService((ServiceReference)references[references.length - 1 - i]);
                    if (service == null) continue;
                    result.add(service);
                }
            }
            this.sortedServiceCache = result;
        }
        return result;
    }

    public List<ServiceReference<T>> getSortedServiceReferences() {
        List<Object> result = this.sortedReferences;
        if (result == null || this.lastRefCount < this.getTrackingCount()) {
            this.lastRefCount = this.getTrackingCount();
            Object[] references = this.getServiceReferences();
            if (references == null || references.length == 0) {
                result = Collections.emptyList();
            } else {
                Arrays.sort(references);
                result = new ArrayList<ServiceReference<T>>();
                for (int i = 0; i < references.length; ++i) {
                    result.add(references[references.length - 1 - i]);
                }
            }
            this.sortedReferences = result;
        }
        return result;
    }

    public boolean check(String key, String name) {
        ServiceReference[] refs = this.getServiceReferences();
        if (refs != null) {
            for (ServiceReference ref : refs) {
                Object val = ref.getProperty(key);
                if (!name.equals(val)) continue;
                return true;
            }
        }
        return false;
    }
}

