/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.samples.impl;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.annotations.SlingHealthCheck;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingHealthCheck(configurationFactory=true, configurationPolicy=ConfigurationPolicy.REQUIRE, metatype=true)
@Service
public class AsyncHealthCheckSample
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(AsyncHealthCheckSample.class);
    private static final AtomicInteger counter = new AtomicInteger();
    public static final int PERIOD_SECONDS = 5;

    public Result execute() {
        long toWait = (long)(Math.random() * 2.0 * 5.0);
        this.log.info("{} - Waiting {} seconds to simulate an expensive operation...", (Object)this, (Object)toWait);
        try {
            Thread.sleep(toWait * 1000L);
        }
        catch (InterruptedException iex) {
            this.log.warn("Sleep interrupted", (Throwable)iex);
        }
        int value = counter.incrementAndGet();
        this.log.info("{} - counter set to {}", (Object)this, (Object)value);
        FormattingResultLog resultLog = new FormattingResultLog();
        resultLog.info("{} - counter value set to {} at {}", new Object[]{this, value, new Date()});
        if (value % 2 != 0) {
            resultLog.warn("Counter value ({}) is not even", new Object[]{value});
        }
        return new Result((ResultLog)resultLog);
    }
}

