/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.stream.JsonParsingException;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.JSONConstants;
import org.apache.sling.feature.io.json.JSONReaderBase;

public class FeatureJSONReader
extends JSONReaderBase {
    protected Feature feature;

    public static Feature read(Reader reader, String location) throws IOException {
        try {
            FeatureJSONReader mr = new FeatureJSONReader(location);
            return mr.readFeature(reader);
        }
        catch (IllegalArgumentException | IllegalStateException | JsonParsingException e) {
            throw new IOException(e);
        }
    }

    protected FeatureJSONReader(String location) {
        super(location);
    }

    protected Feature readFeature(Reader reader) throws IOException {
        JsonObject json = Json.createReader((Reader)new StringReader(this.minify(reader))).readObject();
        Map<String, Object> map = this.getJsonMap(json);
        this.checkModelVersion(map);
        ArtifactId featureId = this.getFeatureId(map);
        this.feature = new Feature(featureId);
        this.feature.setLocation(this.location);
        if (map.containsKey("final")) {
            Object finalObj = map.get("final");
            this.checkType("final", finalObj, Boolean.class);
            this.feature.setFinal(((Boolean)finalObj).booleanValue());
        }
        if (map.containsKey("complete")) {
            Object completeObj = map.get("complete");
            this.checkType("complete", completeObj, Boolean.class);
            this.feature.setComplete(((Boolean)completeObj).booleanValue());
        }
        this.feature.setTitle(this.getProperty(map, "title"));
        this.feature.setDescription(this.getProperty(map, "description"));
        this.feature.setVendor(this.getProperty(map, "vendor"));
        this.feature.setLicense(this.getProperty(map, "license"));
        this.readVariables(map, this.feature.getVariables());
        this.readBundles(map, this.feature.getBundles(), this.feature.getConfigurations());
        this.readFrameworkProperties(map, this.feature.getFrameworkProperties());
        this.readConfigurations(map, this.feature.getConfigurations());
        this.readCapabilities(map, this.feature.getCapabilities());
        this.readRequirements(map, this.feature.getRequirements());
        this.feature.setPrototype(this.readPrototype(map));
        this.readExtensions(map, JSONConstants.FEATURE_KNOWN_PROPERTIES, this.feature.getExtensions(), this.feature.getConfigurations());
        return this.feature;
    }

    private void checkModelVersion(Map<String, Object> map) throws IOException {
        String modelVersion = this.getProperty(map, "model-version");
        if (modelVersion == null) {
            modelVersion = "1";
        }
        if (!"1".equals(modelVersion)) {
            throw new IOException("Unsupported model version: " + modelVersion);
        }
    }

    protected ArtifactId getFeatureId(Map<String, Object> map) throws IOException {
        if (!map.containsKey("id")) {
            throw new IOException(this.exceptionPrefix + "Feature id is missing");
        }
        Object idObj = map.get("id");
        this.checkType("id", idObj, String.class);
        return ArtifactId.parse((String)idObj.toString());
    }
}

