/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Calendar;
import java.util.Iterator;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.queue.impl.resource.ResourceIterator;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueUtils;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQueueCleanupTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolverFactory resolverFactory;
    private final String serviceName;
    private final String rootPath;

    public ResourceQueueCleanupTask(ResourceResolverFactory resolverFactory, String serviceName, String rootPath) {
        this.resolverFactory = resolverFactory;
        this.serviceName = serviceName;
        this.rootPath = rootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.debug("Cleaning up resource queues at {}", (Object)this.rootPath);
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource root = ResourceQueueUtils.getRootResource(resourceResolver, this.rootPath);
            Iterator it = root.listChildren();
            while (it.hasNext()) {
                Resource queueRoot = (Resource)it.next();
                this.log.debug("Starting cleaning up queue at {}", (Object)queueRoot.getPath());
                this.removeEmptyFolders(queueRoot);
                this.log.debug("Finished cleaning up queue at {}", (Object)queueRoot.getPath());
            }
        }
        catch (Throwable e) {
            try {
                this.log.error("Error cleaning up resource queues", e);
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
            DistributionUtils.safelyLogout(resourceResolver);
        }
        DistributionUtils.safelyLogout(resourceResolver);
    }

    public void removeEmptyFolders(Resource root) throws PersistenceException {
        Calendar now = Calendar.getInstance();
        now.add(12, -5);
        ResourceResolver resolver = root.getResourceResolver();
        ResourceIterator it = new ResourceIterator(root, "sling:OrderedFolder", true, false);
        String nowPath = ResourceQueueUtils.getTimePath(now);
        while (it.hasNext()) {
            Resource res = it.next();
            String resPath = res.getPath().substring(root.getPath().length() + 1);
            if (!res.isResourceType("sling:OrderedFolder") || !ResourceQueueUtils.isSafeToDelete(nowPath, resPath) || res.hasChildren()) continue;
            this.log.debug("removing minute resource folder {}", (Object)res.getPath());
            resolver.delete(res);
            resolver.commit();
        }
    }
}

