/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.announcement;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.NonLocalInstanceDescription;

public class Announcement {
    private static final int PROTOCOL_VERSION = 1;
    private final String ownerId;
    private final int protocolVersion;
    private ClusterView localCluster;
    private List<Announcement> incomings = new LinkedList<Announcement>();
    private boolean inherited = false;
    private String serverInfo;
    private boolean loop = false;
    private long backoffInterval = -1L;
    private boolean resetBackoff = false;
    private long originallyCreatedAt = -1L;
    private long receivedAt = System.currentTimeMillis();
    private static final JsonReaderFactory jsonReaderFactory;

    public Announcement(String ownerId) {
        this(ownerId, 1);
    }

    public Announcement(String ownerId, int protocolVersion) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty");
        }
        this.ownerId = ownerId;
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        StringBuilder incomingList = new StringBuilder();
        for (Announcement anIncomingAnnouncement : this.incomings) {
            if (incomingList.length() != 0) {
                incomingList.append(", ");
            }
            incomingList.append(anIncomingAnnouncement);
        }
        return "Announcement[ownerId=" + this.getOwnerId() + ", protocolVersion=" + this.protocolVersion + ", inherited=" + this.isInherited() + ", loop=" + this.loop + ", incomings=" + incomingList + "]";
    }

    public boolean isCorrectVersion() {
        return this.protocolVersion == 1;
    }

    public boolean isValid() {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            return false;
        }
        if (this.loop) {
            return true;
        }
        if (!this.isCorrectVersion()) {
            return false;
        }
        if (this.localCluster == null) {
            return false;
        }
        try {
            List instances = this.localCluster.getInstances();
            if (instances == null || instances.size() == 0) {
                return false;
            }
            boolean isOwnerMemberOfLocalCluster = false;
            for (InstanceDescription instanceDescription : instances) {
                if (!instanceDescription.getSlingId().equals(this.ownerId)) continue;
                isOwnerMemberOfLocalCluster = true;
            }
            if (!isOwnerMemberOfLocalCluster) {
                return false;
            }
        }
        catch (Exception ise) {
            return false;
        }
        return true;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setBackoffInterval(long backoffInterval) {
        this.backoffInterval = backoffInterval;
    }

    public long getBackoffInterval() {
        return this.backoffInterval;
    }

    public long getOriginallyCreatedAt() {
        return this.originallyCreatedAt;
    }

    public long getReceivedAt() {
        return this.receivedAt;
    }

    public void setResetBackoff(boolean resetBackoff) {
        this.resetBackoff = resetBackoff;
    }

    public boolean getResetBackoff() {
        return this.resetBackoff;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    private JsonObject asJSONObject(boolean filterTimes) {
        JsonObjectBuilder announcement = Json.createObjectBuilder();
        announcement.add("ownerId", this.ownerId);
        announcement.add("protocolVersion", this.protocolVersion);
        if (!filterTimes) {
            announcement.add("created", System.currentTimeMillis());
        }
        announcement.add("inherited", this.inherited);
        if (this.loop) {
            announcement.add("loop", this.loop);
        }
        if (this.serverInfo != null) {
            announcement.add("serverInfo", this.serverInfo);
        }
        if (this.localCluster != null) {
            announcement.add("localClusterView", (JsonValue)Announcement.asJSON(this.localCluster));
        }
        if (!filterTimes && this.backoffInterval > 0L) {
            announcement.add("backoffInterval", this.backoffInterval);
        }
        if (this.resetBackoff) {
            announcement.add("resetBackoff", this.resetBackoff);
        }
        JsonArrayBuilder incomingAnnouncements = Json.createArrayBuilder();
        for (Announcement incoming : this.incomings) {
            incomingAnnouncements.add((JsonValue)incoming.asJSONObject(filterTimes));
        }
        announcement.add("topologyAnnouncements", incomingAnnouncements);
        return announcement.build();
    }

    public static Announcement fromJSON(String topologyAnnouncementJSON) {
        JsonObject announcement = jsonReaderFactory.createReader((Reader)new StringReader(topologyAnnouncementJSON)).readObject();
        String ownerId = announcement.getString("ownerId");
        int protocolVersion = !announcement.containsKey((Object)"protocolVersion") ? -1 : announcement.getInt("protocolVersion");
        Announcement result = new Announcement(ownerId, protocolVersion);
        if (announcement.containsKey((Object)"created")) {
            result.originallyCreatedAt = announcement.getJsonNumber("created").longValue();
        }
        if (announcement.containsKey((Object)"backoffInterval")) {
            long backoffInterval;
            result.backoffInterval = backoffInterval = announcement.getJsonNumber("backoffInterval").longValue();
        }
        if (announcement.containsKey((Object)"resetBackoff")) {
            boolean resetBackoff;
            result.resetBackoff = resetBackoff = announcement.getBoolean("resetBackoff");
        }
        if (announcement.containsKey((Object)"loop") && announcement.getBoolean("loop")) {
            result.setLoop(true);
            return result;
        }
        if (announcement.containsKey((Object)"localClusterView")) {
            String localClusterViewJSON = Announcement.asJSON((JsonValue)announcement.getJsonObject("localClusterView"));
            ClusterView localClusterView = Announcement.asClusterView(localClusterViewJSON);
            result.setLocalCluster(localClusterView);
        }
        if (announcement.containsKey((Object)"inherited")) {
            Boolean inherited = announcement.getBoolean("inherited");
            result.inherited = inherited;
        }
        if (announcement.containsKey((Object)"serverInfo")) {
            String serverInfo;
            result.serverInfo = serverInfo = announcement.getString("serverInfo");
        }
        JsonArray subAnnouncements = announcement.getJsonArray("topologyAnnouncements");
        for (int i = 0; i < subAnnouncements.size(); ++i) {
            String subAnnouncementJSON = ((JsonValue)subAnnouncements.get(i)).toString();
            result.addIncomingTopologyAnnouncement(Announcement.fromJSON(subAnnouncementJSON));
        }
        return result;
    }

    private static ClusterView asClusterView(String localClusterViewJSON) {
        JsonObject obj = jsonReaderFactory.createReader((Reader)new StringReader(localClusterViewJSON)).readObject();
        DefaultClusterView clusterView = new DefaultClusterView(obj.getString("id"));
        JsonArray instancesObj = obj.getJsonArray("instances");
        for (int i = 0; i < instancesObj.size(); ++i) {
            JsonObject anInstance = instancesObj.getJsonObject(i);
            clusterView.addInstanceDescription(Announcement.asInstance(anInstance));
        }
        return clusterView;
    }

    private static JsonObject asJSON(ClusterView clusterView) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("id", clusterView.getId());
        JsonArrayBuilder instancesObj = Json.createArrayBuilder();
        List instances = clusterView.getInstances();
        for (InstanceDescription instanceDescription : instances) {
            instancesObj.add((JsonValue)Announcement.asJSON(instanceDescription));
        }
        obj.add("instances", instancesObj);
        return obj.build();
    }

    private static DefaultInstanceDescription asInstance(JsonObject anInstance) {
        boolean isLeader = anInstance.getBoolean("isLeader");
        String slingId = anInstance.getString("slingId");
        JsonObject propertiesObj = anInstance.getJsonObject("properties");
        Iterator it = propertiesObj.keySet().iterator();
        HashMap<String, String> properties = new HashMap<String, String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            properties.put(key, propertiesObj.getString(key));
        }
        NonLocalInstanceDescription instance = new NonLocalInstanceDescription(null, isLeader, slingId, properties);
        return instance;
    }

    private static JsonObject asJSON(InstanceDescription instanceDescription) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("slingId", instanceDescription.getSlingId());
        obj.add("isLeader", instanceDescription.isLeader());
        ClusterView cluster = instanceDescription.getClusterView();
        if (cluster != null) {
            obj.add("cluster", cluster.getId());
        }
        JsonObjectBuilder propertiesObj = Json.createObjectBuilder();
        Map propertiesMap = instanceDescription.getProperties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            propertiesObj.add((String)entry.getKey(), (String)entry.getValue());
        }
        obj.add("properties", propertiesObj);
        return obj.build();
    }

    public void setLocalCluster(ClusterView localCluster) {
        this.localCluster = localCluster;
    }

    public void addIncomingTopologyAnnouncement(Announcement incomingTopologyAnnouncement) {
        this.incomings.add(incomingTopologyAnnouncement);
    }

    public String asJSON() {
        return Announcement.asJSON((JsonValue)this.asJSONObject(false));
    }

    private static String asJSON(JsonValue json) {
        StringWriter writer = new StringWriter();
        Json.createGenerator((Writer)writer).write(json).close();
        return writer.toString();
    }

    public String getPrimaryKey() {
        return this.ownerId;
    }

    public Collection<InstanceDescription> listInstances() {
        LinkedList<InstanceDescription> instances = new LinkedList<InstanceDescription>();
        instances.addAll(this.localCluster.getInstances());
        for (Announcement incomingAnnouncement : this.incomings) {
            instances.addAll(incomingAnnouncement.listInstances());
        }
        return instances;
    }

    public void persistTo(Resource announcementsResource) throws PersistenceException {
        Resource announcementChildResource = announcementsResource.getChild(this.getPrimaryKey());
        String announcementJson = this.asJSON();
        if (announcementChildResource == null) {
            ResourceResolver resourceResolver = announcementsResource.getResourceResolver();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("topologyAnnouncement", announcementJson);
            resourceResolver.create(announcementsResource, this.getPrimaryKey(), properties);
        } else {
            ModifiableValueMap announcementChildMap = (ModifiableValueMap)announcementChildResource.adaptTo(ModifiableValueMap.class);
            announcementChildMap.put((Object)"topologyAnnouncement", (Object)announcementJson);
        }
    }

    public void removeInherited(String ownerId) {
        Iterator<Announcement> it = this.incomings.iterator();
        while (it.hasNext()) {
            Announcement anIncomingAnnouncement = it.next();
            if (!anIncomingAnnouncement.isInherited() || !anIncomingAnnouncement.getOwnerId().equals(ownerId)) continue;
            it.remove();
        }
    }

    public boolean correspondsTo(Announcement announcement) {
        JsonObject myJson = this.asJSONObject(true);
        JsonObject otherJson = announcement.asJSONObject(true);
        return Announcement.asJSON((JsonValue)myJson).equals(Announcement.asJSON((JsonValue)otherJson));
    }

    public void registerPing(Announcement incomingAnnouncement) {
        this.originallyCreatedAt = incomingAnnouncement.originallyCreatedAt;
        this.receivedAt = incomingAnnouncement.receivedAt;
    }

    static {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("org.apache.johnzon.supports-comments", true);
        jsonReaderFactory = Json.createReaderFactory(config);
    }
}

