/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.fsclassloader.impl.CacheLocationUtils;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderComponentConfig;
import org.apache.sling.commons.fsclassloader.impl.ScriptFiles;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, configurationPid={"org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider"}, property={"service.description=Web Console for the FileSystem Class Loader", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=fsclassloader", "felix.webconsole.title=File System Class Loader", "felix.webconsole.css=fsclassloader/res/ui/prettify.css", "felix.webconsole.category=Sling"})
public class FSClassLoaderWebConsole
extends AbstractWebConsolePlugin {
    static final String APP_ROOT = "fsclassloader";
    static final String RES_LOC = "fsclassloader/res/ui";
    static final String POST_PARAM_CLEAR_CLASSLOADER = "clear";
    private static final Logger LOG = LoggerFactory.getLogger(FSClassLoaderWebConsole.class);
    @Reference(target="(component.name=org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider)")
    private ClassLoaderWriter classLoaderWriter;
    private File root;
    private static final long serialVersionUID = -5728679635644481848L;
    private ServletConfig config;

    @Activate
    protected void activate(ComponentContext componentContext, FSClassLoaderComponentConfig config) {
        this.root = CacheLocationUtils.getRootDir(componentContext.getBundleContext(), config);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            block8: {
                String file;
                block9: {
                    file = request.getParameter("download");
                    File toDownload = new File(this.root + file);
                    if (StringUtils.isEmpty((CharSequence)file)) break block8;
                    if (!this.isValid(toDownload)) break block9;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(toDownload);
                        response.setHeader("Content-disposition", "attachment; filename=" + toDownload.getName());
                        IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly((OutputStream)response.getOutputStream());
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)response.getOutputStream());
                    break block10;
                }
                response.sendError(404, "File " + file + " not found");
                break block10;
            }
            if (request.getRequestURI().endsWith("fsclassloader/res/ui/prettify.css")) {
                response.setContentType("text/css");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.css"), (OutputStream)response.getOutputStream());
            } else if (request.getRequestURI().endsWith("fsclassloader/res/ui/prettify.js")) {
                response.setContentType("application/javascript");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.js"), (OutputStream)response.getOutputStream());
            } else if (request.getRequestURI().endsWith("fsclassloader/res/ui/fsclassloader.js")) {
                response.setContentType("application/javascript");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/fsclassloader.js"), (OutputStream)response.getOutputStream());
            } else {
                super.doGet(request, response);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clear = req.getParameter(POST_PARAM_CLEAR_CLASSLOADER);
        boolean shouldClear = Boolean.parseBoolean(clear);
        if (shouldClear) {
            if (this.classLoaderWriter != null) {
                boolean result = this.classLoaderWriter.delete("");
                if (result) {
                    resp.getWriter().write("{ \"status\" : \"success\" }");
                    resp.setStatus(200);
                } else {
                    resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"unable to clear classloader; check server log\" }");
                    resp.setStatus(500);
                }
            } else {
                LOG.error("Cannot get a reference to org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider");
                resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"unable to clear classloader; check server log\" }");
                resp.setStatus(500);
            }
        } else {
            resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"invalid command\" }");
            resp.setStatus(400);
        }
    }

    public String getLabel() {
        return APP_ROOT;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    public String getTitle() {
        return "File System Class Loader";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    private boolean isValid(File file) throws IOException {
        if (file.isFile()) {
            for (File parent = file.getCanonicalFile().getAbsoluteFile().getParentFile(); parent != null; parent = parent.getParentFile()) {
                if (!parent.getCanonicalPath().equals(this.root.getCanonicalPath())) continue;
                return true;
            }
        }
        return false;
    }

    protected static void readFiles(File current, File root, Map<String, ScriptFiles> scripts) throws IOException {
        if (current.isDirectory()) {
            File[] children = current.listFiles();
            if (children != null) {
                for (File f : children) {
                    FSClassLoaderWebConsole.readFiles(f, root, scripts);
                }
            }
        } else {
            String script = ScriptFiles.getScript(root, current);
            if (!scripts.containsKey(script) && current.getName().endsWith(".java")) {
                scripts.put(script, new ScriptFiles(root, current));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter w;
        block7: {
            LinkedHashMap<String, ScriptFiles> scripts;
            block5: {
                String file;
                block6: {
                    scripts = new LinkedHashMap<String, ScriptFiles>();
                    FSClassLoaderWebConsole.readFiles(this.root, this.root, scripts);
                    w = response.getWriter();
                    ((Writer)w).write("<link rel=\"stylesheet\" type=\"text/css\" href=\"fsclassloader/res/ui/prettify.css\"></link>");
                    ((Writer)w).write("<script type=\"text/javascript\" src=\"fsclassloader/res/ui/prettify.js\"></script>");
                    ((Writer)w).write("<script type=\"text/javascript\" src=\"fsclassloader/res/ui/fsclassloader.js\"></script>");
                    ((Writer)w).write("<script>$(document).ready(prettyPrint);</script>");
                    ((Writer)w).write("<style>.prettyprint ol.linenums > li { list-style-type: decimal; } pre.prettyprint { white-space: pre-wrap; }</style>");
                    file = request.getParameter("view");
                    File toView = new File(this.root + file);
                    ((Writer)w).write("<div id=\"classes\">");
                    if (StringUtils.isEmpty((CharSequence)file)) break block5;
                    if (!this.isValid(toView)) break block6;
                    ((Writer)w).write("<p class=\"statline ui-state-highlight\">Viewing Script: " + this.root + file + "</p><br/><br/>");
                    ScriptFiles scriptFiles = new ScriptFiles(this.root, toView);
                    ((Writer)w).write("<table class=\"nicetable ui-widget\">");
                    ((Writer)w).write("<tr class=\"header ui-widget-header\">");
                    ((Writer)w).write("<th>Script</th>");
                    ((Writer)w).write("<th>Class</th>");
                    ((Writer)w).write("<th>Deps</th>");
                    ((Writer)w).write("<th>Java</th>");
                    ((Writer)w).write("</tr>");
                    ((Writer)w).write("<tr class=\"ui-state-default\">");
                    ((Writer)w).write("<td>" + scriptFiles.getScript() + "</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getClassFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getDepsFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getJavaFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("</tr>");
                    ((Writer)w).write("</table><br/><br/>");
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(toView);
                        String contents = IOUtils.toString((InputStream)is, (String)"UTF-8");
                        ((Writer)w).write("<pre class=\"prettyprint linenums\">");
                        ((Writer)w).write(StringEscapeUtils.escapeHtml4((String)contents));
                        ((Writer)w).write("</pre>");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block7;
                }
                response.sendError(404, "File " + file + " not found");
                break block7;
            }
            ((Writer)w).write("<p class=\"statline ui-state-highlight\">File System ClassLoader Root: " + this.root + " <span style=\"float: right\"><button type='button' id='clear'>Clear Class Loader</button></span></p>");
            if (scripts.values().size() > 0) {
                ((Writer)w).write("<table class=\"nicetable ui-widget fsclassloader-has-classes\">");
            } else {
                ((Writer)w).write("<table class=\"nicetable ui-widget\">");
            }
            ((Writer)w).write("<tr class=\"header ui-widget-header\">");
            ((Writer)w).write("<th>View</th>");
            ((Writer)w).write("<th>Script</th>");
            ((Writer)w).write("</tr>");
            int i = 0;
            for (ScriptFiles scriptFiles : scripts.values()) {
                ((Writer)w).write("<tr class=\"" + (i % 2 == 0 ? "even" : "odd") + " ui-state-default\">");
                ((Writer)w).write("<td>[<a href=\"?view=" + scriptFiles.getJavaFile() + "\">view</a>]</td>");
                ((Writer)w).write("<td>" + scriptFiles.getScript() + "</td>");
                ((Writer)w).write("</tr>");
                ++i;
            }
            ((Writer)w).write("</table>");
        }
        ((Writer)w).write("</div>");
    }
}

