/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.ComponentPolicy;
import org.apache.sling.cms.ComponentPolicyManager;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.internal.models.PageManagerImpl;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={ComponentPolicyManager.class})
public class ComponentPolicyManagerImpl
implements ComponentPolicyManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentPolicyManagerImpl.class);
    private final ComponentPolicy componentPolicy;

    public ComponentPolicyManagerImpl(Resource resource) {
        this.componentPolicy = Optional.ofNullable(new PageManagerImpl(resource).getPage()).map(Page::getTemplate).map(t -> {
            log.debug("Loading policies for template: {}", t);
            return t.getComponentPolicies().stream().filter(cp -> cp.applies(resource)).findFirst().orElse(null);
        }).orElse(null);
        log.debug("Loaded component policy: {}", (Object)this.componentPolicy);
    }

    public ComponentPolicy getComponentPolicy() {
        return this.componentPolicy;
    }
}

