/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapUtil;
import org.jetbrains.annotations.NotNull;

public class SyntheticResource
extends AbstractResource {
    private final ResourceResolver resourceResolver;
    private final String path;
    private final String resourceType;
    private final ResourceMetadata resourceMetadata;

    public SyntheticResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @NotNull String resourceType) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.resourceType = resourceType;
        this.resourceMetadata = new ResourceMetadata();
        this.resourceMetadata.setResolutionPath(path);
    }

    public SyntheticResource(@NotNull ResourceResolver resourceResolver, @NotNull ResourceMetadata rm, @NotNull String resourceType) {
        this.resourceResolver = resourceResolver;
        this.path = rm.getResolutionPath();
        this.resourceType = resourceType;
        this.resourceMetadata = rm;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getResourceSuperType() {
        return null;
    }

    @Override
    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    @Override
    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            ValueMapDecorator newValueMap = new ValueMapDecorator(Map.of("sling:resourceType", this.resourceType));
            ValueMap originalValueMap = super.adaptTo(ValueMap.class);
            if (originalValueMap != null) {
                return (AdapterType)ValueMapUtil.merge(newValueMap, originalValueMap);
            }
            return (AdapterType)newValueMap;
        }
        return super.adaptTo(type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", type=" + this.getResourceType() + ", path=" + this.getPath();
    }
}

