/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.javassist;

import com.fasterxml.jackson.databind.JavaType;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;
import org.apache.servicecomb.common.javassist.CtTypeJavaType;
import org.apache.servicecomb.common.javassist.JavassistUtils;

public class CtType {
    private static final ClassPool PRIMITIVE_CLASSPOOL = JavassistUtils.getOrCreateClassPool(Integer.TYPE.getClassLoader());
    private CtClass ctClass;
    private boolean hasGenericTypes;
    private String genericSignature;

    public CtType(CtClass ctClass) {
        SignatureAttribute.ClassType classType = new SignatureAttribute.ClassType(ctClass.getName(), null);
        this.init(ctClass, false, classType.encode());
    }

    public CtType(CtClass ctClass, boolean hasGenericTypes, String genericSignature) {
        this.init(ctClass, hasGenericTypes, genericSignature);
    }

    public CtType(JavaType javaType) {
        if (CtTypeJavaType.class.isInstance(javaType)) {
            CtType ctType = ((CtTypeJavaType)javaType).getType();
            this.init(ctType.ctClass, ctType.hasGenericTypes, ctType.genericSignature);
            return;
        }
        ClassLoader classLoader = javaType.getRawClass().getClassLoader();
        try {
            ClassPool classPool = JavassistUtils.getOrCreateClassPool(classLoader);
            this.init(classPool.get(javaType.getRawClass().getCanonicalName()), javaType.hasGenericTypes(), javaType.getGenericSignature());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(String.format("Failed to get CtClass for %s in classloader %s.", javaType.getRawClass().getName(), classLoader), e);
        }
    }

    private void init(CtClass ctClass, boolean hasGenericTypes, String genericSignature) {
        if (ctClass.isPrimitive() && !Void.TYPE.getName().equals(ctClass.getName())) {
            try {
                ctClass = PRIMITIVE_CLASSPOOL.get(((CtPrimitiveType)ctClass).getWrapperName());
            }
            catch (NotFoundException e) {
                throw new IllegalStateException("Impossible exception.", e);
            }
        }
        this.ctClass = ctClass;
        this.genericSignature = genericSignature.replace("[B;>", "[B>");
        this.hasGenericTypes = hasGenericTypes;
    }

    public CtClass getCtClass() {
        return this.ctClass;
    }

    public boolean hasGenericTypes() {
        return this.hasGenericTypes;
    }

    public String getGenericSignature() {
        return this.genericSignature;
    }
}

