/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.util;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class HmacSHA1Util {
    private static Charset charset = Charset.forName("UTF-8");
    private static String algorithm = "HmacSHA1";

    public static String macSignature(String text, String secretKey) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(secretKey.getBytes(charset), algorithm));
        byte[] bytes = mac.doFinal(text.getBytes(charset));
        return new String(Base64.encodeBase64((byte[])bytes), charset);
    }

    public static boolean validateSign(String text, byte[] input, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        String sign = HmacSHA1Util.macSignature(text, secretKey);
        return sign.equals(new String(input, charset));
    }
}

