/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.schedule;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.running.RunningStats;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.schedule.DelayOffsetSerializeWrapper;

public class ScheduleMessageService
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    private static final long FIRST_DELAY_TIME = 1000L;
    private static final long DELAY_FOR_A_WHILE = 100L;
    private static final long DELAY_FOR_A_PERIOD = 10000L;
    private static final long WAIT_FOR_SHUTDOWN = 5000L;
    private static final long DELAY_FOR_A_SLEEP = 10L;
    private final ConcurrentMap<Integer, Long> delayLevelTable = new ConcurrentHashMap<Integer, Long>(32);
    private final ConcurrentMap<Integer, Long> offsetTable = new ConcurrentHashMap<Integer, Long>(32);
    private final DefaultMessageStore defaultMessageStore;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ScheduledExecutorService deliverExecutorService;
    private MessageStore writeMessageStore;
    private int maxDelayLevel;
    private boolean enableAsyncDeliver = false;
    private ScheduledExecutorService handleExecutorService;
    private final Map<Integer, LinkedBlockingQueue<PutResultProcess>> deliverPendingTable = new ConcurrentHashMap<Integer, LinkedBlockingQueue<PutResultProcess>>(32);

    public ScheduleMessageService(DefaultMessageStore defaultMessageStore) {
        this.defaultMessageStore = defaultMessageStore;
        this.writeMessageStore = defaultMessageStore;
        if (defaultMessageStore != null) {
            this.enableAsyncDeliver = defaultMessageStore.getMessageStoreConfig().isEnableScheduleAsyncDeliver();
        }
    }

    public static int queueId2DelayLevel(int queueId) {
        return queueId + 1;
    }

    public static int delayLevel2QueueId(int delayLevel) {
        return delayLevel - 1;
    }

    public void setWriteMessageStore(MessageStore writeMessageStore) {
        this.writeMessageStore = writeMessageStore;
    }

    public void buildRunningStats(HashMap<String, String> stats) {
        for (Map.Entry next : this.offsetTable.entrySet()) {
            int queueId = ScheduleMessageService.delayLevel2QueueId((Integer)next.getKey());
            long delayOffset = (Long)next.getValue();
            long maxOffset = this.defaultMessageStore.getMaxOffsetInQueue("SCHEDULE_TOPIC_XXXX", queueId);
            String value = String.format("%d,%d", delayOffset, maxOffset);
            String key = String.format("%s_%d", RunningStats.scheduleMessageOffset.name(), next.getKey());
            stats.put(key, value);
        }
    }

    private void updateOffset(int delayLevel, long offset) {
        this.offsetTable.put(delayLevel, offset);
    }

    public long computeDeliverTimestamp(int delayLevel, long storeTimestamp) {
        Long time = (Long)this.delayLevelTable.get(delayLevel);
        if (time != null) {
            return time + storeTimestamp;
        }
        return storeTimestamp + 1000L;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            super.load();
            this.deliverExecutorService = new ScheduledThreadPoolExecutor(this.maxDelayLevel, (ThreadFactory)new ThreadFactoryImpl("ScheduleMessageTimerThread_"));
            if (this.enableAsyncDeliver) {
                this.handleExecutorService = new ScheduledThreadPoolExecutor(this.maxDelayLevel, (ThreadFactory)new ThreadFactoryImpl("ScheduleMessageExecutorHandleThread_"));
            }
            for (Map.Entry entry : this.delayLevelTable.entrySet()) {
                Integer level = (Integer)entry.getKey();
                Long timeDelay = (Long)entry.getValue();
                Long offset = (Long)this.offsetTable.get(level);
                if (null == offset) {
                    offset = 0L;
                }
                if (timeDelay == null) continue;
                if (this.enableAsyncDeliver) {
                    this.handleExecutorService.schedule(new HandlePutResultTask(level), 1000L, TimeUnit.MILLISECONDS);
                }
                this.deliverExecutorService.schedule(new DeliverDelayedMessageTimerTask(level, offset), 1000L, TimeUnit.MILLISECONDS);
            }
            this.deliverExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ScheduleMessageService.this.started.get()) {
                            ScheduleMessageService.this.persist();
                        }
                    }
                    catch (Throwable e) {
                        log.error("scheduleAtFixedRate flush exception", e);
                    }
                }
            }, 10000L, this.defaultMessageStore.getMessageStoreConfig().getFlushDelayOffsetInterval(), TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false) && null != this.deliverExecutorService) {
            this.deliverExecutorService.shutdown();
            try {
                this.deliverExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("deliverExecutorService awaitTermination error", (Throwable)e);
            }
            if (this.handleExecutorService != null) {
                this.handleExecutorService.shutdown();
                try {
                    this.handleExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.error("handleExecutorService awaitTermination error", (Throwable)e);
                }
            }
            if (this.deliverPendingTable != null) {
                for (int i = 1; i <= this.deliverPendingTable.size(); ++i) {
                    log.warn("deliverPendingTable level: {}, size: {}", (Object)i, (Object)this.deliverPendingTable.get(i).size());
                }
            }
            this.persist();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public int getMaxDelayLevel() {
        return this.maxDelayLevel;
    }

    public String encode() {
        return this.encode(false);
    }

    public boolean load() {
        boolean result = super.load();
        result = result && this.parseDelayLevel();
        result = result && this.correctDelayOffset();
        return result;
    }

    public boolean correctDelayOffset() {
        try {
            Iterator iterator = this.delayLevelTable.keySet().iterator();
            while (iterator.hasNext()) {
                int delayLevel = (Integer)iterator.next();
                ConsumeQueue cq = this.defaultMessageStore.findConsumeQueue("SCHEDULE_TOPIC_XXXX", ScheduleMessageService.delayLevel2QueueId(delayLevel));
                Long currentDelayOffset = (Long)this.offsetTable.get(delayLevel);
                if (currentDelayOffset == null || cq == null) continue;
                long correctDelayOffset = currentDelayOffset;
                long cqMinOffset = cq.getMinOffsetInQueue();
                long cqMaxOffset = cq.getMaxOffsetInQueue();
                if (currentDelayOffset < cqMinOffset) {
                    correctDelayOffset = cqMinOffset;
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, cqMaxOffset={}, queueId={}", new Object[]{currentDelayOffset, cqMinOffset, cqMaxOffset, cq.getQueueId()});
                }
                if (currentDelayOffset > cqMaxOffset) {
                    correctDelayOffset = cqMaxOffset;
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, cqMaxOffset={}, queueId={}", new Object[]{currentDelayOffset, cqMinOffset, cqMaxOffset, cq.getQueueId()});
                }
                if (correctDelayOffset == currentDelayOffset) continue;
                log.error("correct delay offset [ delayLevel {} ] from {} to {}", new Object[]{delayLevel, currentDelayOffset, correctDelayOffset});
                this.offsetTable.put(delayLevel, correctDelayOffset);
            }
        }
        catch (Exception e) {
            log.error("correctDelayOffset exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public String configFilePath() {
        return StorePathConfigHelper.getDelayOffsetStorePath(this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper;
        if (jsonString != null && (delayOffsetSerializeWrapper = (DelayOffsetSerializeWrapper)((Object)DelayOffsetSerializeWrapper.fromJson((String)jsonString, DelayOffsetSerializeWrapper.class))) != null) {
            this.offsetTable.putAll(delayOffsetSerializeWrapper.getOffsetTable());
        }
    }

    public String encode(boolean prettyFormat) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper = new DelayOffsetSerializeWrapper();
        delayOffsetSerializeWrapper.setOffsetTable(this.offsetTable);
        return delayOffsetSerializeWrapper.toJson(prettyFormat);
    }

    public boolean parseDelayLevel() {
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.defaultMessageStore.getMessageStoreConfig().getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                if (level > this.maxDelayLevel) {
                    this.maxDelayLevel = level;
                }
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
                if (!this.enableAsyncDeliver) continue;
                this.deliverPendingTable.put(level, new LinkedBlockingQueue());
            }
        }
        catch (Exception e) {
            log.error("parseDelayLevel exception", (Throwable)e);
            log.info("levelString String = {}", (Object)levelString);
            return false;
        }
        return true;
    }

    private MessageExtBrokerInner messageTimeup(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        TopicFilterType topicFilterType = MessageExt.parseTopicFilterType((int)msgInner.getSysFlag());
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode(topicFilterType, msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        MessageAccessor.clearProperty((Message)msgInner, (String)"DELAY");
        msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
        String queueIdStr = msgInner.getProperty("REAL_QID");
        int queueId = Integer.parseInt(queueIdStr);
        msgInner.setQueueId(queueId);
        return msgInner;
    }

    public static enum ProcessStatus {
        RUNNING,
        SUCCESS,
        EXCEPTION,
        SKIP;

    }

    public class PutResultProcess {
        private String topic;
        private long offset;
        private long physicOffset;
        private int physicSize;
        private int delayLevel;
        private String msgId;
        private boolean autoResend = false;
        private CompletableFuture<PutMessageResult> future;
        private volatile int resendCount = 0;
        private volatile ProcessStatus status = ProcessStatus.RUNNING;

        public PutResultProcess setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public PutResultProcess setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public PutResultProcess setPhysicOffset(long physicOffset) {
            this.physicOffset = physicOffset;
            return this;
        }

        public PutResultProcess setPhysicSize(int physicSize) {
            this.physicSize = physicSize;
            return this;
        }

        public PutResultProcess setDelayLevel(int delayLevel) {
            this.delayLevel = delayLevel;
            return this;
        }

        public PutResultProcess setMsgId(String msgId) {
            this.msgId = msgId;
            return this;
        }

        public PutResultProcess setAutoResend(boolean autoResend) {
            this.autoResend = autoResend;
            return this;
        }

        public PutResultProcess setFuture(CompletableFuture<PutMessageResult> future) {
            this.future = future;
            return this;
        }

        public String getTopic() {
            return this.topic;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getNextOffset() {
            return this.offset + 1L;
        }

        public long getPhysicOffset() {
            return this.physicOffset;
        }

        public int getPhysicSize() {
            return this.physicSize;
        }

        public Integer getDelayLevel() {
            return this.delayLevel;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public boolean isAutoResend() {
            return this.autoResend;
        }

        public CompletableFuture<PutMessageResult> getFuture() {
            return this.future;
        }

        public int getResendCount() {
            return this.resendCount;
        }

        public PutResultProcess thenProcess() {
            this.future.thenAccept(result -> this.handleResult((PutMessageResult)result));
            this.future.exceptionally(e -> {
                log.error("ScheduleMessageService put message exceptionally, info: {}", (Object)this.toString(), e);
                this.onException();
                return null;
            });
            return this;
        }

        private void handleResult(PutMessageResult result) {
            if (result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                this.onSuccess(result);
            } else {
                log.warn("ScheduleMessageService put message failed. info: {}.", (Object)result);
                this.onException();
            }
        }

        public void onSuccess(PutMessageResult result) {
            this.status = ProcessStatus.SUCCESS;
            if (ScheduleMessageService.this.defaultMessageStore.getMessageStoreConfig().isEnableScheduleMessageStats()) {
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incQueueGetNums("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", this.delayLevel - 1, result.getAppendMessageResult().getMsgNum());
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incQueueGetSize("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", this.delayLevel - 1, result.getAppendMessageResult().getWroteBytes());
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incGroupGetNums("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", result.getAppendMessageResult().getMsgNum());
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incGroupGetSize("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", result.getAppendMessageResult().getWroteBytes());
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incTopicPutNums(this.topic, result.getAppendMessageResult().getMsgNum(), 1);
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incTopicPutSize(this.topic, result.getAppendMessageResult().getWroteBytes());
                ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incBrokerPutNums(result.getAppendMessageResult().getMsgNum());
            }
        }

        public void onException() {
            log.warn("ScheduleMessageService onException, info: {}", (Object)this.toString());
            if (this.autoResend) {
                this.resend();
            } else {
                this.status = ProcessStatus.SKIP;
            }
        }

        public ProcessStatus getStatus() {
            return this.status;
        }

        public PutMessageResult get() {
            try {
                return this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null);
            }
        }

        private void resend() {
            log.info("Resend message, info: {}", (Object)this.toString());
            try {
                Thread.sleep(Math.min(this.resendCount++ * 100, 60000));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                MessageExt msgExt = ScheduleMessageService.this.defaultMessageStore.lookMessageByOffset(this.physicOffset, this.physicSize);
                if (msgExt == null) {
                    log.warn("ScheduleMessageService resend not found message. info: {}", (Object)this.toString());
                    this.status = this.need2Skip() ? ProcessStatus.SKIP : ProcessStatus.EXCEPTION;
                    return;
                }
                MessageExtBrokerInner msgInner = ScheduleMessageService.this.messageTimeup(msgExt);
                PutMessageResult result = ScheduleMessageService.this.writeMessageStore.putMessage(msgInner);
                this.handleResult(result);
                if (result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                    log.info("Resend message success, info: {}", (Object)this.toString());
                }
            }
            catch (Exception e) {
                this.status = ProcessStatus.EXCEPTION;
                log.error("Resend message error, info: {}", (Object)this.toString(), (Object)e);
            }
        }

        public boolean need2Blocked() {
            int maxResendNum2Blocked = ScheduleMessageService.this.defaultMessageStore.getMessageStoreConfig().getScheduleAsyncDeliverMaxResendNum2Blocked();
            return this.resendCount > maxResendNum2Blocked;
        }

        public boolean need2Skip() {
            int maxResendNum2Blocked = ScheduleMessageService.this.defaultMessageStore.getMessageStoreConfig().getScheduleAsyncDeliverMaxResendNum2Blocked();
            return this.resendCount > maxResendNum2Blocked * 2;
        }

        public String toString() {
            return "PutResultProcess{topic='" + this.topic + '\'' + ", offset=" + this.offset + ", physicOffset=" + this.physicOffset + ", physicSize=" + this.physicSize + ", delayLevel=" + this.delayLevel + ", msgId='" + this.msgId + '\'' + ", autoResend=" + this.autoResend + ", resendCount=" + this.resendCount + ", status=" + (Object)((Object)this.status) + '}';
        }
    }

    public class HandlePutResultTask
    implements Runnable {
        private final int delayLevel;

        public HandlePutResultTask(int delayLevel) {
            this.delayLevel = delayLevel;
        }

        @Override
        public void run() {
            PutResultProcess putResultProcess;
            LinkedBlockingQueue pendingQueue = (LinkedBlockingQueue)ScheduleMessageService.this.deliverPendingTable.get(this.delayLevel);
            while ((putResultProcess = (PutResultProcess)pendingQueue.peek()) != null) {
                try {
                    switch (putResultProcess.getStatus()) {
                        case SUCCESS: {
                            ScheduleMessageService.this.updateOffset(this.delayLevel, putResultProcess.getNextOffset());
                            pendingQueue.remove();
                            break;
                        }
                        case RUNNING: {
                            break;
                        }
                        case EXCEPTION: {
                            if (!ScheduleMessageService.this.isStarted()) {
                                log.warn("HandlePutResultTask shutdown, info={}", (Object)putResultProcess.toString());
                                return;
                            }
                            log.warn("putResultProcess error, info={}", (Object)putResultProcess.toString());
                            putResultProcess.onException();
                            break;
                        }
                        case SKIP: {
                            log.warn("putResultProcess skip, info={}", (Object)putResultProcess.toString());
                            pendingQueue.remove();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("HandlePutResultTask exception. info={}", (Object)putResultProcess.toString(), (Object)e);
                    putResultProcess.onException();
                }
            }
            if (ScheduleMessageService.this.isStarted()) {
                ScheduleMessageService.this.handleExecutorService.schedule(new HandlePutResultTask(this.delayLevel), 10L, TimeUnit.MILLISECONDS);
            }
        }
    }

    class DeliverDelayedMessageTimerTask
    implements Runnable {
        private final int delayLevel;
        private final long offset;

        public DeliverDelayedMessageTimerTask(int delayLevel, long offset) {
            this.delayLevel = delayLevel;
            this.offset = offset;
        }

        @Override
        public void run() {
            try {
                if (ScheduleMessageService.this.isStarted()) {
                    this.executeOnTimeup();
                }
            }
            catch (Exception e) {
                log.error("ScheduleMessageService, executeOnTimeup exception", (Throwable)e);
                this.scheduleNextTimerTask(this.offset, 10000L);
            }
        }

        private long correctDeliverTimestamp(long now, long deliverTimestamp) {
            long result = deliverTimestamp;
            long maxTimestamp = now + (Long)ScheduleMessageService.this.delayLevelTable.get(this.delayLevel);
            if (deliverTimestamp > maxTimestamp) {
                result = now;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOnTimeup() {
            ConsumeQueue cq = ScheduleMessageService.this.defaultMessageStore.findConsumeQueue("SCHEDULE_TOPIC_XXXX", ScheduleMessageService.delayLevel2QueueId(this.delayLevel));
            if (cq == null) {
                this.scheduleNextTimerTask(this.offset, 100L);
                return;
            }
            SelectMappedBufferResult bufferCQ = cq.getIndexBuffer(this.offset);
            if (bufferCQ == null) {
                long resetOffset = cq.getMinOffsetInQueue();
                if (resetOffset > this.offset) {
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, queueId={}", new Object[]{this.offset, resetOffset, cq.getQueueId()});
                } else {
                    resetOffset = cq.getMaxOffsetInQueue();
                    if (resetOffset < this.offset) {
                        log.error("schedule CQ offset invalid. offset={}, cqMaxOffset={}, queueId={}", new Object[]{this.offset, resetOffset, cq.getQueueId()});
                    } else {
                        resetOffset = this.offset;
                    }
                }
                this.scheduleNextTimerTask(resetOffset, 100L);
                return;
            }
            long nextOffset = this.offset;
            try {
                int i;
                ConsumeQueueExt.CqExtUnit cqExtUnit = new ConsumeQueueExt.CqExtUnit();
                for (i = 0; i < bufferCQ.getSize() && ScheduleMessageService.this.isStarted(); i += 20) {
                    long offsetPy = bufferCQ.getByteBuffer().getLong();
                    int sizePy = bufferCQ.getByteBuffer().getInt();
                    long tagsCode = bufferCQ.getByteBuffer().getLong();
                    if (cq.isExtAddr(tagsCode)) {
                        if (cq.getExt(tagsCode, cqExtUnit)) {
                            tagsCode = cqExtUnit.getTagsCode();
                        } else {
                            log.error("[BUG] can't find consume queue extend file content!addr={}, offsetPy={}, sizePy={}", new Object[]{tagsCode, offsetPy, sizePy});
                            long msgStoreTime = ScheduleMessageService.this.defaultMessageStore.getCommitLog().pickupStoreTimestamp(offsetPy, sizePy);
                            tagsCode = ScheduleMessageService.this.computeDeliverTimestamp(this.delayLevel, msgStoreTime);
                        }
                    }
                    long now = System.currentTimeMillis();
                    long deliverTimestamp = this.correctDeliverTimestamp(now, tagsCode);
                    nextOffset = this.offset + (long)(i / 20);
                    long countdown = deliverTimestamp - now;
                    if (countdown > 0L) {
                        this.scheduleNextTimerTask(nextOffset, 100L);
                        return;
                    }
                    MessageExt msgExt = ScheduleMessageService.this.defaultMessageStore.lookMessageByOffset(offsetPy, sizePy);
                    if (msgExt == null) continue;
                    MessageExtBrokerInner msgInner = ScheduleMessageService.this.messageTimeup(msgExt);
                    if ("RMQ_SYS_TRANS_HALF_TOPIC".equals(msgInner.getTopic())) {
                        log.error("[BUG] the real topic of schedule msg is {}, discard the msg. msg={}", (Object)msgInner.getTopic(), (Object)msgInner);
                        continue;
                    }
                    boolean deliverSuc = ScheduleMessageService.this.enableAsyncDeliver ? this.asyncDeliver(msgInner, msgExt.getMsgId(), this.offset, offsetPy, sizePy) : this.syncDeliver(msgInner, msgExt.getMsgId(), this.offset, offsetPy, sizePy);
                    if (deliverSuc) continue;
                    this.scheduleNextTimerTask(nextOffset, 100L);
                    return;
                }
                nextOffset = this.offset + (long)(i / 20);
            }
            catch (Exception e) {
                log.error("ScheduleMessageService, messageTimeup execute error, offset = {}", (Object)nextOffset, (Object)e);
            }
            finally {
                bufferCQ.release();
            }
            this.scheduleNextTimerTask(nextOffset, 100L);
        }

        public void scheduleNextTimerTask(long offset, long delay) {
            ScheduleMessageService.this.deliverExecutorService.schedule(new DeliverDelayedMessageTimerTask(this.delayLevel, offset), delay, TimeUnit.MILLISECONDS);
        }

        private boolean syncDeliver(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy) {
            boolean sendStatus;
            PutResultProcess resultProcess = this.deliverMessage(msgInner, msgId, offset, offsetPy, sizePy, false);
            PutMessageResult result = resultProcess.get();
            boolean bl = sendStatus = result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK;
            if (sendStatus) {
                ScheduleMessageService.this.updateOffset(this.delayLevel, resultProcess.getNextOffset());
            }
            return sendStatus;
        }

        private boolean asyncDeliver(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy) {
            int maxPendingLimit;
            Queue processesQueue = (Queue)ScheduleMessageService.this.deliverPendingTable.get(this.delayLevel);
            int currentPendingNum = processesQueue.size();
            if (currentPendingNum > (maxPendingLimit = ScheduleMessageService.this.defaultMessageStore.getMessageStoreConfig().getScheduleAsyncDeliverMaxPendingLimit())) {
                log.warn("Asynchronous deliver triggers flow control, currentPendingNum={}, maxPendingLimit={}", (Object)currentPendingNum, (Object)maxPendingLimit);
                return false;
            }
            PutResultProcess firstProcess = (PutResultProcess)processesQueue.peek();
            if (firstProcess != null && firstProcess.need2Blocked()) {
                log.warn("Asynchronous deliver block. info={}", (Object)firstProcess.toString());
                return false;
            }
            PutResultProcess resultProcess = this.deliverMessage(msgInner, msgId, offset, offsetPy, sizePy, true);
            processesQueue.add(resultProcess);
            return true;
        }

        private PutResultProcess deliverMessage(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy, boolean autoResend) {
            CompletableFuture<PutMessageResult> future = ScheduleMessageService.this.writeMessageStore.asyncPutMessage(msgInner);
            return new PutResultProcess().setTopic(msgInner.getTopic()).setDelayLevel(this.delayLevel).setOffset(offset).setPhysicOffset(offsetPy).setPhysicSize(sizePy).setMsgId(msgId).setAutoResend(autoResend).setFuture(future).thenProcess();
        }
    }
}

