/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.cs.channel.ChannelCloseFrom;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.facotry.MqttMessageFactory;
import org.apache.rocketmq.mqtt.cs.session.infly.InFlyCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttPublishHandler
implements MqttPacketHandler<MqttPublishMessage> {
    private static Logger logger = LoggerFactory.getLogger(MqttPublishHandler.class);
    @Resource
    private InFlyCache inFlyCache;
    @Resource
    private ChannelManager channelManager;

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttPublishMessage mqttMessage) {
        boolean dup;
        MqttPublishVariableHeader variableHeader = mqttMessage.variableHeader();
        Channel channel = ctx.channel();
        String channelId = ChannelInfo.getId(channel);
        boolean isQos2 = this.isQos2Message(mqttMessage);
        boolean bl = dup = isQos2 && this.inFlyCache.contains(InFlyCache.CacheType.PUB, channelId, variableHeader.packetId());
        if (dup) {
            this.doResponse(ctx, mqttMessage);
            return false;
        }
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttPublishMessage mqttMessage, HookResult upstreamHookResult) {
        MqttPublishVariableHeader variableHeader = mqttMessage.variableHeader();
        Channel channel = ctx.channel();
        String channelId = ChannelInfo.getId(channel);
        if (!upstreamHookResult.isSuccess()) {
            this.channelManager.closeConnect(channel, ChannelCloseFrom.SERVER, upstreamHookResult.getRemark());
            return;
        }
        this.doResponse(ctx, mqttMessage);
        boolean isQos2Message = this.isQos2Message(mqttMessage);
        if (isQos2Message && !this.inFlyCache.contains(InFlyCache.CacheType.PUB, channelId, variableHeader.packetId())) {
            this.inFlyCache.put(InFlyCache.CacheType.PUB, channelId, variableHeader.packetId());
        }
    }

    private boolean isQos2Message(MqttPublishMessage mqttPublishMessage) {
        return MqttQoS.EXACTLY_ONCE.equals((Object)mqttPublishMessage.fixedHeader().qosLevel());
    }

    private void doResponse(ChannelHandlerContext ctx, MqttPublishMessage mqttMessage) {
        MqttFixedHeader fixedHeader = mqttMessage.fixedHeader();
        MqttPublishVariableHeader variableHeader = mqttMessage.variableHeader();
        int messageId = variableHeader.packetId();
        switch (fixedHeader.qosLevel()) {
            case AT_MOST_ONCE: {
                break;
            }
            case AT_LEAST_ONCE: {
                ctx.channel().writeAndFlush((Object)MqttMessageFactory.buildPubAckMessage(messageId));
                break;
            }
            case EXACTLY_ONCE: {
                ctx.channel().writeAndFlush((Object)MqttMessageFactory.buildPubRecMessage(messageId));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown qos:" + fixedHeader.qosLevel());
            }
        }
    }
}

