/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent;

import com.alipay.sofa.jraft.rhea.util.UniqueIdUtil;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class DistributedLock<T> {
    private final T internalKey;
    private final Acquirer acquirer;
    private final ScheduledExecutorService watchdog;
    private volatile Owner owner;

    protected DistributedLock(T target, long lease, TimeUnit unit, ScheduledExecutorService watchdog) {
        Requires.requireTrue((lease >= 0L ? 1 : 0) != 0, (Object)"lease must >= 0");
        this.internalKey = this.withInternalKey(target);
        this.acquirer = new Acquirer(UniqueIdUtil.generateId(), unit.toMillis(lease));
        this.watchdog = watchdog;
    }

    public boolean tryLock() {
        return this.tryLock(null);
    }

    public boolean tryLock(byte[] ctx) {
        return this.internalTryLock(ctx).isSuccess();
    }

    public boolean tryLock(long timeout, TimeUnit unit) {
        return this.tryLock(null, timeout, unit);
    }

    public boolean tryLock(byte[] ctx, long timeout, TimeUnit unit) {
        long timeoutNs = unit.toNanos(timeout);
        long startNs = System.nanoTime();
        int attempts = 1;
        try {
            while (true) {
                Owner owner;
                if ((owner = this.internalTryLock(ctx)).isSuccess()) {
                    return true;
                }
                if (System.nanoTime() - startNs < timeoutNs) {
                    if (attempts < 8) {
                        ++attempts;
                    }
                    long remaining = Math.max(0L, owner.getRemainingMillis());
                    Thread.sleep(Math.min(remaining, (long)(2 << attempts)));
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            ThrowUtil.throwException((Throwable)t);
        }
        return false;
    }

    public abstract void unlock();

    public long getFencingToken() {
        return this.acquirer.getFencingToken();
    }

    public byte[] getOwnerContext() {
        return this.getOwner().getContext();
    }

    public ScheduledExecutorService getWatchdog() {
        return this.watchdog;
    }

    public Acquirer getAcquirer() {
        return this.acquirer;
    }

    public Owner getOwner() {
        Owner copy = this.owner;
        if (copy == null) {
            throw new IllegalStateException("must try to lock at first");
        }
        return copy;
    }

    public static OwnerBuilder newOwnerBuilder() {
        return new OwnerBuilder();
    }

    protected abstract Owner internalTryLock(byte[] var1);

    protected T withInternalKey(T target) {
        return target;
    }

    protected T getInternalKey() {
        return this.internalKey;
    }

    protected void updateOwner(Owner owner) {
        this.owner = owner;
    }

    protected void updateOwnerAndAcquirer(Owner owner) {
        this.owner = owner;
        if (this.owner != null) {
            this.owner.updateAcquirerInfo(this.acquirer);
        }
    }

    public static class OwnerBuilder {
        public static long KEEP_LEASE_FAIL = Long.MAX_VALUE;
        public static long FIRST_TIME_SUCCESS = -1L;
        public static long NEW_ACQUIRE_SUCCESS = -2L;
        public static long KEEP_LEASE_SUCCESS = -3L;
        public static long REENTRANT_SUCCESS = -4L;
        private String id;
        private long deadlineMillis;
        private long remainingMillis;
        private long fencingToken;
        private long acquires;
        private byte[] context;
        private boolean success;

        public Owner build() {
            return new Owner(this.id, this.deadlineMillis, this.remainingMillis, this.fencingToken, this.acquires, this.context, this.success);
        }

        public OwnerBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OwnerBuilder deadlineMillis(long deadlineMillis) {
            this.deadlineMillis = deadlineMillis;
            return this;
        }

        public OwnerBuilder remainingMillis(long remainingMillis) {
            this.remainingMillis = remainingMillis;
            return this;
        }

        public OwnerBuilder fencingToken(long fencingToken) {
            this.fencingToken = fencingToken;
            return this;
        }

        public OwnerBuilder acquires(long acquires) {
            this.acquires = acquires;
            return this;
        }

        public OwnerBuilder context(byte[] context) {
            this.context = context;
            return this;
        }

        public OwnerBuilder success(boolean success) {
            this.success = success;
            return this;
        }
    }

    public static class Owner
    implements Serializable {
        private static final long serialVersionUID = 3939239434225894164L;
        private final String id;
        private final long deadlineMillis;
        private final long remainingMillis;
        private final long fencingToken;
        private final long acquires;
        private final byte[] context;
        private final boolean success;

        public Owner(String id, long deadlineMillis, long remainingMillis, long fencingToken, long acquires, byte[] context, boolean success) {
            this.id = id;
            this.deadlineMillis = deadlineMillis;
            this.remainingMillis = remainingMillis;
            this.fencingToken = fencingToken;
            this.acquires = acquires;
            this.context = context;
            this.success = success;
        }

        public boolean isSameAcquirer(Acquirer acquirer) {
            return acquirer != null && this.fencingToken == acquirer.fencingToken && Objects.equals(this.id, acquirer.id);
        }

        public void updateAcquirerInfo(Acquirer acquirer) {
            if (acquirer == null) {
                return;
            }
            acquirer.setFencingToken(this.fencingToken);
        }

        public String getId() {
            return this.id;
        }

        public long getDeadlineMillis() {
            return this.deadlineMillis;
        }

        public long getRemainingMillis() {
            return this.remainingMillis;
        }

        public long getFencingToken() {
            return this.fencingToken;
        }

        public long getAcquires() {
            return this.acquires;
        }

        public byte[] getContext() {
            return this.context;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String toString() {
            return "Owner{id='" + this.id + '\'' + ", deadlineMillis=" + this.deadlineMillis + ", remainingMillis=" + this.remainingMillis + ", fencingToken=" + this.fencingToken + ", acquires=" + this.acquires + ", context=" + BytesUtil.toHex((byte[])this.context) + ", success=" + this.success + '}';
        }
    }

    public static class Acquirer
    implements Serializable {
        private static final long serialVersionUID = -9174459539789423607L;
        private final String id;
        private final long leaseMillis;
        private volatile long lockingTimestamp;
        private volatile long fencingToken;
        private volatile byte[] context;

        public Acquirer(String id, long leaseMillis) {
            this.id = id;
            this.leaseMillis = leaseMillis;
        }

        public String getId() {
            return this.id;
        }

        public long getLeaseMillis() {
            return this.leaseMillis;
        }

        public long getLockingTimestamp() {
            return this.lockingTimestamp;
        }

        public void setLockingTimestamp(long lockingTimestamp) {
            this.lockingTimestamp = lockingTimestamp;
        }

        public long getFencingToken() {
            return this.fencingToken;
        }

        public void setFencingToken(long fencingToken) {
            this.fencingToken = fencingToken;
        }

        public byte[] getContext() {
            return this.context;
        }

        public void setContext(byte[] context) {
            this.context = context;
        }

        public String toString() {
            return "Acquirer{id='" + this.id + '\'' + ", leaseMillis=" + this.leaseMillis + ", lockingTimestamp=" + this.lockingTimestamp + ", fencingToken=" + this.fencingToken + ", context=" + BytesUtil.toHex((byte[])this.context) + '}';
        }
    }
}

