/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> boundaries) {
        super(clock, boundaries.size() + 1, new HistogramCellSelector(boundaries), ReservoirCell::getAndResetDouble);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> boundaries) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndexFor(cells, (double)value, attributes, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
        }

        @Override
        public void reset() {
        }
    }
}

