/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;

public class PushConsumerBuilderImpl
implements PushConsumerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private String consumerGroup = null;
    private Map<String, FilterExpression> subscriptionExpressions = new ConcurrentHashMap<String, FilterExpression>();
    private MessageListener messageListener = null;
    private int maxCacheMessageCount = 1024;
    private int maxCacheMessageSizeInBytes = 0x4000000;
    private int consumptionThreadCount = 20;

    @Override
    public PushConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        return this;
    }

    @Override
    public PushConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull(consumerGroup, "consumerGroup should not be null");
        Preconditions.checkArgument(ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), "consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public PushConsumerBuilder setSubscriptionExpressions(Map<String, FilterExpression> subscriptionExpressions) {
        Preconditions.checkNotNull(subscriptionExpressions, "subscriptionExpressions should not be null");
        Preconditions.checkArgument(!subscriptionExpressions.isEmpty(), "subscriptionExpressions should not be empty");
        this.subscriptionExpressions = subscriptionExpressions;
        return this;
    }

    @Override
    public PushConsumerBuilder setMessageListener(MessageListener messageListener) {
        this.messageListener = Preconditions.checkNotNull(messageListener, "messageListener should not be null");
        return this;
    }

    @Override
    public PushConsumerBuilder setMaxCacheMessageCount(int maxCachedMessageCount) {
        Preconditions.checkArgument(maxCachedMessageCount > 0, "maxCachedMessageCount should be positive");
        this.maxCacheMessageCount = maxCachedMessageCount;
        return this;
    }

    @Override
    public PushConsumerBuilder setMaxCacheMessageSizeInBytes(int maxCacheMessageSizeInBytes) {
        Preconditions.checkArgument(maxCacheMessageSizeInBytes > 0, "maxCacheMessageSizeInBytes should be positive");
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
        return this;
    }

    @Override
    public PushConsumerBuilder setConsumptionThreadCount(int consumptionThreadCount) {
        Preconditions.checkArgument(consumptionThreadCount > 0, "consumptionThreadCount should be positive");
        this.consumptionThreadCount = consumptionThreadCount;
        return this;
    }

    @Override
    public PushConsumer build() throws ClientException {
        Preconditions.checkNotNull(this.clientConfiguration, "clientConfiguration has not been set yet");
        Preconditions.checkNotNull(this.consumerGroup, "consumerGroup has not been set yet");
        Preconditions.checkNotNull(this.messageListener, "messageListener has not been set yet");
        Preconditions.checkArgument(!this.subscriptionExpressions.isEmpty(), "subscriptionExpressions have not been set yet");
        PushConsumerImpl pushConsumer = new PushConsumerImpl(this.clientConfiguration, this.consumerGroup, this.subscriptionExpressions, this.messageListener, this.maxCacheMessageCount, this.maxCacheMessageSizeInBytes, this.consumptionThreadCount);
        pushConsumer.startAsync().awaitRunning();
        return pushConsumer;
    }
}

