/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.RandomUtils;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;

@Immutable
public class SubscriptionLoadBalancer {
    private final AtomicInteger index = new AtomicInteger(RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE));
    private final ImmutableList<MessageQueueImpl> messageQueues;

    public SubscriptionLoadBalancer(TopicRouteData topicRouteData) {
        List mqs = topicRouteData.getMessageQueues().stream().filter(mq -> mq.getPermission().isReadable() && 0 == mq.getBroker().getId()).collect(Collectors.toList());
        if (mqs.isEmpty()) {
            throw new IllegalArgumentException("No readable message queue found, topiRouteData=" + topicRouteData);
        }
        this.messageQueues = ImmutableList.builder().addAll(mqs).build();
    }

    public MessageQueueImpl takeMessageQueue() {
        int next = this.index.getAndIncrement();
        return (MessageQueueImpl)this.messageQueues.get(IntMath.mod((int)next, (int)this.messageQueues.size()));
    }
}

