/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Spec available from here:
// https://de.scribd.com/document/428086428/OpenProtocol-Specification-R-2-8-0-9836-4415-01

[type Constants
    [const          uint 16     tcpDefaultPort 4545]
]

[discriminatedType OpenProtocolMessage(uint 24 revision)
    [implicit      uint 32              length               'lengthInBytes - 1'                encoding='"ASCII"'                      ]
    [discriminator Mid                  mid                                                     encoding='"ASCII"'                      ]
    [optional      uint 24              midRevision                                             encoding='"ASCII"' nullBytesHex='202020']
    [optional      uint 8               noAckFlag                                               encoding='"ASCII"' nullBytesHex='20'    ]
    [optional      uint 16              targetStationId                                         encoding='"ASCII"' nullBytesHex='2020'  ]
    [optional      uint 16              targetSpindleId                                         encoding='"ASCII"' nullBytesHex='2020'  ]
    [optional      uint 16              sequenceNumber                                          encoding='"ASCII"' nullBytesHex='2020'  ]
    [optional      uint 8               numberOfMessageParts                                    encoding='"ASCII"' nullBytesHex='20'    ]
    [optional      uint 8               messagePartNumber                                       encoding='"ASCII"' nullBytesHex='20'    ]
    [typeSwitch mid
        ['ApplicationCommunicationStart' *ApplicationCommunicationStart
        ]
        ['ApplicationCommunicationStartAcknowledge' *ApplicationCommunicationStartAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                    [const    uint   16  blockIdSupplierCode              4    encoding='"ASCII"']
                    [simple   uint   24  supplierCode                          encoding='"ASCII"']
                ]
                ['3' *Rev3
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                    [const    uint   16  blockIdSupplierCode              4    encoding='"ASCII"']
                    [simple   uint   24  supplierCode                          encoding='"ASCII"']
                    [const    uint   16  blockIdOpenProtocolVersion       5    encoding='"ASCII"']
                    [simple   string 152 openProtocolVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSoftwareVersion 6    encoding='"ASCII"']
                    [simple   string 152 controllerSoftwareVersion             encoding='"ASCII"']
                    [const    uint   16  blockIdToolSoftwareVersion       7    encoding='"ASCII"']
                    [simple   string 152 toolSoftwareVersion                   encoding='"ASCII"']
                ]
                ['4' *Rev4
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                    [const    uint   16  blockIdSupplierCode              4    encoding='"ASCII"']
                    [simple   uint   24  supplierCode                          encoding='"ASCII"']
                    [const    uint   16  blockIdOpenProtocolVersion       5    encoding='"ASCII"']
                    [simple   string 152 openProtocolVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSoftwareVersion 6    encoding='"ASCII"']
                    [simple   string 152 controllerSoftwareVersion             encoding='"ASCII"']
                    [const    uint   16  blockIdToolSoftwareVersion       7    encoding='"ASCII"']
                    [simple   string 152 toolSoftwareVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdRbuType                   8    encoding='"ASCII"']
                    [simple   string 192 rbuType                               encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSerialNumber    9    encoding='"ASCII"']
                    [simple   string 80  controllerSerialNumber                encoding='"ASCII"']
                ]
                ['5' *Rev5
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                    [const    uint   16  blockIdSupplierCode              4    encoding='"ASCII"']
                    [simple   uint   24  supplierCode                          encoding='"ASCII"']
                    [const    uint   16  blockIdOpenProtocolVersion       5    encoding='"ASCII"']
                    [simple   string 152 openProtocolVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSoftwareVersion 6    encoding='"ASCII"']
                    [simple   string 152 controllerSoftwareVersion             encoding='"ASCII"']
                    [const    uint   16  blockIdToolSoftwareVersion       7    encoding='"ASCII"']
                    [simple   string 152 toolSoftwareVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdRbuType                   8    encoding='"ASCII"']
                    [simple   string 192 rbuType                               encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSerialNumber    9    encoding='"ASCII"']
                    [simple   string 80  controllerSerialNumber                encoding='"ASCII"']
                    [const    uint   16  blockIdSystemType                10   encoding='"ASCII"']
                    [simple   string 24  systemType                            encoding='"ASCII"']
                    [const    uint   16  blockIdSystemSubtype             11   encoding='"ASCII"']
                    [simple   string 24  systemSubtype                         encoding='"ASCII"']
                ]
                ['6' *Rev6
                    [const    uint   16  blockIdCellId                    1    encoding='"ASCII"']
                    [simple   uint   32  cellId                                encoding='"ASCII"']
                    [const    uint   16  blockIdChannelId                 2    encoding='"ASCII"']
                    [simple   uint   16  channelId                             encoding='"ASCII"']
                    [const    uint   16  blockIdControllerName            3    encoding='"ASCII"']
                    [simple   string 200 controllerName                        encoding='"ASCII"']
                    [const    uint   16  blockIdSupplierCode              4    encoding='"ASCII"']
                    [simple   uint   24  supplierCode                          encoding='"ASCII"']
                    [const    uint   16  blockIdOpenProtocolVersion       5    encoding='"ASCII"']
                    [simple   string 152 openProtocolVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSoftwareVersion 6    encoding='"ASCII"']
                    [simple   string 152 controllerSoftwareVersion             encoding='"ASCII"']
                    [const    uint   16  blockIdToolSoftwareVersion       7    encoding='"ASCII"']
                    [simple   string 152 toolSoftwareVersion                   encoding='"ASCII"']
                    [const    uint   16  blockIdRbuType                   8    encoding='"ASCII"']
                    [simple   string 192 rbuType                               encoding='"ASCII"']
                    [const    uint   16  blockIdControllerSerialNumber    9    encoding='"ASCII"']
                    [simple   string 80  controllerSerialNumber                encoding='"ASCII"']
                    [const    uint   16  blockIdSystemType                10   encoding='"ASCII"']
                    [simple   string 24  systemType                            encoding='"ASCII"']
                    [const    uint   16  blockIdSystemSubtype             11   encoding='"ASCII"']
                    [simple   string 24  systemSubtype                         encoding='"ASCII"']
                    [const    uint   16  blockIdSequenceNumberSupport     12   encoding='"ASCII"']
                    [reserved uint   7   '0x00'                                                  ]
                    [simple   bit        sequenceNumberSupport                                   ]
                    [const    uint   16  blockIdLinkingHandlingSupport    13   encoding='"ASCII"']
                    [reserved uint   7   '0x00'                                                  ]
                    [simple   bit        linkingHandlingSupport                                  ]
                    [const    uint   16  blockIdStationId                 14   encoding='"ASCII"']
                    [simple   string 80  stationId                             encoding='"ASCII"']
                    [const    uint   16  blockIdStationName               15   encoding='"ASCII"']
                    [simple   string 200 stationName                           encoding='"ASCII"']
                    [const    uint   16  blockIdClientId                  16   encoding='"ASCII"']
                    [simple   uint   8   clientId                              encoding='"ASCII"']
                ]
            ]
        ]
        ['ApplicationCommunicationStop' *ApplicationCommunicationStop
        ]
        ['ApplicationCommandError'      *ApplicationCommandError
            [typeSwitch revision
                ['1' *Rev1
                    [simple Mid            requestMid                                           encoding='"ASCII"']
                    [simple ApplicationCommunicationError error                                 encoding='"ASCII"']
                ]
            ]
        ]
        ['ApplicationCommandAccepted'   *ApplicationCommandAccepted
            [typeSwitch revision
                ['1' *Rev1
                    [simple Mid            midNumberAccepted                                    encoding='"ASCII"']
                ]
            ]
        ]
        ['ApplicationGenericDataRequest' *ApplicationGenericDataRequest
            [typeSwitch revision
                ['1' *Rev1
                    [simple   Mid                  requestMid                                           encoding='"ASCII"']
                    [simple   uint 24              wantedRevision                                       encoding='"ASCII"']
                    [implicit uint 16              extraDataLength 'COUNT(extraData)'                   encoding='"ASCII"']
                    [array    byte                 extraData       count 'extraDataLength'                                ]
                ]
            ]
        ]
        ['ApplicationGenericSubscription' *ApplicationGenericSubscription
            [typeSwitch revision
                ['1' *Rev1
                    [simple   Mid                  subscriptionMid                                      encoding='"ASCII"']
                    [simple   uint 24              wantedRevision                                       encoding='"ASCII"']
                    [implicit uint 16              extraDataLength 'COUNT(extraData)'                   encoding='"ASCII"']
                    [array    byte                 extraData       count 'extraDataLength'                                ]
                ]
            ]
        ]
        ['ApplicationGenericUnsubscribe' *ApplicationGenericUnsubscribe
            [typeSwitch revision
                ['1' *Rev1
                    [simple   Mid                  subscriptionMid                                      encoding='"ASCII"']
                    [simple   uint 24              extraDataRevision                                    encoding='"ASCII"']
                    [implicit uint 16              extraDataLength 'COUNT(extraData)'                   encoding='"ASCII"']
                    [array    byte                 extraData       count 'extraDataLength'                                ]
                ]
            ]
        ]
        ['ParameterSetIdUploadRequest' *ParameterSetIdUploadRequest
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['ParameterSetIdUploadReply' *ParameterSetIdUploadReply
            [typeSwitch revision
                ['1' *Rev1
                    [implicit uint 24                numParameters      'COUNT(parameters)'             encoding='"ASCII"']
                    [array    uint 24                parameters         count 'numParameters'           encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [implicit uint 24                numParameters      'COUNT(parameters)'             encoding='"ASCII"']
                    [array    uint 24                parameters         count 'numParameters'           encoding='"ASCII"']
                    [array    uint 16                numberOfCycles     count 'numParameters'           encoding='"ASCII"']
                ]
                ['3' *Rev3
                    [implicit uint 24                numParameters      'COUNT(parameters)'             encoding='"ASCII"']
                    [array    uint 24                parameters         count 'numParameters'           encoding='"ASCII"']
                    [array    uint 16                numberOfCycles     count 'numParameters'           encoding='"ASCII"']
                    [array    uint 32                typeOfProgram      count 'numParameters'           encoding='"ASCII"']
                ]
            ]
        ]
        ['ParameterSetDataUploadRequest' *ParameterSetDataUploadRequest
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint 24                parameterSetId                                     encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [simple   uint 24                parameterSetId                                     encoding='"ASCII"']
                ]
                // Note Rev 3 & 4 are Toyota specific
                // If Toyota had the money and the power to get these updates into the spec,
                // they have enough money to support Open-Source.
            ]
        ]
        ['ParameterSetDataUploadReply' *ParameterSetDataUploadReply
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16  blockIdParameterSetId    1    encoding='"ASCII"']
                    [simple   uint   24  parameterSetId                encoding='"ASCII"']
                    [const    uint   16  blockIdParameterSetName  2    encoding='"ASCII"']
                    [simple   string 200 parameterSetName              encoding='"ASCII"']
                    [const    uint   16  blockIdRotationDirection 3    encoding='"ASCII"']
                    [simple   RotationDirection rotationDirection      encoding='"ASCII"']
                    [const    uint   16  blockIdBatchSize         4    encoding='"ASCII"']
                    [simple   uint   16  batchSize                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueMin         5    encoding='"ASCII"']
                    [simple   uint   48  torqueMin                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueMax         6    encoding='"ASCII"']
                    [simple   uint   48  torqueMax                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueFinalTarget 7    encoding='"ASCII"']
                    [simple   uint   48  torqueFinalTarget             encoding='"ASCII"']
                    [const    uint   16  blockIdAngleMin          8    encoding='"ASCII"']
                    [simple   uint   40  angleMin                      encoding='"ASCII"']
                    [const    uint   16  blockIdAngleMax          9    encoding='"ASCII"']
                    [simple   uint   40  angleMax                      encoding='"ASCII"']
                    [const    uint   16  blockIdFinalAngleTarget  10   encoding='"ASCII"']
                    [simple   uint   40  finalAngleTarget              encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16  blockIdParameterSetId    1    encoding='"ASCII"']
                    [simple   uint   24  parameterSetId                encoding='"ASCII"']
                    [const    uint   16  blockIdParameterSetName  2    encoding='"ASCII"']
                    [simple   string 200 parameterSetName              encoding='"ASCII"']
                    [const    uint   16  blockIdRotationDirection 3    encoding='"ASCII"']
                    [simple   RotationDirection rotationDirection      encoding='"ASCII"']
                    [const    uint   16  blockIdBatchSize         4    encoding='"ASCII"']
                    [simple   uint   16  batchSize                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueMin         5    encoding='"ASCII"']
                    [simple   uint   48  torqueMin                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueMax         6    encoding='"ASCII"']
                    [simple   uint   48  torqueMax                     encoding='"ASCII"']
                    [const    uint   16  blockIdTorqueFinalTarget 7    encoding='"ASCII"']
                    [simple   uint   48  torqueFinalTarget             encoding='"ASCII"']
                    [const    uint   16  blockIdAngleMin          8    encoding='"ASCII"']
                    [simple   uint   40  angleMin                      encoding='"ASCII"']
                    [const    uint   16  blockIdAngleMax          9    encoding='"ASCII"']
                    [simple   uint   40  angleMax                      encoding='"ASCII"']
                    [const    uint   16  blockIdFinalAngleTarget  10   encoding='"ASCII"']
                    [simple   uint   40  finalAngleTarget              encoding='"ASCII"']
                    [const    uint   16  blockIdFirstTarget       11   encoding='"ASCII"']
                    [simple   uint   48  firstTarget                   encoding='"ASCII"']
                    [const    uint   16  blockIdStartFinalAngle   12   encoding='"ASCII"']
                    [simple   uint   48  startFinalAngle               encoding='"ASCII"']
                ]
                // Note Rev 3 & 4 are Toyota specific
                // If Toyota had the money and the power to get these updates into the spec,
                // they have enough money to support Open-Source.
            ]
        ]
        ['ParameterSetSelectedSubscribe' *ParameterSetSelectedSubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['ParameterSetSelected' *ParameterSetSelected
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24  parameterSetId                encoding='"ASCII"']
                    [simple   string 152 dateOfLastChangeInParameterSetSetting encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16         blockIdParameterSetId    1     encoding='"ASCII"']
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName  2     encoding='"ASCII"']
                    [simple   string 200        parameterSetName               encoding='"ASCII"']
                    [const    uint   16         blockIdDateOfLastChangeInParameterSetSetting  3    encoding='"ASCII"']
                    [simple   string 152        dateOfLastChangeInParameterSetSetting              encoding='"ASCII"']
                    [const    uint   16         blockIdRotationDirection 4     encoding='"ASCII"']
                    [simple   RotationDirection rotationDirection              encoding='"ASCII"']
                    [const    uint   16         blockIdBatchSize         5     encoding='"ASCII"']
                    [simple   uint   16         batchSize                      encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMin         6     encoding='"ASCII"']
                    [simple   uint   48         torqueMin                      encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMax         7     encoding='"ASCII"']
                    [simple   uint   48         torqueMax                      encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget 8     encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget              encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin          9     encoding='"ASCII"']
                    [simple   uint   40         angleMin                       encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax          10    encoding='"ASCII"']
                    [simple   uint   40         angleMax                       encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget  11    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget               encoding='"ASCII"']
                    [const    uint   16         blockIdFirstTarget       12    encoding='"ASCII"']
                    [simple   uint   48         firstTarget                    encoding='"ASCII"']
                    [const    uint   16         blockIdStartFinalAngle   13    encoding='"ASCII"']
                    [simple   uint   48         startFinalAngle                encoding='"ASCII"']
                ]
            ]
        ]
        ['ParameterSetSelectedAcknowledge' *ParameterSetSelectedAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['ParameterSetSelectedUnsubscribe' *ParameterSetSelectedUnsubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['SelectParameterSet' *SelectParameterSet
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                ]
            ]
        ]
        ['SetParameterSetBatchSize' *SetParameterSetBatchSize
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                    [simple   uint   16         batchSize                      encoding='"ASCII"']
                ]
            ]
        ]
        ['ResetParameterSetBatchCounter' *ResetParameterSetBatchCounter
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                ]
            ]
        ]
        ['LockAtBatchDoneSubscribe' *LockAtBatchDoneSubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['LockAtBatchDoneUpload' *LockAtBatchDoneUpload
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   8          relayStatus                    encoding='"ASCII"']
                ]
            ]
        ]
        ['LockAtBatchDoneUploadAcknowledge' *LockAtBatchDoneUploadAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['LockAtBatchDoneUnsubscribe' *LockAtBatchDoneUnsubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        // Note MID 0025 is Toyota specific
        // If Toyota had the money and the power to get these updates into the spec,
        // they have enough money to support Open-Source.

        ['DisableTool' *DisableTool
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['EnableTool' *EnableTool
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]

        ['LastTighteningResultDataSubscribe' *LastTighteningResultDataSubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['LastTighteningResultData' *LastTighteningResultData
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16         blockIdCellId                                      1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                   2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                                encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                        3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                     encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                   4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                                encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                       5     encoding='"ASCII"']
                    [simple   uint   16         jobId                                                    encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetId                              6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetId                                           encoding='"ASCII"']
                    [const    uint   16         blockIdBatchSize                                   7     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                                encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                                8     encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                            9     encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                         encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                                10    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                 11    encoding='"ASCII"']
                    [simple   Status            angleStatus                                              encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMinLimit                              12    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                              13    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                           14    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                      15    encoding='"ASCII"']
                    [simple   uint   48         torque                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                    16    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                 encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                    17    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                 encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                            18    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                         encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                       19    encoding='"ASCII"']
                    [simple   uint   40         angle                                                    encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                   20    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                                encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeIndParameterSetSettings 21    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings              encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                 22    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                              encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                                23    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                             encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // We don't need all 5 bytes to implement all bits.
                    [reserved uint 8            '0x30'                                                                     ]
                    [simple   uint 32           strategyOptions                                         encoding='"ASCII"']
                    [virtual  bit               strategyOptionRbwMonitoring     '(strategyOptions & 0x0001) == 0x0001'    ]
                    [virtual  bit               strategyOptionClickWrench       '(strategyOptions & 0x0002) == 0x0002'    ]
                    [virtual  bit               strategyOptionDsControl         '(strategyOptions & 0x0004) == 0x0004'    ]
                    [virtual  bit               strategyOptionCm                '(strategyOptions & 0x0008) == 0x0008'    ]
                    [virtual  bit               strategyOptionRundown           '(strategyOptions & 0x0010) == 0x0010'    ]
                    [virtual  bit               strategyOptionSelfTap           '(strategyOptions & 0x0020) == 0x0020'    ]
                    [virtual  bit               strategyOptionPvtCompensate     '(strategyOptions & 0x0040) == 0x0040'    ]
                    [virtual  bit               strategyOptionPvtMonitoring     '(strategyOptions & 0x0080) == 0x0080'    ]
                    [virtual  bit               strategyOptionBatch             '(strategyOptions & 0x0100) == 0x0100'    ]
                    [virtual  bit               strategyOptionAngle             '(strategyOptions & 0x0200) == 0x0200'    ]
                    [virtual  bit               strategyOptionTorque            '(strategyOptions & 0x0400) == 0x0400'    ]
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // Unfortunately we can only parse unsigned ints up to 64 bits, in this case we need to do a little
                    // detour and parse it as a string, and then use a StaticHelper to parse the string and check if a
                    // bit is set.
                    [simple   string 80         tighteningErrorStatus                                   encoding='"ASCII"']
                    [virtual  bit               tighteningErrorStatusRundownAngleMaxShutOff            'STATIC_CALL("isBitSet", tighteningErrorStatus, 1)']
                    [virtual  bit               tighteningErrorStatusRundownAngleMinShutOff            'STATIC_CALL("isBitSet", tighteningErrorStatus, 2)']
                    [virtual  bit               tighteningErrorStatusTorqueMaxShutOff                  'STATIC_CALL("isBitSet", tighteningErrorStatus, 3)']
                    [virtual  bit               tighteningErrorStatusAngleMaxShutOff                   'STATIC_CALL("isBitSet", tighteningErrorStatus, 4)']
                    [virtual  bit               tighteningErrorStatusSelfTapTorqueMaxShutOff           'STATIC_CALL("isBitSet", tighteningErrorStatus, 5)']
                    [virtual  bit               tighteningErrorStatusSelfTapTorqueMinShutOff           'STATIC_CALL("isBitSet", tighteningErrorStatus, 6)']
                    [virtual  bit               tighteningErrorStatusPrevailTorqueMaxShutOff           'STATIC_CALL("isBitSet", tighteningErrorStatus, 7)']
                    [virtual  bit               tighteningErrorStatusPrevailTorqueMinShutOff           'STATIC_CALL("isBitSet", tighteningErrorStatus, 8)']
                    [virtual  bit               tighteningErrorStatusPrevailTorqueCompensateOverflow   'STATIC_CALL("isBitSet", tighteningErrorStatus, 9)']
                    [virtual  bit               tighteningErrorStatusCurrentMonitoringMaxShutOff       'STATIC_CALL("isBitSet", tighteningErrorStatus, 10)']
                    [virtual  bit               tighteningErrorStatusPostViewTorqueMinTorqueShutOff    'STATIC_CALL("isBitSet", tighteningErrorStatus, 11)']
                    [virtual  bit               tighteningErrorStatusPostViewTorqueMaxTorqueShutOff    'STATIC_CALL("isBitSet", tighteningErrorStatus, 12)']
                    [virtual  bit               tighteningErrorStatusPortViewTorqueAngleTooSmall       'STATIC_CALL("isBitSet", tighteningErrorStatus, 13)']
                    [virtual  bit               tighteningErrorStatusTriggerLost                       'STATIC_CALL("isBitSet", tighteningErrorStatus, 14)']
                    [virtual  bit               tighteningErrorStatusTorqueLessThanTarget              'STATIC_CALL("isBitSet", tighteningErrorStatus, 15)']
                    [virtual  bit               tighteningErrorStatusToolHot                           'STATIC_CALL("isBitSet", tighteningErrorStatus, 16)']
                    [virtual  bit               tighteningErrorStatusMultistageAbort                   'STATIC_CALL("isBitSet", tighteningErrorStatus, 17)']
                    [virtual  bit               tighteningErrorStatusRehit                             'STATIC_CALL("isBitSet", tighteningErrorStatus, 18)']
                    [virtual  bit               tighteningErrorStatusDsMeasureFailed                   'STATIC_CALL("isBitSet", tighteningErrorStatus, 19)']
                    [virtual  bit               tighteningErrorStatusCurrentLimitReached               'STATIC_CALL("isBitSet", tighteningErrorStatus, 20)']
                    [virtual  bit               tighteningErrorStatusEndTimeOutShutoff                 'STATIC_CALL("isBitSet", tighteningErrorStatus, 21)']
                    [virtual  bit               tighteningErrorStatusRemoveFastenerLimitExceeded       'STATIC_CALL("isBitSet", tighteningErrorStatus, 22)']
                    [virtual  bit               tighteningErrorStatusDisableDrive                      'STATIC_CALL("isBitSet", tighteningErrorStatus, 23)']
                    [virtual  bit               tighteningErrorStatusTransducerLost                    'STATIC_CALL("isBitSet", tighteningErrorStatus, 24)']
                    [virtual  bit               tighteningErrorStatusTransducerShorted                 'STATIC_CALL("isBitSet", tighteningErrorStatus, 25)']
                    [virtual  bit               tighteningErrorStatusTransducerCorrupt                 'STATIC_CALL("isBitSet", tighteningErrorStatus, 26)']
                    [virtual  bit               tighteningErrorStatusSyncTimeout                       'STATIC_CALL("isBitSet", tighteningErrorStatus, 27)']
                    [virtual  bit               tighteningErrorStatusDynamicCurrentMonitoringMin       'STATIC_CALL("isBitSet", tighteningErrorStatus, 28)']
                    [virtual  bit               tighteningErrorStatusDynamicCurrentMonitoringMax       'STATIC_CALL("isBitSet", tighteningErrorStatus, 29)']
                    [virtual  bit               tighteningErrorStatusAngleMaxMonitor                   'STATIC_CALL("isBitSet", tighteningErrorStatus, 30)']
                    [virtual  bit               tighteningErrorStatusYieldNutOff                       'STATIC_CALL("isBitSet", tighteningErrorStatus, 31)']
                    [virtual  bit               tighteningErrorStatusYieldTooFewSamples                'STATIC_CALL("isBitSet", tighteningErrorStatus, 32)']
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                 ]
                ['3' *Rev3
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                 ]
                ['4' *Rev4
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart2                      50    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart2                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart3                      51    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart3                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart4                      52    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart4                                   encoding='"ASCII"']
                 ]
                ['5' *Rev5
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart2                      50    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart2                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart3                      51    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart3                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart4                      52    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart4                                   encoding='"ASCII"']
                    [const    uint   16         blockIdCustomerTighteningError                    53    encoding='"ASCII"']
                    [simple   string 200        customerTighteningError                                 encoding='"ASCII"']
                 ]
                ['6' *Rev6
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart2                      50    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart2                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart3                      51    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart3                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart4                      52    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart4                                   encoding='"ASCII"']
                    [const    uint   16         blockIdCustomerTighteningError                    53    encoding='"ASCII"']
                    [simple   string 200        customerTighteningError                                 encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateValue               54    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueCompensateValue                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus2                     55    encoding='"ASCII"']
                    [simple   Status            tighteningErrorStatus2                                  encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                 ]
                ['7' *Rev7
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart2                      50    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart2                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart3                      51    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart3                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart4                      52    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart4                                   encoding='"ASCII"']
                    [const    uint   16         blockIdCustomerTighteningError                    53    encoding='"ASCII"']
                    [simple   string 200        customerTighteningError                                 encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateValue               54    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueCompensateValue                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus2                     55    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdCompensatedAngle                           56    encoding='"ASCII"']
                    [simple   uint   56         compensatedAngle                                        encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleDecimal                          57    encoding='"ASCII"']
                    [simple   uint   56         finalAngleDecimal                                       encoding='"ASCII"']
                ]
                ['998' *Rev998
                    [const    uint   16         blockIdCellId                                     1     encoding='"ASCII"']
                    [simple   uint   32         cellId                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdChannelId                                  2     encoding='"ASCII"']
                    [simple   uint   16         channelId                                               encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueControllerName                       3     encoding='"ASCII"']
                    [simple   string 200        torqueControllerName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdVinNumber                                  4     encoding='"ASCII"']
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [const    uint   16         blockIdJobId                                      5     encoding='"ASCII"']
                    [simple   uint   32         jobId                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetNumber                         6     encoding='"ASCII"']
                    [simple   uint   24         parameterSetNumber                                      encoding='"ASCII"']
                    [const    uint   16         blockIdStrategy                                   7     encoding='"ASCII"']
                    [simple   Strategy          strategy                                                encoding='"ASCII"']
                    [const    uint   16         blockIdStrategyOptions                            8     encoding='"ASCII"']
                    // TODO: Find out how to extract the 10 bits from a 5 byte large value
                    [const    uint   16         blockIdBatchSize                                  9     encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [const    uint   16         blockIdBatchCounter                               10    encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningStatus                           11    encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatus                                12    encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueStatus                               13    encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [const    uint   16         blockIdAngleStatus                                14    encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleStatus                         15    encoding='"ASCII"']
                    [simple   Status            rundownAngleStatus                                      encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringStatus                    16    encoding='"ASCII"']
                    [simple   Status            currentMonitoringStatus                                 encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapStatus                              17    encoding='"ASCII"']
                    [simple   Status            selfTapStatus                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringStatus              18    encoding='"ASCII"']
                    [simple   Status            prevailTorqueMonitoringStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateStatus              19    encoding='"ASCII"']
                    [simple   Status            prevailTorqueCompensateStatus                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus                      20    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdTorqueMinLimit                             21    encoding='"ASCII"']
                    [simple   uint   48         torqueMinLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueMaxLimit                             22    encoding='"ASCII"']
                    [simple   uint   48         torqueMaxLimit                                          encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueFinalTarget                          23    encoding='"ASCII"']
                    [simple   uint   48         torqueFinalTarget                                       encoding='"ASCII"']
                    [const    uint   16         blockIdTorque                                     24    encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMin                                   25    encoding='"ASCII"']
                    [simple   uint   40         angleMin                                                encoding='"ASCII"']
                    [const    uint   16         blockIdAngleMax                                   26    encoding='"ASCII"']
                    [simple   uint   40         angleMax                                                encoding='"ASCII"']
                    [const    uint   16         blockIdFinalAngleTarget                           27    encoding='"ASCII"']
                    [simple   uint   40         finalAngleTarget                                        encoding='"ASCII"']
                    [const    uint   16         blockIdAngle                                      28    encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMin                            29    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMin                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngleMax                            30    encoding='"ASCII"']
                    [simple   uint   40         rundownAngleMax                                         encoding='"ASCII"']
                    [const    uint   16         blockIdRundownAngle                               31    encoding='"ASCII"']
                    [simple   uint   40         rundownAngle                                            encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMin                       32    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMin                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringMax                       33    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringMax                                    encoding='"ASCII"']
                    [const    uint   16         blockIdCurrentMonitoringValue                     34    encoding='"ASCII"']
                    [simple   uint   24         currentMonitoringValue                                  encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMin                                 35    encoding='"ASCII"']
                    [simple   uint   48         selfTapMin                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapMax                                 36    encoding='"ASCII"']
                    [simple   uint   48         selfTapMax                                              encoding='"ASCII"']
                    [const    uint   16         blockIdSelfTapTorque                              37    encoding='"ASCII"']
                    [simple   uint   48         selfTapTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMin                 38    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMin                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueMonitoringMax                 39    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueMonitoringMax                              encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorque                              40    encoding='"ASCII"']
                    [simple   uint   48         prevailTorque                                           encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningId                               41    encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                    [const    uint   16         blockIdJobSequenceNumber                          42    encoding='"ASCII"']
                    [simple   uint   40         jobSequenceNumber                                       encoding='"ASCII"']
                    [const    uint   16         blockIdSyncTighteningId                           43    encoding='"ASCII"']
                    [simple   uint   40         syncTighteningId                                        encoding='"ASCII"']
                    [const    uint   16         blockIdToolSerialNumber                           44    encoding='"ASCII"']
                    [simple   string 112        toolSerialNumber                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTimeStamp                                  45    encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [const    uint   16         blockIdDateTimeOfLastChangeInParameterSetSettings 46    encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [const    uint   16         blockIdParameterSetName                           47    encoding='"ASCII"']
                    [simple   string 200        parameterSetName                                        encoding='"ASCII"']
                    [const    uint   16         blockIdTorqueValueUnit                            48    encoding='"ASCII"']
                    [simple   Unit              torqueValueUnit                                         encoding='"ASCII"']
                    [const    uint   16         blockIdResultType                                 49    encoding='"ASCII"']
                    [simple   ResultType        resultType                                              encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart2                      50    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart2                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart3                      51    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart3                                   encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart4                      52    encoding='"ASCII"']
                    [simple   string 200        identifierResultPart4                                   encoding='"ASCII"']
                    [const    uint   16         blockIdCustomerTighteningError                    53    encoding='"ASCII"']
                    [simple   string 200        customerTighteningError                                 encoding='"ASCII"']
                    [const    uint   16         blockIdPrevailTorqueCompensateValue               54    encoding='"ASCII"']
                    [simple   uint   48         prevailTorqueCompensateValue                            encoding='"ASCII"']
                    [const    uint   16         blockIdTighteningErrorStatus2                     55    encoding='"ASCII"']
                    // TODO: Find out how to extract the 32 bits from a 10 byte large value
                    [const    uint   16         blockIdNumberOfStagesInMultistage                 56    encoding='"ASCII"']
                    [simple   uint   16         numberOfStagesInMultistage                              encoding='"ASCII"']
                    [const    uint   16         blockIdNumberOfStageResults                       57    encoding='"ASCII"']
                    [implicit uint   16         numberOfStageResults   'COUNT(stageResults)'            encoding='"ASCII"']
                    [const    uint   16         blockIdStageResults                               58    encoding='"ASCII"']
                    [array    StageResult       stageResults        count 'numberOfStageResults'        encoding='"ASCII"']
                ]
                ['999' *Rev999Light
                    [simple   string 200        vinNumber                                               encoding='"ASCII"']
                    [simple   uint   16         jobId                                                   encoding='"ASCII"']
                    [simple   uint   24         parameterSetId                                          encoding='"ASCII"']
                    [simple   uint   32         batchSize                                               encoding='"ASCII"']
                    [simple   uint   32         batchCounter                                            encoding='"ASCII"']
                    [simple   BatchStatus       batchStatus                                             encoding='"ASCII"']
                    [simple   NokOk             tighteningStatus                                        encoding='"ASCII"']
                    [simple   Status            torqueStatus                                            encoding='"ASCII"']
                    [simple   Status            angleStatus                                             encoding='"ASCII"']
                    [simple   uint   48         torque                                                  encoding='"ASCII"']
                    [simple   uint   40         angle                                                   encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [simple   string 152        dateTimeOfLastChangeIndParameterSetSettings             encoding='"ASCII"']
                    [simple   string 80         tighteningId                                            encoding='"ASCII"']
                ]
            ]
        ]

        ['AlarmSubscribe' *AlarmSubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['Alarm' *Alarm
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16         blockIdErrorCode              1    encoding='"ASCII"']
                    [simple   string 32         errorCode                          encoding='"ASCII"']
                    [const    uint   16         blockIdControllerReadyStatus  2    encoding='"ASCII"']
                    [simple   NokOk             controllerReadyStatus              encoding='"ASCII"']
                    [const    uint   16         blockIdToolReadyStatus        3    encoding='"ASCII"']
                    [simple   NokOk             toolReadyStatus                    encoding='"ASCII"']
                    [const    uint   16         blockIdTime                   4    encoding='"ASCII"']
                    [simple   string 152        alarmTime                          encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16         blockIdErrorCode              1    encoding='"ASCII"']
                    [simple   string 40         errorCode                          encoding='"ASCII"']
                    [const    uint   16         blockIdControllerReadyStatus  2    encoding='"ASCII"']
                    [simple   NokOk             controllerReadyStatus              encoding='"ASCII"']
                    [const    uint   16         blockIdToolReadyStatus        3    encoding='"ASCII"']
                    [simple   NokOk             toolReadyStatus                    encoding='"ASCII"']
                    [const    uint   16         blockIdTime                   4    encoding='"ASCII"']
                    [simple   string 152        alarmTime                          encoding='"ASCII"']
                    [const    uint   16         blockIdAlarmText              5    encoding='"ASCII"']
                    [simple   string 400        alarmText                          encoding='"ASCII"']
                ]
            ]
        ]
        ['AlarmAcknowledge' *AlarmAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
        ['AlarmUnsubscribe' *AlarmUnsubscribe
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]

        ['AlarmStatus' *AlarmStatus
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16         blockIdAlarmStatus              1   encoding='"ASCII"']
                    [simple   AlarmActiveStatus controllerAlarmStatus               encoding='"ASCII"']
                    [const    uint   16         blockIdErrorCode                2   encoding='"ASCII"']
                    [simple   string 32         errorCode                           encoding='"ASCII"']
                    [const    uint   16         blockIdControllerReadyStatus   3    encoding='"ASCII"']
                    [simple   NokOk             controllerReadyStatus               encoding='"ASCII"']
                    [const    uint   16         blockIdToolReadyStatus         4    encoding='"ASCII"']
                    [simple   NokOk             toolReadyStatus                     encoding='"ASCII"']
                    [const    uint   16         blockIdTime                    5    encoding='"ASCII"']
                    [simple   string 152        alarmTime                           encoding='"ASCII"']
                ]
                ['2' *Rev2
                    [const    uint   16         blockIdAlarmStatus              1   encoding='"ASCII"']
                    [simple   AlarmActiveStatus controllerAlarmStatus               encoding='"ASCII"']
                    [const    uint   16         blockIdErrorCode                2   encoding='"ASCII"']
                    [simple   string 40         errorCode                           encoding='"ASCII"']
                    [const    uint   16         blockIdControllerReadyStatus    3   encoding='"ASCII"']
                    [simple   NokOk             controllerReadyStatus               encoding='"ASCII"']
                    [const    uint   16         blockIdToolReadyStatus          4   encoding='"ASCII"']
                    [simple   NokOk             toolReadyStatus                     encoding='"ASCII"']
                    [const    uint   16         blockIdTime                     5   encoding='"ASCII"']
                    [simple   string 152        alarmTime                           encoding='"ASCII"']
                ]
            ]
        ]

        ['AlarmStatusAcknowledge' *AlarmStatusAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]

        ['SetTime' *SetTime
            [typeSwitch revision
                ['1' *Rev1
                    [simple   string 152        timeToSet                                               encoding='"ASCII"']
                ]
            ]
        ]

        ['ExecuteDynamicJobRequest' *ExecuteDynamicJobRequest
            [typeSwitch revision
                ['1' *Rev1
                    [const    uint   16         blockIdJobId                          1    encoding='"ASCII"']
                    [simple   uint   32         jobId                                      encoding='"ASCII"']
                    [const    uint   16         blockIdJobName                        2    encoding='"ASCII"']
                    [simple   string 200        jobName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdNumberOfParameterSets          3    encoding='"ASCII"']
                    //[implicit uint   16         numberOfParameterSets     'COUNT(jobList)' encoding='"ASCII"']
                    [const    uint   16         blockIdJobList                        4    encoding='"ASCII"']
                    // TODO [array    ParameterSetRev1      jobList     count 'numberOfParameterSets'  encoding='"ASCII"']
                    [const    uint   16         blockIdForcedOrder                    5    encoding='"ASCII"']
                    [simple   ForcedOrder       forcedOrder                                encoding='"ASCII"']
                    [const    uint   16         blockIdLockAtJobDone                  6    encoding='"ASCII"']
                    [simple   NoYes             lockAtJobDone                              encoding='"ASCII"']
                    [const    uint   16         blockIdToolLoosening                  7    encoding='"ASCII"']
                    [simple   ToolLoosening     toolLoosening                              encoding='"ASCII"']
                    [const    uint   16         blockIdRepeatJob                      8    encoding='"ASCII"']
                    [simple   NoYes             repeatJob                                  encoding='"ASCII"']
                    [const    uint   16         blockIdJobBatchModeAndCountType       9    encoding='"ASCII"']
                    [simple   JobBatchMode      jobBatchModeAndCountType                   encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatusAtIncrementBypass   10   encoding='"ASCII"']
                    [simple   OkNok             batchStatusAtIncrementBypass               encoding='"ASCII"']
                    [const    uint   16         blockIdDecrementBatchAtOkLoosening    11   encoding='"ASCII"']
                    [simple   NoYes             decrementBatchAtOkLoosening                encoding='"ASCII"']
                    [const    uint   16         blockIdMaxTimeForFirstTightening      12   encoding='"ASCII"']
                    [simple   uint   32         maxTimeForFirstTightening                  encoding='"ASCII"']
                    [const    uint   16         blockIdMaxTimeToCompleteJob           13   encoding='"ASCII"']
                    [simple   uint   40         maxTimeToCompleteJob                       encoding='"ASCII"']
                    [const    uint   16         blockIdDisplayResultAtAutoSelect      14   encoding='"ASCII"']
                    [simple   uint   32         displayResultAtAutoSelect                  encoding='"ASCII"']
                    [const    uint   16         blockIdUseLineControl                 15   encoding='"ASCII"']
                    [simple   NoYes             useLineControl                             encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart           16   encoding='"ASCII"']
                    [simple   IdentifierResult  identifierResultPart                       encoding='"ASCII"']
                    [const    uint   16         blockIdResultOfNonTightenings         17   encoding='"ASCII"']
                    [simple   NoYes             resultOfNonTightenings                     encoding='"ASCII"']
                    [const    uint   16         blockIdResetAllIdentifiersAtJobDone   18   encoding='"ASCII"']
                    [simple   NoYes             resetAllIdentifiersAtJobDone               encoding='"ASCII"']
                    [const    uint   16         blockIdReserved                       19   encoding='"ASCII"']
                    [simple   uint   8          jobRepair                                  encoding='"ASCII"']
                ]
                ['999' *Rev999
                    [const    uint   16         blockIdJobId                          1    encoding='"ASCII"']
                    [simple   uint   32         jobId                                      encoding='"ASCII"']
                    [const    uint   16         blockIdJobName                        2    encoding='"ASCII"']
                    [simple   string 200        jobName                                    encoding='"ASCII"']
                    [const    uint   16         blockIdNumberOfParameterSets          3    encoding='"ASCII"']
                    //[implicit uint   16         numberOfParameterSets     'COUNT(jobList)' encoding='"ASCII"']
                    [const    uint   16         blockIdJobList                        4    encoding='"ASCII"']
                    // TODO [array    ParameterSetRev999      jobList     count 'numberOfParameterSets'  encoding='"ASCII"']
                    [const    uint   16         blockIdForcedOrder                    5    encoding='"ASCII"']
                    [simple   ForcedOrder       forcedOrder                                encoding='"ASCII"']
                    [const    uint   16         blockIdLockAtJobDone                  6    encoding='"ASCII"']
                    [simple   NoYes             lockAtJobDone                              encoding='"ASCII"']
                    [const    uint   16         blockIdToolLoosening                  7    encoding='"ASCII"']
                    [simple   ToolLoosening     toolLoosening                              encoding='"ASCII"']
                    [const    uint   16         blockIdRepeatJob                      8    encoding='"ASCII"']
                    [simple   NoYes             repeatJob                                  encoding='"ASCII"']
                    [const    uint   16         blockIdJobBatchModeAndCountType       9    encoding='"ASCII"']
                    [simple   JobBatchMode      jobBatchModeAndCountType                   encoding='"ASCII"']
                    [const    uint   16         blockIdBatchStatusAtIncrementBypass   10   encoding='"ASCII"']
                    [simple   OkNok             batchStatusAtIncrementBypass               encoding='"ASCII"']
                    [const    uint   16         blockIdDecrementBatchAtOkLoosening    11   encoding='"ASCII"']
                    [simple   NoYes             decrementBatchAtOkLoosening                encoding='"ASCII"']
                    [const    uint   16         blockIdMaxTimeForFirstTightening      12   encoding='"ASCII"']
                    [simple   uint   32         maxTimeForFirstTightening                  encoding='"ASCII"']
                    [const    uint   16         blockIdMaxTimeToCompleteJob           13   encoding='"ASCII"']
                    [simple   uint   40         maxTimeToCompleteJob                       encoding='"ASCII"']
                    [const    uint   16         blockIdDisplayResultAtAutoSelect      14   encoding='"ASCII"']
                    [simple   uint   32         displayResultAtAutoSelect                  encoding='"ASCII"']
                    [const    uint   16         blockIdUseLineControl                 15   encoding='"ASCII"']
                    [simple   NoYes             useLineControl                             encoding='"ASCII"']
                    [const    uint   16         blockIdIdentifierResultPart           16   encoding='"ASCII"']
                    [simple   IdentifierResult  identifierResultPart                       encoding='"ASCII"']
                    [const    uint   16         blockIdResultOfNonTightenings         17   encoding='"ASCII"']
                    [simple   NoYes             resultOfNonTightenings                     encoding='"ASCII"']
                    [const    uint   16         blockIdResetAllIdentifiersAtJobDone   18   encoding='"ASCII"']
                    [simple   NoYes             resetAllIdentifiersAtJobDone               encoding='"ASCII"']
                    [const    uint   16         blockIdReserved                       19   encoding='"ASCII"']
                    [simple   uint   8          jobRepair                                  encoding='"ASCII"']
                ]
            ]
        ]
        ['IdentifierDownloadRequest' *IdentifierDownloadRequest
            [typeSwitch revision
                ['1' *Rev1
                    [simple   string 800        identifierData                                          encoding='"ASCII"']
                ]
            ]
        ]

        ['ResultTracesCurve' *ResultTracesCurve
            [typeSwitch revision
                ['1' *Rev1
                    // TODO: Need to be able to serialize enum arrays [implicit uint   24         numberOfTraceTypes    'COUNT(traceTypes)'  encoding='"ASCII"']
                    // TODO: Need to be able to serialize enum arrays [array    TraceType         traceTypes     count 'numberOfTraceTypes'  encoding='"ASCII"']
                ]
            ]
        ]

        ['ResultTracesCurvePlotData' *ResultTracesCurvePlotData
            [typeSwitch revision
                ['1' *Rev1
                    [simple   string 80         resultDataIdentifier                 encoding='"ASCII"']
                    [simple   string 152        timeStamp                                               encoding='"ASCII"']
                    [implicit uint   24         numberOfParameterDataFields    'COUNT(dataFields)'  encoding='"ASCII"']
                    [array    VariableDataField dataFields     count 'numberOfParameterDataFields'  encoding='"ASCII"']
                ]
            ]
        ]

        ['ProgramPsetSelectionInDynamicJob' *ProgramPsetSelectionInDynamicJob
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                ]
            ]
        ]
        ['DynamicPsetSelection' *DynamicPsetSelection
            [typeSwitch revision
                ['1' *Rev1
                    [simple   uint   24         parameterSetId                 encoding='"ASCII"']
                    [implicit uint   24         numberOfParameterDataFields    'COUNT(dataFields)'  encoding='"ASCII"']
                    [array    VariableDataField dataFields     count 'numberOfParameterDataFields'  encoding='"ASCII"']
                ]
            ]
        ]

        ['LinkLevelPositiveAcknowledge' *LinkLevelPositiveAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                    [simple   Mid                  midNumber                                            encoding='"ASCII"']
                ]
            ]
        ]
        ['LinkLevelNegativeAcknowledge' *LinkLevelNegativeAcknowledge
            [typeSwitch revision
                ['1' *Rev1
                    [simple   Mid                  midNumber                                            encoding='"ASCII"']
                    [simple   LinkLevelNegativeAcknowledgeError error                                  encoding='"ASCII"']
                ]
            ]
        ]
        ['KeepAliveOpenProtocolCommunication' *KeepAliveOpenProtocolCommunication
            [typeSwitch revision
                ['1' *Rev1
                ]
            ]
        ]
    ]
    [const         uint 8  end                  0x00                                                              ]
]

[type VariableDataField
    [simple   uint 40 parameterId                       encoding='"ASCII"']
    [implicit uint 24 length      'COUNT(dataValue)'    encoding='"ASCII"']
    [simple   uint 16 dataType                          encoding='"ASCII"']
    [simple   uint 24 unit                              encoding='"ASCII"']
    [simple   uint 24 stepNumber                        encoding='"ASCII"']
    [array    byte    dataValue   length 'length'       encoding='"ASCII"']
]

[type StageResult
    [simple   uint 48 stageTorqueValue                  encoding='"ASCII"']
    [simple   uint 40 stageTurningAngleValue            encoding='"ASCII"']
]

[enum uint 32 Mid   encoding='"ASCII"'
    ['1'    ApplicationCommunicationStart               ] // OK *
    ['2'    ApplicationCommunicationStartAcknowledge    ] // OK *
    ['3'    ApplicationCommunicationStop                ] // OK
    ['4'    ApplicationCommandError                     ] // OK *
    ['5'    ApplicationCommandAccepted                  ] // OK *
    ['6'    ApplicationGenericDataRequest               ] // OK
    ['7'    Reserved                                    ]
    ['8'    ApplicationGenericSubscription              ] // OK *
    ['9'    ApplicationGenericUnsubscribe               ] // OK *
    ['10'   ParameterSetIdUploadRequest                 ] // OK *
    ['11'   ParameterSetIdUploadReply                   ] // OK *
    ['12'   ParameterSetDataUploadRequest               ] // OK *
    ['13'   ParameterSetDataUploadReply                 ] // OK *
    ['14'   ParameterSetSelectedSubscribe               ] // OK
    ['15'   ParameterSetSelected                        ] // OK
    ['16'   ParameterSetSelectedAcknowledge             ] // OK
    ['17'   ParameterSetSelectedUnsubscribe             ] // OK
    ['18'   SelectParameterSet                          ] // OK *
    ['19'   SetParameterSetBatchSize                    ] // OK
    ['20'   ResetParameterSetBatchCounter               ] // OK
    ['21'   LockAtBatchDoneSubscribe                    ] // OK
    ['22'   LockAtBatchDoneUpload                       ] // OK
    ['23'   LockAtBatchDoneUploadAcknowledge            ] // OK
    ['24'   LockAtBatchDoneUnsubscribe                  ] // OK
    ['25'   ReservedForFord                             ] // OK

    ['30'   JobIdUploadRequest                          ]
    ['31'   JobIdUploadReply                            ]
    ['32'   JobDataUploadRequest                        ]
    ['33'   JobDataUploadReply                          ]
    ['34'   JobInfoSubscribe                            ]
    ['35'   JobInfo                                     ]
    ['36'   JobInfoAcknowledge                          ]
    ['37'   JobInfoUnsubscribe                          ]
    ['38'   SelectJob                                   ]
    ['39'   JobRestart                                  ]
    ['40'   ToolDataUploadRequest                       ]
    ['41'   ToolDataUploadReply                         ]
    ['42'   DisableTool                                 ] // OK *
    ['43'   EnableTool                                  ] // OK *
    ['44'   DisconnectToolRequest                       ]
    ['45'   SetCalibrationValueRequest                  ]
    ['46'   SetPrimaryToolRequest                       ]
    ['47'   PairingHandling                             ]
    ['48'   PairingStatus                               ]
    ['49'   PairingStatusAcknowledge                    ]
    ['50'   VehicleIdNumberDownloadRequest              ]
    ['51'   VehicleIdNumberSubscribe                    ]
    ['52'   VehicleIdNumber                             ]
    ['53'   VehicleIdNumberAcknowledge                  ]
    ['54'   VehicleIdNumberUnsubscribe                  ]

    ['60'   LastTighteningResultDataSubscribe           ] // OK *
    ['61'   LastTighteningResultData                    ] // OK *
    ['62'   LastTighteningResultDataAcknowledge         ]
    ['63'   LastTighteningResultDataUnsubscribe         ]
    ['64'   OldTighteningResultUploadRequest            ]
    ['65'   OldTighteningResultUploadReply              ]

    ['70'   AlarmSubscribe                              ] // OK *
    ['71'   Alarm                                       ] // OK *
    ['72'   AlarmAcknowledge                            ] // OK *
    ['73'   AlarmUnsubscribe                            ] // OK *
    ['74'   AlarmAcknowledgedOnController               ]
    ['75'   AlarmAcknowledgedOnControllerAcknowledge    ]
    ['76'   AlarmStatus                                 ] // OK *
    ['77'   AlarmStatusAcknowledge                      ] // OK *
    ['78'   AcknowledgeAlarmRemotelyOnController        ]

    ['80'   ReadTimeUploadRequest                       ]
    ['81'   ReadTimeUploadReply                         ]
    ['82'   SetTime                                     ] // OK *

    ['90'   MultiSpindleStatusSubscribe                 ]
    ['91'   MultiSpindleStatus                          ]
    ['92'   MultiSpindleStatusAcknowledge               ]
    ['93'   MultiSpindleStatusUnsubscribe               ]

    ['100'  MultiSpindleResultSubscribe                 ]
    ['101'  MultiSpindleResult                          ]
    ['102'  MultiSpindleResultAcknowledge               ]
    ['103'  MultiSpindleResultUnsubscribe               ]

    ['105'  LastPowerMacsTighteningResultDataSubscribe  ]
    ['106'  LastPowerMacsTighteningResultStationData    ]
    ['107'  LastPowerMacsTighteningResultBoltData       ]
    ['108'  LastPowerMacsTighteningResultDataAcknowledge]
    ['109'  LastPowerMacsTighteningResultDataUnsubscribe]
    ['110'  DisplayUserTextOnCompact                    ]
    ['111'  DisplayUserTextOnGraph                      ]

    ['113'  FlashGreenLightOnTool                       ]

    ['120'  JobLineControlInfoSubscribe                 ]
    ['121'  JobLineControlStarted                       ]
    ['122'  JobLineControlAlert1                        ]
    ['123'  JobLineControlAlert2                        ]
    ['124'  JobLineControlDone                          ]
    ['125'  JobLineControlInfoAcknowledge               ]
    ['126'  JobLineControlUnsubscribe                   ]
    ['127'  AbortJob                                    ]
    ['128'  JobBatchIncrement                           ]
    ['129'  JobBatchDecrement                           ]
    ['130'  JobOff                                      ]
    ['131'  SetJobLineControlStart                      ]
    ['132'  SetJobLineControlAlert1                     ]
    ['133'  SetJobLineControlAlert2                     ]

    ['140'  ExecuteDynamicJobRequest                    ] // OK *

    ['150'  IdentifierDownloadRequest                   ] // OK *
    ['151'  MultipleIdentifiersWorkOrderSubscribe       ]
    ['152'  MultipleIdentifiersWorkOrder                ]
    ['153'  MultipleIdentifiersWorkOrderAcknowledge     ]
    ['154'  MultipleIdentifiersWorkOrderUnsubscribe     ]
    ['155'  BypassIdentifier                            ]
    ['156'  ResetLatestIdentifier                       ]
    ['157'  ResetAllIdentifiers                         ]

    ['200'  SetExternalControlledRelays                 ]

    ['210'  StatusExternalMonitoredInputsSubscribe      ]
    ['211'  StatusExternalMonitoredInputs               ]
    ['212'  StatusExternalMonitoredInputsAcknowledge    ]
    ['213'  StatusExternalMonitoredInputsUnsubscribe    ]
    ['214'  IoDeviceStatusRequest                       ]
    ['215'  IoDeviceStatusReply                         ]
    ['216'  RelayFunctionSubscribe                      ]
    ['217'  RelayFunction                               ]
    ['218'  RelayFunctionAcknowledge                    ]
    ['219'  RelayFunctionUnsubscribe                    ]
    ['220'  DigitalInputFunctionSubscribe               ]
    ['221'  DigitalInputFunction                        ]
    ['222'  DigitalInputFunctionAcknowledge             ]
    ['223'  DigitalInputFunctionUnsubscribe             ]
    ['224'  SetDigitalInputFunction                     ]
    ['225'  ResetDigitalInputFunction                   ]

    ['240'  UserDataDownload                            ]
    ['241'  UserDataSubscribe                           ]
    ['242'  UserData                                    ]
    ['243'  UserDataAcknowledge                         ]
    ['244'  UserDataUnsubscribe                         ]
    ['245'  UserDataDownloadWithOffset                  ]

    ['250'  SelectorSocketInfoSubscribe                 ]
    ['251'  SelectorSocketInfo                          ]
    ['252'  SelectorSocketInfoAcknowledge               ]
    ['253'  SelectorSocketInfoUnsubscribe               ]
    ['254'  SelectorControlGreenLights                  ]
    ['255'  SelectorControlRedLights                    ]

    ['260'  ToolTagIdRequest                            ]
    ['261'  ToolTagIdSubscribe                          ]
    ['262'  ToolTagId                                   ]
    ['263'  ToolTagIdAcknowledge                        ]
    ['264'  ToolTagIdUnsubscribe                        ]

    ['270'  ControllerRebootRequest                     ]

    ['300'  HistogramUploadRequest                      ]
    ['301'  HistogramUploadReply                        ]

    ['400'  AutomaticManualModeSubscribe                ]
    ['401'  AutomaticManualMode                         ]
    ['402'  AutomaticManualModeAcknowledge              ]
    ['403'  AutomaticManualModeUnsubscribe              ]

    ['410'  AutoDisableSettingsRequest                  ]
    ['411'  AutoDisableSettingsReply                    ]

    ['420'  OpenProtocolCommandsDisabledSubscribe       ]
    ['421'  OpenProtocolCommandsDisabled                ]
    ['422'  OpenProtocolCommandsDisabledAcknowledge     ]
    ['423'  OpenProtocolCommandsDisabledUnsubscribe     ]

    ['500'  MotorTuningResultDataSubscribe              ]
    ['501'  MotorTuningResultData                       ]
    ['502'  MotorTuningResultDataAcknowledge            ]
    ['503'  MotorTuningResultDataUnsubscribe            ]
    ['504'  MotorTuningRequest                          ]

    ['700'  TighteningDataDownloadStatusForRadioTools   ]

    ['900'  ResultTracesCurve                           ] // OK *
    ['901'  ResultTracesCurvePlotData                   ] // OK *

    ['1201' LastOperationResultOverallData              ]
    ['1202' LastOperationResultObjectData               ]
    ['1203' LastOperationResultDataAcknowledge          ]

    ['2100' DeviceCommand                               ]

    ['2500' ProgramDataDownload                         ]
    ['2501' ProgramDataUploadReply                      ]
    ['2502' PasswordRequest                             ]
    ['2503' PasswordReply                               ] // PasswordResponse in the documentation
    ['2504' ProgramPsetSelectionInDynamicJob            ] // OK
    ['2505' DynamicPsetSelection                        ] // OK

    ['2600' ModeIdUploadRequest                         ]
    ['2601' ModeIdUploadReply                           ]
    ['2602' ModeDataUploadRequest                       ]
    ['2603' ModeDataUploadReply                         ]
    ['2604' ModeSelected                                ]
    ['2605' ModeSelectedAcknowledge                     ]
    ['2606' SelectMode                                  ]

    ['8000' AudiEmergencyStatusSubscribe                ]
    ['8001' AudiEmergencyStatus                         ]
    ['8002' AudiEmergencyStatusAcknowledge              ]
    ['8003' AudiEmergencyStatusUnsubscribe              ]

    ['9997' LinkLevelPositiveAcknowledge                ] // OK
    ['9998' LinkLevelNegativeAcknowledge                ] // OK
    ['9999' KeepAliveOpenProtocolCommunication          ] // OK *
]

[enum uint 16 ApplicationCommunicationError encoding='"ASCII"'
    ['0'  NoError]
    ['1'  InvalidData]
    ['2'  ParameterSetIdNotPresent]
    ['3'  ParameterSetCanNotBeSet]
    ['4'  ParameterSetNotRunning]

    ['6'  VinUploadSubscriptionAlreadyExists]
    ['7'  VinUploadSubscriptionDoesNotExist]
    ['8'  VinInputSourceNotGranted]
    ['9'  LastTighteningResultSubscriptionAlreadyExists]
    ['10' LastTighteningResultSubscriptionDoesNowExist]
    ['11' AlarmSubscriptionAlreadyExists]
    ['12' AlarmSubscriptionDoesNotExist]
    ['13' ParameterSetSubscriptionAlreadyExists]
    ['14' ParameterSetSubscriptionDoesNotExist]
    ['15' TighteningIdRequestedNotFound]
    ['16' ConnectionRejectedProtocolBusy]
    ['17' JobIdNotPresent]
    ['18' JobInfoSubscriptionAlreadyExists]
    ['19' JobInfoSubscriptionDoesNotExist]
    ['20' JobCanNotBeSet]
    ['21' JobNotRunning]
    ['22' NotPossibleToExecuteDynamicJobRequest]
    ['23' JobBatchDecrementFailed]
    ['24' NotPossibleToCreatePset]
    ['25' ProgrammingControlNotGranted]
    ['26' WrongToolTypeToPsetDownloadConnected]
    ['27' ToolIsInaccessible]
    ['28' JobAbortionIsInProgress]

    ['30' ControllerIdNotASyncMasterOrStationController]
    ['31' MultiSpindleStatusSubscriptionAlreadyExists]
    ['32' MultiSpindleStatusSubscriptionDoesNotExist]
    ['33' MultiSpindleResultSubscriptionAlreadyExists]
    ['34' MultiSpindleResultSubscriptionDoesNotExist]
    ['35' OtherMasterClientAlreadyConnected]

    ['40' JobLineControlInfoSubscriptionAlreadyExists]
    ['41' JobLineControlInfoSubscriptionDoesNotExist]
    ['42' IdentifierInputSourceNotGranted]
    ['43' MultipleIdentifiersWorkOrderSubscriptionAlreadyExists]
    ['44' MultipleIdentifiersWorkOrderSubscriptionDoesNotExist]

    ['50' StatusExternalMonitoredInputsSubscriptionAlreadyExists]
    ['51' StatusExternalMonitoredInputsSubscriptionDoesNotExist]
    ['52' IoDeviceNotConnected]
    ['53' FaultyIoDeviceId]
    ['54' ToolTagIdUnknown]
    ['55' ToolTagIdSubscriptionAlreadyExists]
    ['56' ToolTagIdSubscriptionDoesNotExist]
    ['57' ToolMotorTuningFailed]
    ['58' NoAlarmPresent]
    ['59' ToolCurrentlyInUse]
    ['60' NoHistogramAvailable]
    ['61' PairingFailed]
    ['62' PairingDenied]
    ['63' PairingOrPairingAbortionAttemptOrWrongToolType]
    ['64' PairingAbortionDenied]
    ['65' PairingAbortionFailed]
    ['66' PairingDisconnectionFailed]
    ['67' PairingInProgressOrAlreadyDone]
    ['68' PairingDeniedNoProgramControl]
    ['69' UnsupportedExtraDataRevision]
    ['70' CalibrationFailed]
    ['71' SubscriptionAlreadyExists]
    ['72' SubscriptionDoesNotExist]
    ['73' SubscribedMidUnsupported]
    ['74' SubscribedMidRevisionUnsupported]
    ['75' RequestedMidUnsupported]
    ['76' RequestedMidRevisionUnsupported]
    ['77' RequestedOnSpecificDataNotSupported]
    ['78' SubscriptionOnSpecificDataNotSupported]
    ['79' CommandFailed]
    ['80' AudiEmergencyStatusSubscriptionAlreadyExists] // AudiEmergencyStatusSubscriptionExists
    ['81' AudiEmergencyStatusSubscriptionDoesNotExist]
    ['82' AutomaticOrManualModeSubscriptionAlreadyExists] // AutomaticOrManualModeSubscribeAlreadyExists
    ['83' AutomaticOrManualModeSubscriptionDoesNotExist] // AutomaticOrManualModeSubscribeDoesNotExist
    ['84' TheRelayFunctionSubscriptionAlreadyExists]
    ['85' TheRelayFunctionSubscriptionDoesNotExist]
    ['86' TheSelectorSocketInfoSubscriptionAlreadyExists]
    ['87' TheSelectorSocketInfoSubscriptionDoesNotExist]
    ['88' TheDiginInfoSubscriptionAlreadyExists]
    ['89' TheDiginInfoSubscriptionDoesNotExist]
    ['90' LockAtBatchDoneSubscriptionAlreadyExists]
    ['91' LockAtBatchDoneSubscriptionDoesNotExist]
    ['92' OpenProtocolCommendsDisabled]
    ['93' OpenProtocolCommendsDisabledSubscriptionAlreadyExists]
    ['94' OpenProtocolCommendsDisabledSubscriptionDoesNotExist]
    ['95' RejectRequestPowerMacsIsInManualMode]
    ['96' RejectConnectionClientAlreadyConnected]
    ['97' MidRevisionUnsupported]
    ['98' ControllerInternalRequestTimeout]
    ['99' UnknownMid]
]

[enum uint 32 LinkLevelNegativeAcknowledgeError encoding='"ASCII"'
   ['0' NoError]
   ['1' InvalidLength]
   ['2' InvalidRevision]
   ['3' InvalidSequenceNumber]
   ['4' InconsistencyOfNumberOfMessages]
]

[enum uint 8 RotationDirection encoding='"ASCII"'
    ['0' Undefined       ]
    ['1' Clockwise       ]
    ['2' CounterClockwise]
]

[enum uint 8 NokOk encoding='"ASCII"'
    ['0' NOK]
    ['1' OK ]
]

[enum uint 8 OkNok encoding='"ASCII"'
    ['0' OK ]
    ['1' NOK]
]

[enum uint 8 NoYes encoding='"ASCII"'
    ['0' No ]
    ['1' Yes]
]

[enum uint 8 Status encoding='"ASCII"'
    ['0' Low ]
    ['1' OK  ]
    ['2' High]
]

[enum uint 8 BatchStatus encoding='"ASCII"'
    ['0' NOK   ]
    ['1' OK    ]
    ['2' Unused]
]

[enum uint 16 Strategy encoding='"ASCII"'
    ['1'  TorqueControl               ]
    ['2'  TorqueControlAngleMonitoring]
    ['3'  TorqueControlAngleControlAnd]
    ['4'  AngleControlTorqueMonitoring]
    ['5'  DsControl                   ]
    ['6'  DsControlTorqueMonitoring   ]
    ['7'  ReverseAngle                ]
    ['8'  ReverseTorque               ]
    ['9'  ClickWrench                 ]
    ['10' RotateSpindleForward        ]
    ['11' TorqueControlAngleControlOr ]
    ['12' RotateSpindleReverse        ]
    ['13' HomePositionForward         ]
    ['14' EpMonitoring                ]
    ['15' Yield                       ]
    ['16' EpFixed                     ]
    ['17' EpControl                   ]
    ['18' EpAngleShutoff              ]
    ['19' YieldTorqueControlOr        ]
    ['20' SnugGradient                ]
    ['21' ResidualTorqueTime          ]
    ['22' ResidualTorqueAngle         ]
    ['23' BreakawayPeak               ]
    ['24' LooseAndTightening          ]
    ['25' HomePositionReverse         ]
    ['26' PvtCompWithSnug             ]
    ['99' NoStrategy                  ]
]

[enum uint 8 Unit encoding='"ASCII"'
    ['1' Nm     ]
    ['2' LbfFt  ]
    ['3' LbfIn  ]
    ['4' Kpm    ]
    ['5' KfgCm  ]
    ['6' OzfIn  ]
    ['7' Percent]
    ['8' Ncm    ]
]

[enum uint 8 ResultType encoding='"ASCII"'
    ['1' Tightening]
    ['2' Loosening]
    ['3' BatchIncrement]
    ['4' BatchDecrement]
    ['5' BypassParameterSetResult]
    ['6' AbortJobResult]
    ['7' SyncTightening]
    ['8' ReferenceSetup]
]

[enum uint 24 TraceType encoding='"ASCII"'
    ['1'   AngleTrace      ]
    ['2'   TorqueTrace     ]
    ['3'   CurrentTrace    ]
    ['4'   GradientTrace   ]
    ['5'   StrokeTrace     ]
    ['6'   ForceTrace      ]
    ['999' UnsubscribeOnAll]
]

[enum uint 8 AlarmActiveStatus encoding='"ASCII"'
    ['0'   NoAlarmIsActive]
    ['1'   AlarmIsActive  ]
]

[enum uint 8 ForcedOrder encoding='"ASCII"'
    ['0'   FreeOrder    ]
    ['1'   ForcedOrder  ]
    ['2'   FreeAndForced]
]

[enum uint 8 ToolLoosening encoding='"ASCII"'
    ['0'   Enable    ]
    ['1'   Disable  ]
    ['2'   EnableOnlyOnNokTightening]
]

[enum uint 8 JobBatchMode encoding='"ASCII"'
    ['0'   OnlyOkTighteningsAreCounted      ]
    ['1'   BothOkAndNokTighteningsAreCounted]
]

[enum uint 8 IdentifierResult encoding='"ASCII"'
    ['0'   JobVinNumber]
    ['1'   Other       ]
]
