/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvIeee8023MaxFrameSize extends TlvOrgSpecificIeee8023Unit implements Message {

  // Accessors for discriminator values.
  public TlvIEEESubType getSubType() {
    return TlvIEEESubType.MAX_FRAME_SIZE;
  }

  // Properties.
  protected final int maxSize;

  public TlvIeee8023MaxFrameSize(int maxSize) {
    super();
    this.maxSize = maxSize;
  }

  public int getMaxSize() {
    return maxSize;
  }

  @Override
  protected void serializeTlvOrgSpecificIeee8023UnitChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvIeee8023MaxFrameSize");

    // Simple Field (maxSize)
    writeSimpleField("maxSize", maxSize, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("TlvIeee8023MaxFrameSize");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvIeee8023MaxFrameSize _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (maxSize)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static TlvOrgSpecificIeee8023UnitBuilder staticParseTlvOrgSpecificIeee8023UnitBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("TlvIeee8023MaxFrameSize");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int maxSize = readSimpleField("maxSize", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("TlvIeee8023MaxFrameSize");
    // Create the instance
    return new TlvIeee8023MaxFrameSizeBuilderImpl(maxSize);
  }

  public static class TlvIeee8023MaxFrameSizeBuilderImpl
      implements TlvOrgSpecificIeee8023Unit.TlvOrgSpecificIeee8023UnitBuilder {
    private final int maxSize;

    public TlvIeee8023MaxFrameSizeBuilderImpl(int maxSize) {
      this.maxSize = maxSize;
    }

    public TlvIeee8023MaxFrameSize build() {
      TlvIeee8023MaxFrameSize tlvIeee8023MaxFrameSize = new TlvIeee8023MaxFrameSize(maxSize);
      return tlvIeee8023MaxFrameSize;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvIeee8023MaxFrameSize)) {
      return false;
    }
    TlvIeee8023MaxFrameSize that = (TlvIeee8023MaxFrameSize) o;
    return (getMaxSize() == that.getMaxSize()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMaxSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
