/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageParameterSetSelectedRev1
    extends OpenProtocolMessageParameterSetSelected implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Properties.
  protected final int parameterSetId;
  protected final String dateOfLastChangeInParameterSetSetting;

  public OpenProtocolMessageParameterSetSelectedRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      int parameterSetId,
      String dateOfLastChangeInParameterSetSetting) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.parameterSetId = parameterSetId;
    this.dateOfLastChangeInParameterSetSetting = dateOfLastChangeInParameterSetSetting;
  }

  public int getParameterSetId() {
    return parameterSetId;
  }

  public String getDateOfLastChangeInParameterSetSetting() {
    return dateOfLastChangeInParameterSetSetting;
  }

  @Override
  protected void serializeOpenProtocolMessageParameterSetSelectedChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageParameterSetSelectedRev1");

    // Simple Field (parameterSetId)
    writeSimpleField(
        "parameterSetId",
        parameterSetId,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (dateOfLastChangeInParameterSetSetting)
    writeSimpleField(
        "dateOfLastChangeInParameterSetSetting",
        dateOfLastChangeInParameterSetSetting,
        writeString(writeBuffer, 152),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageParameterSetSelectedRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageParameterSetSelectedRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (parameterSetId)
    lengthInBits += 24;

    // Simple field (dateOfLastChangeInParameterSetSetting)
    lengthInBits += 152;

    return lengthInBits;
  }

  public static OpenProtocolMessageParameterSetSelectedBuilder
      staticParseOpenProtocolMessageParameterSetSelectedBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageParameterSetSelectedRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int parameterSetId =
        readSimpleField(
            "parameterSetId", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    String dateOfLastChangeInParameterSetSetting =
        readSimpleField(
            "dateOfLastChangeInParameterSetSetting",
            readString(readBuffer, 152),
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageParameterSetSelectedRev1");
    // Create the instance
    return new OpenProtocolMessageParameterSetSelectedRev1BuilderImpl(
        parameterSetId, dateOfLastChangeInParameterSetSetting);
  }

  public static class OpenProtocolMessageParameterSetSelectedRev1BuilderImpl
      implements OpenProtocolMessageParameterSetSelected
          .OpenProtocolMessageParameterSetSelectedBuilder {
    private final int parameterSetId;
    private final String dateOfLastChangeInParameterSetSetting;

    public OpenProtocolMessageParameterSetSelectedRev1BuilderImpl(
        int parameterSetId, String dateOfLastChangeInParameterSetSetting) {
      this.parameterSetId = parameterSetId;
      this.dateOfLastChangeInParameterSetSetting = dateOfLastChangeInParameterSetSetting;
    }

    public OpenProtocolMessageParameterSetSelectedRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageParameterSetSelectedRev1 openProtocolMessageParameterSetSelectedRev1 =
          new OpenProtocolMessageParameterSetSelectedRev1(
              midRevision,
              noAckFlag,
              targetStationId,
              targetSpindleId,
              sequenceNumber,
              numberOfMessageParts,
              messagePartNumber,
              parameterSetId,
              dateOfLastChangeInParameterSetSetting);
      return openProtocolMessageParameterSetSelectedRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageParameterSetSelectedRev1)) {
      return false;
    }
    OpenProtocolMessageParameterSetSelectedRev1 that =
        (OpenProtocolMessageParameterSetSelectedRev1) o;
    return (getParameterSetId() == that.getParameterSetId())
        && (getDateOfLastChangeInParameterSetSetting()
            == that.getDateOfLastChangeInParameterSetSetting())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getParameterSetId(), getDateOfLastChangeInParameterSetSetting());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
