/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageParameterSetIdUploadReplyRev1
    extends OpenProtocolMessageParameterSetIdUploadReply implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Properties.
  protected final List<Integer> parameters;

  public OpenProtocolMessageParameterSetIdUploadReplyRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      List<Integer> parameters) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.parameters = parameters;
  }

  public List<Integer> getParameters() {
    return parameters;
  }

  @Override
  protected void serializeOpenProtocolMessageParameterSetIdUploadReplyChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageParameterSetIdUploadReplyRev1");

    // Implicit Field (numParameters) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numParameters = (int) (COUNT(getParameters()));
    writeImplicitField(
        "numParameters",
        numParameters,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Array Field (parameters)
    writeSimpleTypeArrayField(
        "parameters",
        parameters,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageParameterSetIdUploadReplyRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageParameterSetIdUploadReplyRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (numParameters)
    lengthInBits += 24;

    // Array field
    if (parameters != null) {
      lengthInBits += 24 * parameters.size();
    }

    return lengthInBits;
  }

  public static OpenProtocolMessageParameterSetIdUploadReplyBuilder
      staticParseOpenProtocolMessageParameterSetIdUploadReplyBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageParameterSetIdUploadReplyRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int numParameters =
        readImplicitField(
            "numParameters", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    List<Integer> parameters =
        readCountArrayField(
            "parameters",
            readUnsignedInt(readBuffer, 24),
            numParameters,
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageParameterSetIdUploadReplyRev1");
    // Create the instance
    return new OpenProtocolMessageParameterSetIdUploadReplyRev1BuilderImpl(parameters);
  }

  public static class OpenProtocolMessageParameterSetIdUploadReplyRev1BuilderImpl
      implements OpenProtocolMessageParameterSetIdUploadReply
          .OpenProtocolMessageParameterSetIdUploadReplyBuilder {
    private final List<Integer> parameters;

    public OpenProtocolMessageParameterSetIdUploadReplyRev1BuilderImpl(List<Integer> parameters) {
      this.parameters = parameters;
    }

    public OpenProtocolMessageParameterSetIdUploadReplyRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageParameterSetIdUploadReplyRev1
          openProtocolMessageParameterSetIdUploadReplyRev1 =
              new OpenProtocolMessageParameterSetIdUploadReplyRev1(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  parameters);
      return openProtocolMessageParameterSetIdUploadReplyRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageParameterSetIdUploadReplyRev1)) {
      return false;
    }
    OpenProtocolMessageParameterSetIdUploadReplyRev1 that =
        (OpenProtocolMessageParameterSetIdUploadReplyRev1) o;
    return (getParameters() == that.getParameters()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getParameters());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
