/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class WriterGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15482;
  }

  // Properties.
  protected final PascalString name;
  protected final boolean enabled;
  protected final MessageSecurityMode securityMode;
  protected final PascalString securityGroupId;
  protected final List<EndpointDescription> securityKeyServices;
  protected final long maxNetworkMessageSize;
  protected final List<KeyValuePair> groupProperties;
  protected final int writerGroupId;
  protected final double publishingInterval;
  protected final double keepAliveTime;
  protected final short priority;
  protected final List<PascalString> localeIds;
  protected final PascalString headerLayoutUri;
  protected final ExtensionObject transportSettings;
  protected final ExtensionObject messageSettings;
  protected final List<DataSetWriterDataType> dataSetWriters;

  public WriterGroupDataType(
      PascalString name,
      boolean enabled,
      MessageSecurityMode securityMode,
      PascalString securityGroupId,
      List<EndpointDescription> securityKeyServices,
      long maxNetworkMessageSize,
      List<KeyValuePair> groupProperties,
      int writerGroupId,
      double publishingInterval,
      double keepAliveTime,
      short priority,
      List<PascalString> localeIds,
      PascalString headerLayoutUri,
      ExtensionObject transportSettings,
      ExtensionObject messageSettings,
      List<DataSetWriterDataType> dataSetWriters) {
    super();
    this.name = name;
    this.enabled = enabled;
    this.securityMode = securityMode;
    this.securityGroupId = securityGroupId;
    this.securityKeyServices = securityKeyServices;
    this.maxNetworkMessageSize = maxNetworkMessageSize;
    this.groupProperties = groupProperties;
    this.writerGroupId = writerGroupId;
    this.publishingInterval = publishingInterval;
    this.keepAliveTime = keepAliveTime;
    this.priority = priority;
    this.localeIds = localeIds;
    this.headerLayoutUri = headerLayoutUri;
    this.transportSettings = transportSettings;
    this.messageSettings = messageSettings;
    this.dataSetWriters = dataSetWriters;
  }

  public PascalString getName() {
    return name;
  }

  public boolean getEnabled() {
    return enabled;
  }

  public MessageSecurityMode getSecurityMode() {
    return securityMode;
  }

  public PascalString getSecurityGroupId() {
    return securityGroupId;
  }

  public List<EndpointDescription> getSecurityKeyServices() {
    return securityKeyServices;
  }

  public long getMaxNetworkMessageSize() {
    return maxNetworkMessageSize;
  }

  public List<KeyValuePair> getGroupProperties() {
    return groupProperties;
  }

  public int getWriterGroupId() {
    return writerGroupId;
  }

  public double getPublishingInterval() {
    return publishingInterval;
  }

  public double getKeepAliveTime() {
    return keepAliveTime;
  }

  public short getPriority() {
    return priority;
  }

  public List<PascalString> getLocaleIds() {
    return localeIds;
  }

  public PascalString getHeaderLayoutUri() {
    return headerLayoutUri;
  }

  public ExtensionObject getTransportSettings() {
    return transportSettings;
  }

  public ExtensionObject getMessageSettings() {
    return messageSettings;
  }

  public List<DataSetWriterDataType> getDataSetWriters() {
    return dataSetWriters;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("WriterGroupDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (enabled)
    writeSimpleField("enabled", enabled, writeBoolean(writeBuffer));

    // Simple Field (securityMode)
    writeSimpleEnumField(
        "securityMode",
        "MessageSecurityMode",
        securityMode,
        writeEnum(
            MessageSecurityMode::getValue,
            MessageSecurityMode::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (securityGroupId)
    writeSimpleField("securityGroupId", securityGroupId, writeComplex(writeBuffer));

    // Implicit Field (noOfSecurityKeyServices) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSecurityKeyServices =
        (int) ((((getSecurityKeyServices()) == (null)) ? -(1) : COUNT(getSecurityKeyServices())));
    writeImplicitField(
        "noOfSecurityKeyServices", noOfSecurityKeyServices, writeSignedInt(writeBuffer, 32));

    // Array Field (securityKeyServices)
    writeComplexTypeArrayField("securityKeyServices", securityKeyServices, writeBuffer);

    // Simple Field (maxNetworkMessageSize)
    writeSimpleField(
        "maxNetworkMessageSize", maxNetworkMessageSize, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfGroupProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfGroupProperties =
        (int) ((((getGroupProperties()) == (null)) ? -(1) : COUNT(getGroupProperties())));
    writeImplicitField("noOfGroupProperties", noOfGroupProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (groupProperties)
    writeComplexTypeArrayField("groupProperties", groupProperties, writeBuffer);

    // Simple Field (writerGroupId)
    writeSimpleField("writerGroupId", writerGroupId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (publishingInterval)
    writeSimpleField("publishingInterval", publishingInterval, writeDouble(writeBuffer, 64));

    // Simple Field (keepAliveTime)
    writeSimpleField("keepAliveTime", keepAliveTime, writeDouble(writeBuffer, 64));

    // Simple Field (priority)
    writeSimpleField("priority", priority, writeUnsignedShort(writeBuffer, 8));

    // Implicit Field (noOfLocaleIds) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLocaleIds = (int) ((((getLocaleIds()) == (null)) ? -(1) : COUNT(getLocaleIds())));
    writeImplicitField("noOfLocaleIds", noOfLocaleIds, writeSignedInt(writeBuffer, 32));

    // Array Field (localeIds)
    writeComplexTypeArrayField("localeIds", localeIds, writeBuffer);

    // Simple Field (headerLayoutUri)
    writeSimpleField("headerLayoutUri", headerLayoutUri, writeComplex(writeBuffer));

    // Simple Field (transportSettings)
    writeSimpleField("transportSettings", transportSettings, writeComplex(writeBuffer));

    // Simple Field (messageSettings)
    writeSimpleField("messageSettings", messageSettings, writeComplex(writeBuffer));

    // Implicit Field (noOfDataSetWriters) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataSetWriters =
        (int) ((((getDataSetWriters()) == (null)) ? -(1) : COUNT(getDataSetWriters())));
    writeImplicitField("noOfDataSetWriters", noOfDataSetWriters, writeSignedInt(writeBuffer, 32));

    // Array Field (dataSetWriters)
    writeComplexTypeArrayField("dataSetWriters", dataSetWriters, writeBuffer);

    writeBuffer.popContext("WriterGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    WriterGroupDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (enabled)
    lengthInBits += 1;

    // Simple field (securityMode)
    lengthInBits += 32;

    // Simple field (securityGroupId)
    lengthInBits += securityGroupId.getLengthInBits();

    // Implicit Field (noOfSecurityKeyServices)
    lengthInBits += 32;

    // Array field
    if (securityKeyServices != null) {
      int i = 0;
      for (EndpointDescription element : securityKeyServices) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityKeyServices.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (maxNetworkMessageSize)
    lengthInBits += 32;

    // Implicit Field (noOfGroupProperties)
    lengthInBits += 32;

    // Array field
    if (groupProperties != null) {
      int i = 0;
      for (KeyValuePair element : groupProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= groupProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (writerGroupId)
    lengthInBits += 16;

    // Simple field (publishingInterval)
    lengthInBits += 64;

    // Simple field (keepAliveTime)
    lengthInBits += 64;

    // Simple field (priority)
    lengthInBits += 8;

    // Implicit Field (noOfLocaleIds)
    lengthInBits += 32;

    // Array field
    if (localeIds != null) {
      int i = 0;
      for (PascalString element : localeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= localeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (headerLayoutUri)
    lengthInBits += headerLayoutUri.getLengthInBits();

    // Simple field (transportSettings)
    lengthInBits += transportSettings.getLengthInBits();

    // Simple field (messageSettings)
    lengthInBits += messageSettings.getLengthInBits();

    // Implicit Field (noOfDataSetWriters)
    lengthInBits += 32;

    // Array field
    if (dataSetWriters != null) {
      int i = 0;
      for (DataSetWriterDataType element : dataSetWriters) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataSetWriters.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("WriterGroupDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean enabled = readSimpleField("enabled", readBoolean(readBuffer));

    MessageSecurityMode securityMode =
        readEnumField(
            "securityMode",
            "MessageSecurityMode",
            readEnum(MessageSecurityMode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString securityGroupId =
        readSimpleField(
            "securityGroupId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfSecurityKeyServices =
        readImplicitField("noOfSecurityKeyServices", readSignedInt(readBuffer, 32));

    List<EndpointDescription> securityKeyServices =
        readCountArrayField(
            "securityKeyServices",
            readComplex(
                () ->
                    (EndpointDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (314)),
                readBuffer),
            noOfSecurityKeyServices);

    long maxNetworkMessageSize =
        readSimpleField("maxNetworkMessageSize", readUnsignedLong(readBuffer, 32));

    int noOfGroupProperties =
        readImplicitField("noOfGroupProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> groupProperties =
        readCountArrayField(
            "groupProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfGroupProperties);

    int writerGroupId = readSimpleField("writerGroupId", readUnsignedInt(readBuffer, 16));

    double publishingInterval = readSimpleField("publishingInterval", readDouble(readBuffer, 64));

    double keepAliveTime = readSimpleField("keepAliveTime", readDouble(readBuffer, 64));

    short priority = readSimpleField("priority", readUnsignedShort(readBuffer, 8));

    int noOfLocaleIds = readImplicitField("noOfLocaleIds", readSignedInt(readBuffer, 32));

    List<PascalString> localeIds =
        readCountArrayField(
            "localeIds",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfLocaleIds);

    PascalString headerLayoutUri =
        readSimpleField(
            "headerLayoutUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    ExtensionObject transportSettings =
        readSimpleField(
            "transportSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExtensionObject messageSettings =
        readSimpleField(
            "messageSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    int noOfDataSetWriters = readImplicitField("noOfDataSetWriters", readSignedInt(readBuffer, 32));

    List<DataSetWriterDataType> dataSetWriters =
        readCountArrayField(
            "dataSetWriters",
            readComplex(
                () ->
                    (DataSetWriterDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15599)),
                readBuffer),
            noOfDataSetWriters);

    readBuffer.closeContext("WriterGroupDataType");
    // Create the instance
    return new WriterGroupDataTypeBuilderImpl(
        name,
        enabled,
        securityMode,
        securityGroupId,
        securityKeyServices,
        maxNetworkMessageSize,
        groupProperties,
        writerGroupId,
        publishingInterval,
        keepAliveTime,
        priority,
        localeIds,
        headerLayoutUri,
        transportSettings,
        messageSettings,
        dataSetWriters);
  }

  public static class WriterGroupDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final boolean enabled;
    private final MessageSecurityMode securityMode;
    private final PascalString securityGroupId;
    private final List<EndpointDescription> securityKeyServices;
    private final long maxNetworkMessageSize;
    private final List<KeyValuePair> groupProperties;
    private final int writerGroupId;
    private final double publishingInterval;
    private final double keepAliveTime;
    private final short priority;
    private final List<PascalString> localeIds;
    private final PascalString headerLayoutUri;
    private final ExtensionObject transportSettings;
    private final ExtensionObject messageSettings;
    private final List<DataSetWriterDataType> dataSetWriters;

    public WriterGroupDataTypeBuilderImpl(
        PascalString name,
        boolean enabled,
        MessageSecurityMode securityMode,
        PascalString securityGroupId,
        List<EndpointDescription> securityKeyServices,
        long maxNetworkMessageSize,
        List<KeyValuePair> groupProperties,
        int writerGroupId,
        double publishingInterval,
        double keepAliveTime,
        short priority,
        List<PascalString> localeIds,
        PascalString headerLayoutUri,
        ExtensionObject transportSettings,
        ExtensionObject messageSettings,
        List<DataSetWriterDataType> dataSetWriters) {
      this.name = name;
      this.enabled = enabled;
      this.securityMode = securityMode;
      this.securityGroupId = securityGroupId;
      this.securityKeyServices = securityKeyServices;
      this.maxNetworkMessageSize = maxNetworkMessageSize;
      this.groupProperties = groupProperties;
      this.writerGroupId = writerGroupId;
      this.publishingInterval = publishingInterval;
      this.keepAliveTime = keepAliveTime;
      this.priority = priority;
      this.localeIds = localeIds;
      this.headerLayoutUri = headerLayoutUri;
      this.transportSettings = transportSettings;
      this.messageSettings = messageSettings;
      this.dataSetWriters = dataSetWriters;
    }

    public WriterGroupDataType build() {
      WriterGroupDataType writerGroupDataType =
          new WriterGroupDataType(
              name,
              enabled,
              securityMode,
              securityGroupId,
              securityKeyServices,
              maxNetworkMessageSize,
              groupProperties,
              writerGroupId,
              publishingInterval,
              keepAliveTime,
              priority,
              localeIds,
              headerLayoutUri,
              transportSettings,
              messageSettings,
              dataSetWriters);
      return writerGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof WriterGroupDataType)) {
      return false;
    }
    WriterGroupDataType that = (WriterGroupDataType) o;
    return (getName() == that.getName())
        && (getEnabled() == that.getEnabled())
        && (getSecurityMode() == that.getSecurityMode())
        && (getSecurityGroupId() == that.getSecurityGroupId())
        && (getSecurityKeyServices() == that.getSecurityKeyServices())
        && (getMaxNetworkMessageSize() == that.getMaxNetworkMessageSize())
        && (getGroupProperties() == that.getGroupProperties())
        && (getWriterGroupId() == that.getWriterGroupId())
        && (getPublishingInterval() == that.getPublishingInterval())
        && (getKeepAliveTime() == that.getKeepAliveTime())
        && (getPriority() == that.getPriority())
        && (getLocaleIds() == that.getLocaleIds())
        && (getHeaderLayoutUri() == that.getHeaderLayoutUri())
        && (getTransportSettings() == that.getTransportSettings())
        && (getMessageSettings() == that.getMessageSettings())
        && (getDataSetWriters() == that.getDataSetWriters())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getEnabled(),
        getSecurityMode(),
        getSecurityGroupId(),
        getSecurityKeyServices(),
        getMaxNetworkMessageSize(),
        getGroupProperties(),
        getWriterGroupId(),
        getPublishingInterval(),
        getKeepAliveTime(),
        getPriority(),
        getLocaleIds(),
        getHeaderLayoutUri(),
        getTransportSettings(),
        getMessageSettings(),
        getDataSetWriters());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
