/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UadpDataSetWriterMessageDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15654;
  }

  // Properties.
  protected final UadpDataSetMessageContentMask dataSetMessageContentMask;
  protected final int configuredSize;
  protected final int networkMessageNumber;
  protected final int dataSetOffset;

  public UadpDataSetWriterMessageDataType(
      UadpDataSetMessageContentMask dataSetMessageContentMask,
      int configuredSize,
      int networkMessageNumber,
      int dataSetOffset) {
    super();
    this.dataSetMessageContentMask = dataSetMessageContentMask;
    this.configuredSize = configuredSize;
    this.networkMessageNumber = networkMessageNumber;
    this.dataSetOffset = dataSetOffset;
  }

  public UadpDataSetMessageContentMask getDataSetMessageContentMask() {
    return dataSetMessageContentMask;
  }

  public int getConfiguredSize() {
    return configuredSize;
  }

  public int getNetworkMessageNumber() {
    return networkMessageNumber;
  }

  public int getDataSetOffset() {
    return dataSetOffset;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UadpDataSetWriterMessageDataType");

    // Simple Field (dataSetMessageContentMask)
    writeSimpleEnumField(
        "dataSetMessageContentMask",
        "UadpDataSetMessageContentMask",
        dataSetMessageContentMask,
        writeEnum(
            UadpDataSetMessageContentMask::getValue,
            UadpDataSetMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (configuredSize)
    writeSimpleField("configuredSize", configuredSize, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (networkMessageNumber)
    writeSimpleField(
        "networkMessageNumber", networkMessageNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetOffset)
    writeSimpleField("dataSetOffset", dataSetOffset, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("UadpDataSetWriterMessageDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UadpDataSetWriterMessageDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (dataSetMessageContentMask)
    lengthInBits += 32;

    // Simple field (configuredSize)
    lengthInBits += 16;

    // Simple field (networkMessageNumber)
    lengthInBits += 16;

    // Simple field (dataSetOffset)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("UadpDataSetWriterMessageDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    UadpDataSetMessageContentMask dataSetMessageContentMask =
        readEnumField(
            "dataSetMessageContentMask",
            "UadpDataSetMessageContentMask",
            readEnum(
                UadpDataSetMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    int configuredSize = readSimpleField("configuredSize", readUnsignedInt(readBuffer, 16));

    int networkMessageNumber =
        readSimpleField("networkMessageNumber", readUnsignedInt(readBuffer, 16));

    int dataSetOffset = readSimpleField("dataSetOffset", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("UadpDataSetWriterMessageDataType");
    // Create the instance
    return new UadpDataSetWriterMessageDataTypeBuilderImpl(
        dataSetMessageContentMask, configuredSize, networkMessageNumber, dataSetOffset);
  }

  public static class UadpDataSetWriterMessageDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final UadpDataSetMessageContentMask dataSetMessageContentMask;
    private final int configuredSize;
    private final int networkMessageNumber;
    private final int dataSetOffset;

    public UadpDataSetWriterMessageDataTypeBuilderImpl(
        UadpDataSetMessageContentMask dataSetMessageContentMask,
        int configuredSize,
        int networkMessageNumber,
        int dataSetOffset) {
      this.dataSetMessageContentMask = dataSetMessageContentMask;
      this.configuredSize = configuredSize;
      this.networkMessageNumber = networkMessageNumber;
      this.dataSetOffset = dataSetOffset;
    }

    public UadpDataSetWriterMessageDataType build() {
      UadpDataSetWriterMessageDataType uadpDataSetWriterMessageDataType =
          new UadpDataSetWriterMessageDataType(
              dataSetMessageContentMask, configuredSize, networkMessageNumber, dataSetOffset);
      return uadpDataSetWriterMessageDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UadpDataSetWriterMessageDataType)) {
      return false;
    }
    UadpDataSetWriterMessageDataType that = (UadpDataSetWriterMessageDataType) o;
    return (getDataSetMessageContentMask() == that.getDataSetMessageContentMask())
        && (getConfiguredSize() == that.getConfiguredSize())
        && (getNetworkMessageNumber() == that.getNetworkMessageNumber())
        && (getDataSetOffset() == that.getDataSetOffset())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDataSetMessageContentMask(),
        getConfiguredSize(),
        getNetworkMessageNumber(),
        getDataSetOffset());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
