/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RegisterServer2Response extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 12196;
  }

  // Properties.
  protected final ResponseHeader responseHeader;
  protected final List<StatusCode> configurationResults;
  protected final List<DiagnosticInfo> diagnosticInfos;

  public RegisterServer2Response(
      ResponseHeader responseHeader,
      List<StatusCode> configurationResults,
      List<DiagnosticInfo> diagnosticInfos) {
    super();
    this.responseHeader = responseHeader;
    this.configurationResults = configurationResults;
    this.diagnosticInfos = diagnosticInfos;
  }

  public ResponseHeader getResponseHeader() {
    return responseHeader;
  }

  public List<StatusCode> getConfigurationResults() {
    return configurationResults;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("RegisterServer2Response");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, writeComplex(writeBuffer));

    // Implicit Field (noOfConfigurationResults) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfConfigurationResults =
        (int) ((((getConfigurationResults()) == (null)) ? -(1) : COUNT(getConfigurationResults())));
    writeImplicitField(
        "noOfConfigurationResults", noOfConfigurationResults, writeSignedInt(writeBuffer, 32));

    // Array Field (configurationResults)
    writeComplexTypeArrayField("configurationResults", configurationResults, writeBuffer);

    // Implicit Field (noOfDiagnosticInfos) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDiagnosticInfos =
        (int) ((((getDiagnosticInfos()) == (null)) ? -(1) : COUNT(getDiagnosticInfos())));
    writeImplicitField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    writeBuffer.popContext("RegisterServer2Response");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    RegisterServer2Response _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Implicit Field (noOfConfigurationResults)
    lengthInBits += 32;

    // Array field
    if (configurationResults != null) {
      int i = 0;
      for (StatusCode element : configurationResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= configurationResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= diagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("RegisterServer2Response");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ResponseHeader responseHeader =
        readSimpleField(
            "responseHeader",
            readComplex(
                () ->
                    (ResponseHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (394)),
                readBuffer));

    int noOfConfigurationResults =
        readImplicitField("noOfConfigurationResults", readSignedInt(readBuffer, 32));

    List<StatusCode> configurationResults =
        readCountArrayField(
            "configurationResults",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfConfigurationResults);

    int noOfDiagnosticInfos =
        readImplicitField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    readBuffer.closeContext("RegisterServer2Response");
    // Create the instance
    return new RegisterServer2ResponseBuilderImpl(
        responseHeader, configurationResults, diagnosticInfos);
  }

  public static class RegisterServer2ResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ResponseHeader responseHeader;
    private final List<StatusCode> configurationResults;
    private final List<DiagnosticInfo> diagnosticInfos;

    public RegisterServer2ResponseBuilderImpl(
        ResponseHeader responseHeader,
        List<StatusCode> configurationResults,
        List<DiagnosticInfo> diagnosticInfos) {
      this.responseHeader = responseHeader;
      this.configurationResults = configurationResults;
      this.diagnosticInfos = diagnosticInfos;
    }

    public RegisterServer2Response build() {
      RegisterServer2Response registerServer2Response =
          new RegisterServer2Response(responseHeader, configurationResults, diagnosticInfos);
      return registerServer2Response;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RegisterServer2Response)) {
      return false;
    }
    RegisterServer2Response that = (RegisterServer2Response) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getConfigurationResults() == that.getConfigurationResults())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getResponseHeader(), getConfigurationResults(), getDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
