/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonDataSetMetaDataMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19315;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final int dataSetWriterId;
  protected final PascalString writerGroupName;
  protected final PascalString dataSetWriterName;
  protected final long timestamp;
  protected final DataSetMetaDataType metaData;

  public JsonDataSetMetaDataMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      int dataSetWriterId,
      PascalString writerGroupName,
      PascalString dataSetWriterName,
      long timestamp,
      DataSetMetaDataType metaData) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.dataSetWriterId = dataSetWriterId;
    this.writerGroupName = writerGroupName;
    this.dataSetWriterName = dataSetWriterName;
    this.timestamp = timestamp;
    this.metaData = metaData;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public int getDataSetWriterId() {
    return dataSetWriterId;
  }

  public PascalString getWriterGroupName() {
    return writerGroupName;
  }

  public PascalString getDataSetWriterName() {
    return dataSetWriterName;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public DataSetMetaDataType getMetaData() {
    return metaData;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonDataSetMetaDataMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (dataSetWriterId)
    writeSimpleField("dataSetWriterId", dataSetWriterId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (writerGroupName)
    writeSimpleField("writerGroupName", writerGroupName, writeComplex(writeBuffer));

    // Simple Field (dataSetWriterName)
    writeSimpleField("dataSetWriterName", dataSetWriterName, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (metaData)
    writeSimpleField("metaData", metaData, writeComplex(writeBuffer));

    writeBuffer.popContext("JsonDataSetMetaDataMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonDataSetMetaDataMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (dataSetWriterId)
    lengthInBits += 16;

    // Simple field (writerGroupName)
    lengthInBits += writerGroupName.getLengthInBits();

    // Simple field (dataSetWriterName)
    lengthInBits += dataSetWriterName.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (metaData)
    lengthInBits += metaData.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonDataSetMetaDataMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int dataSetWriterId = readSimpleField("dataSetWriterId", readUnsignedInt(readBuffer, 16));

    PascalString writerGroupName =
        readSimpleField(
            "writerGroupName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString dataSetWriterName =
        readSimpleField(
            "dataSetWriterName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    DataSetMetaDataType metaData =
        readSimpleField(
            "metaData",
            readComplex(
                () ->
                    (DataSetMetaDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14525)),
                readBuffer));

    readBuffer.closeContext("JsonDataSetMetaDataMessage");
    // Create the instance
    return new JsonDataSetMetaDataMessageBuilderImpl(
        messageId,
        messageType,
        publisherId,
        dataSetWriterId,
        writerGroupName,
        dataSetWriterName,
        timestamp,
        metaData);
  }

  public static class JsonDataSetMetaDataMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final int dataSetWriterId;
    private final PascalString writerGroupName;
    private final PascalString dataSetWriterName;
    private final long timestamp;
    private final DataSetMetaDataType metaData;

    public JsonDataSetMetaDataMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        int dataSetWriterId,
        PascalString writerGroupName,
        PascalString dataSetWriterName,
        long timestamp,
        DataSetMetaDataType metaData) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.dataSetWriterId = dataSetWriterId;
      this.writerGroupName = writerGroupName;
      this.dataSetWriterName = dataSetWriterName;
      this.timestamp = timestamp;
      this.metaData = metaData;
    }

    public JsonDataSetMetaDataMessage build() {
      JsonDataSetMetaDataMessage jsonDataSetMetaDataMessage =
          new JsonDataSetMetaDataMessage(
              messageId,
              messageType,
              publisherId,
              dataSetWriterId,
              writerGroupName,
              dataSetWriterName,
              timestamp,
              metaData);
      return jsonDataSetMetaDataMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonDataSetMetaDataMessage)) {
      return false;
    }
    JsonDataSetMetaDataMessage that = (JsonDataSetMetaDataMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getDataSetWriterId() == that.getDataSetWriterId())
        && (getWriterGroupName() == that.getWriterGroupName())
        && (getDataSetWriterName() == that.getDataSetWriterName())
        && (getTimestamp() == that.getTimestamp())
        && (getMetaData() == that.getMetaData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getDataSetWriterId(),
        getWriterGroupName(),
        getDataSetWriterName(),
        getTimestamp(),
        getMetaData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
