/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonActionNetworkMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19322;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final long timestamp;
  protected final PascalString responseAddress;
  protected final PascalByteString correlationData;
  protected final PascalString requestorId;
  protected final double timeoutHint;
  protected final List<ExtensionObject> messages;

  public JsonActionNetworkMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      long timestamp,
      PascalString responseAddress,
      PascalByteString correlationData,
      PascalString requestorId,
      double timeoutHint,
      List<ExtensionObject> messages) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.timestamp = timestamp;
    this.responseAddress = responseAddress;
    this.correlationData = correlationData;
    this.requestorId = requestorId;
    this.timeoutHint = timeoutHint;
    this.messages = messages;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public PascalString getResponseAddress() {
    return responseAddress;
  }

  public PascalByteString getCorrelationData() {
    return correlationData;
  }

  public PascalString getRequestorId() {
    return requestorId;
  }

  public double getTimeoutHint() {
    return timeoutHint;
  }

  public List<ExtensionObject> getMessages() {
    return messages;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonActionNetworkMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (responseAddress)
    writeSimpleField("responseAddress", responseAddress, writeComplex(writeBuffer));

    // Simple Field (correlationData)
    writeSimpleField("correlationData", correlationData, writeComplex(writeBuffer));

    // Simple Field (requestorId)
    writeSimpleField("requestorId", requestorId, writeComplex(writeBuffer));

    // Simple Field (timeoutHint)
    writeSimpleField("timeoutHint", timeoutHint, writeDouble(writeBuffer, 64));

    // Implicit Field (noOfMessages) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfMessages = (int) ((((getMessages()) == (null)) ? -(1) : COUNT(getMessages())));
    writeImplicitField("noOfMessages", noOfMessages, writeSignedInt(writeBuffer, 32));

    // Array Field (messages)
    writeComplexTypeArrayField("messages", messages, writeBuffer);

    writeBuffer.popContext("JsonActionNetworkMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonActionNetworkMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (responseAddress)
    lengthInBits += responseAddress.getLengthInBits();

    // Simple field (correlationData)
    lengthInBits += correlationData.getLengthInBits();

    // Simple field (requestorId)
    lengthInBits += requestorId.getLengthInBits();

    // Simple field (timeoutHint)
    lengthInBits += 64;

    // Implicit Field (noOfMessages)
    lengthInBits += 32;

    // Array field
    if (messages != null) {
      int i = 0;
      for (ExtensionObject element : messages) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= messages.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonActionNetworkMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    PascalString responseAddress =
        readSimpleField(
            "responseAddress", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalByteString correlationData =
        readSimpleField(
            "correlationData",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer));

    PascalString requestorId =
        readSimpleField(
            "requestorId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    double timeoutHint = readSimpleField("timeoutHint", readDouble(readBuffer, 64));

    int noOfMessages = readImplicitField("noOfMessages", readSignedInt(readBuffer, 32));

    List<ExtensionObject> messages =
        readCountArrayField(
            "messages",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfMessages);

    readBuffer.closeContext("JsonActionNetworkMessage");
    // Create the instance
    return new JsonActionNetworkMessageBuilderImpl(
        messageId,
        messageType,
        publisherId,
        timestamp,
        responseAddress,
        correlationData,
        requestorId,
        timeoutHint,
        messages);
  }

  public static class JsonActionNetworkMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final long timestamp;
    private final PascalString responseAddress;
    private final PascalByteString correlationData;
    private final PascalString requestorId;
    private final double timeoutHint;
    private final List<ExtensionObject> messages;

    public JsonActionNetworkMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        long timestamp,
        PascalString responseAddress,
        PascalByteString correlationData,
        PascalString requestorId,
        double timeoutHint,
        List<ExtensionObject> messages) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.timestamp = timestamp;
      this.responseAddress = responseAddress;
      this.correlationData = correlationData;
      this.requestorId = requestorId;
      this.timeoutHint = timeoutHint;
      this.messages = messages;
    }

    public JsonActionNetworkMessage build() {
      JsonActionNetworkMessage jsonActionNetworkMessage =
          new JsonActionNetworkMessage(
              messageId,
              messageType,
              publisherId,
              timestamp,
              responseAddress,
              correlationData,
              requestorId,
              timeoutHint,
              messages);
      return jsonActionNetworkMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonActionNetworkMessage)) {
      return false;
    }
    JsonActionNetworkMessage that = (JsonActionNetworkMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getTimestamp() == that.getTimestamp())
        && (getResponseAddress() == that.getResponseAddress())
        && (getCorrelationData() == that.getCorrelationData())
        && (getRequestorId() == that.getRequestorId())
        && (getTimeoutHint() == that.getTimeoutHint())
        && (getMessages() == that.getMessages())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getTimestamp(),
        getResponseAddress(),
        getCorrelationData(),
        getRequestorId(),
        getTimeoutHint(),
        getMessages());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
