/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonActionMetaDataMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19320;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final int dataSetWriterId;
  protected final PascalString dataSetWriterName;
  protected final long timestamp;
  protected final List<ActionTargetDataType> actionTargets;
  protected final DataSetMetaDataType request;
  protected final DataSetMetaDataType response;
  protected final List<ActionMethodDataType> actionMethods;

  public JsonActionMetaDataMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      int dataSetWriterId,
      PascalString dataSetWriterName,
      long timestamp,
      List<ActionTargetDataType> actionTargets,
      DataSetMetaDataType request,
      DataSetMetaDataType response,
      List<ActionMethodDataType> actionMethods) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.dataSetWriterId = dataSetWriterId;
    this.dataSetWriterName = dataSetWriterName;
    this.timestamp = timestamp;
    this.actionTargets = actionTargets;
    this.request = request;
    this.response = response;
    this.actionMethods = actionMethods;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public int getDataSetWriterId() {
    return dataSetWriterId;
  }

  public PascalString getDataSetWriterName() {
    return dataSetWriterName;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public List<ActionTargetDataType> getActionTargets() {
    return actionTargets;
  }

  public DataSetMetaDataType getRequest() {
    return request;
  }

  public DataSetMetaDataType getResponse() {
    return response;
  }

  public List<ActionMethodDataType> getActionMethods() {
    return actionMethods;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonActionMetaDataMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (dataSetWriterId)
    writeSimpleField("dataSetWriterId", dataSetWriterId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetWriterName)
    writeSimpleField("dataSetWriterName", dataSetWriterName, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Implicit Field (noOfActionTargets) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfActionTargets =
        (int) ((((getActionTargets()) == (null)) ? -(1) : COUNT(getActionTargets())));
    writeImplicitField("noOfActionTargets", noOfActionTargets, writeSignedInt(writeBuffer, 32));

    // Array Field (actionTargets)
    writeComplexTypeArrayField("actionTargets", actionTargets, writeBuffer);

    // Simple Field (request)
    writeSimpleField("request", request, writeComplex(writeBuffer));

    // Simple Field (response)
    writeSimpleField("response", response, writeComplex(writeBuffer));

    // Implicit Field (noOfActionMethods) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfActionMethods =
        (int) ((((getActionMethods()) == (null)) ? -(1) : COUNT(getActionMethods())));
    writeImplicitField("noOfActionMethods", noOfActionMethods, writeSignedInt(writeBuffer, 32));

    // Array Field (actionMethods)
    writeComplexTypeArrayField("actionMethods", actionMethods, writeBuffer);

    writeBuffer.popContext("JsonActionMetaDataMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonActionMetaDataMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (dataSetWriterId)
    lengthInBits += 16;

    // Simple field (dataSetWriterName)
    lengthInBits += dataSetWriterName.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Implicit Field (noOfActionTargets)
    lengthInBits += 32;

    // Array field
    if (actionTargets != null) {
      int i = 0;
      for (ActionTargetDataType element : actionTargets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= actionTargets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (request)
    lengthInBits += request.getLengthInBits();

    // Simple field (response)
    lengthInBits += response.getLengthInBits();

    // Implicit Field (noOfActionMethods)
    lengthInBits += 32;

    // Array field
    if (actionMethods != null) {
      int i = 0;
      for (ActionMethodDataType element : actionMethods) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= actionMethods.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonActionMetaDataMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int dataSetWriterId = readSimpleField("dataSetWriterId", readUnsignedInt(readBuffer, 16));

    PascalString dataSetWriterName =
        readSimpleField(
            "dataSetWriterName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    int noOfActionTargets = readImplicitField("noOfActionTargets", readSignedInt(readBuffer, 32));

    List<ActionTargetDataType> actionTargets =
        readCountArrayField(
            "actionTargets",
            readComplex(
                () ->
                    (ActionTargetDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (18595)),
                readBuffer),
            noOfActionTargets);

    DataSetMetaDataType request =
        readSimpleField(
            "request",
            readComplex(
                () ->
                    (DataSetMetaDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14525)),
                readBuffer));

    DataSetMetaDataType response =
        readSimpleField(
            "response",
            readComplex(
                () ->
                    (DataSetMetaDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14525)),
                readBuffer));

    int noOfActionMethods = readImplicitField("noOfActionMethods", readSignedInt(readBuffer, 32));

    List<ActionMethodDataType> actionMethods =
        readCountArrayField(
            "actionMethods",
            readComplex(
                () ->
                    (ActionMethodDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (18599)),
                readBuffer),
            noOfActionMethods);

    readBuffer.closeContext("JsonActionMetaDataMessage");
    // Create the instance
    return new JsonActionMetaDataMessageBuilderImpl(
        messageId,
        messageType,
        publisherId,
        dataSetWriterId,
        dataSetWriterName,
        timestamp,
        actionTargets,
        request,
        response,
        actionMethods);
  }

  public static class JsonActionMetaDataMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final int dataSetWriterId;
    private final PascalString dataSetWriterName;
    private final long timestamp;
    private final List<ActionTargetDataType> actionTargets;
    private final DataSetMetaDataType request;
    private final DataSetMetaDataType response;
    private final List<ActionMethodDataType> actionMethods;

    public JsonActionMetaDataMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        int dataSetWriterId,
        PascalString dataSetWriterName,
        long timestamp,
        List<ActionTargetDataType> actionTargets,
        DataSetMetaDataType request,
        DataSetMetaDataType response,
        List<ActionMethodDataType> actionMethods) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.dataSetWriterId = dataSetWriterId;
      this.dataSetWriterName = dataSetWriterName;
      this.timestamp = timestamp;
      this.actionTargets = actionTargets;
      this.request = request;
      this.response = response;
      this.actionMethods = actionMethods;
    }

    public JsonActionMetaDataMessage build() {
      JsonActionMetaDataMessage jsonActionMetaDataMessage =
          new JsonActionMetaDataMessage(
              messageId,
              messageType,
              publisherId,
              dataSetWriterId,
              dataSetWriterName,
              timestamp,
              actionTargets,
              request,
              response,
              actionMethods);
      return jsonActionMetaDataMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonActionMetaDataMessage)) {
      return false;
    }
    JsonActionMetaDataMessage that = (JsonActionMetaDataMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getDataSetWriterId() == that.getDataSetWriterId())
        && (getDataSetWriterName() == that.getDataSetWriterName())
        && (getTimestamp() == that.getTimestamp())
        && (getActionTargets() == that.getActionTargets())
        && (getRequest() == that.getRequest())
        && (getResponse() == that.getResponse())
        && (getActionMethods() == that.getActionMethods())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getDataSetWriterId(),
        getDataSetWriterName(),
        getTimestamp(),
        getActionTargets(),
        getRequest(),
        getResponse(),
        getActionMethods());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
