/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ConnectedAddressItem extends TypeId implements Message {

  // Accessors for discriminator values.
  public Integer getId() {
    return (int) 0x00A1;
  }

  // Properties.
  protected final long connectionId;

  public ConnectedAddressItem(long connectionId) {
    super();
    this.connectionId = connectionId;
  }

  public long getConnectionId() {
    return connectionId;
  }

  @Override
  protected void serializeTypeIdChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ConnectedAddressItem");

    // Reserved Field (reserved)
    writeReservedField("reserved", (int) 0x0004, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (connectionId)
    writeSimpleField("connectionId", connectionId, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("ConnectedAddressItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ConnectedAddressItem _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Simple field (connectionId)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static TypeIdBuilder staticParseTypeIdBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("ConnectedAddressItem");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Integer reservedField0 =
        readReservedField("reserved", readUnsignedInt(readBuffer, 16), (int) 0x0004);

    long connectionId = readSimpleField("connectionId", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("ConnectedAddressItem");
    // Create the instance
    return new ConnectedAddressItemBuilderImpl(connectionId);
  }

  public static class ConnectedAddressItemBuilderImpl implements TypeId.TypeIdBuilder {
    private final long connectionId;

    public ConnectedAddressItemBuilderImpl(long connectionId) {
      this.connectionId = connectionId;
    }

    public ConnectedAddressItem build() {
      ConnectedAddressItem connectedAddressItem = new ConnectedAddressItem(connectionId);
      return connectedAddressItem;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ConnectedAddressItem)) {
      return false;
    }
    ConnectedAddressItem that = (ConnectedAddressItem) o;
    return (getConnectionId() == that.getConnectionId()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getConnectionId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
