/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * Retain Data Statitics
 */
@JsonPropertyOrder({
  RetainStats.JSON_PROPERTY_TOTAL,
  RetainStats.JSON_PROPERTY_FREE,
  RetainStats.JSON_PROPERTY_USED,
  RetainStats.JSON_PROPERTY_BIGGEST_FREE,
  RetainStats.JSON_PROPERTY_SYNC_COUNTER,
  RetainStats.JSON_PROPERTY_LAST_USED,
  RetainStats.JSON_PROPERTY_INFO
})
@JsonTypeName("RetainStats")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class RetainStats {
  public static final String JSON_PROPERTY_TOTAL = "total";
  private Integer total;

  public static final String JSON_PROPERTY_FREE = "free";
  private Integer free;

  public static final String JSON_PROPERTY_USED = "used";
  private Integer used;

  public static final String JSON_PROPERTY_BIGGEST_FREE = "biggestFree";
  private Integer biggestFree;

  public static final String JSON_PROPERTY_SYNC_COUNTER = "syncCounter";
  private Integer syncCounter;

  public static final String JSON_PROPERTY_LAST_USED = "lastUsed";
  private Integer lastUsed;

  public static final String JSON_PROPERTY_INFO = "info";
  private String info;

  public RetainStats() {
  }

  public RetainStats total(Integer total) {
    
    this.total = total;
    return this;
  }

   /**
   * total size of memory in bytes
   * minimum: 0
   * maximum: 4294967295
   * @return total
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Integer total) {
    this.total = total;
  }


  public RetainStats free(Integer free) {
    
    this.free = free;
    return this;
  }

   /**
   * free size of memory in bytes
   * minimum: 0
   * maximum: 4294967295
   * @return free
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFree() {
    return free;
  }


  @JsonProperty(JSON_PROPERTY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFree(Integer free) {
    this.free = free;
  }


  public RetainStats used(Integer used) {
    
    this.used = used;
    return this;
  }

   /**
   * used size of memory in bytes
   * minimum: 0
   * maximum: 4294967295
   * @return used
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUsed() {
    return used;
  }


  @JsonProperty(JSON_PROPERTY_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsed(Integer used) {
    this.used = used;
  }


  public RetainStats biggestFree(Integer biggestFree) {
    
    this.biggestFree = biggestFree;
    return this;
  }

   /**
   * biggest free chunk of memory in bytes
   * minimum: 0
   * maximum: 4294967295
   * @return biggestFree
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIGGEST_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBiggestFree() {
    return biggestFree;
  }


  @JsonProperty(JSON_PROPERTY_BIGGEST_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBiggestFree(Integer biggestFree) {
    this.biggestFree = biggestFree;
  }


  public RetainStats syncCounter(Integer syncCounter) {
    
    this.syncCounter = syncCounter;
    return this;
  }

   /**
   * now often was the nvram synced
   * minimum: 0
   * maximum: 4294967295
   * @return syncCounter
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SYNC_COUNTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSyncCounter() {
    return syncCounter;
  }


  @JsonProperty(JSON_PROPERTY_SYNC_COUNTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSyncCounter(Integer syncCounter) {
    this.syncCounter = syncCounter;
  }


  public RetainStats lastUsed(Integer lastUsed) {
    
    this.lastUsed = lastUsed;
    return this;
  }

   /**
   * last used offset
   * minimum: 0
   * maximum: 4294967295
   * @return lastUsed
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLastUsed() {
    return lastUsed;
  }


  @JsonProperty(JSON_PROPERTY_LAST_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUsed(Integer lastUsed) {
    this.lastUsed = lastUsed;
  }


  public RetainStats info(String info) {
    
    this.info = info;
    return this;
  }

   /**
   * debug information of shared memory
   * @return info
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInfo() {
    return info;
  }


  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfo(String info) {
    this.info = info;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RetainStats RetainStats = (RetainStats) o;
    return Objects.equals(this.total, RetainStats.total) &&
        Objects.equals(this.free, RetainStats.free) &&
        Objects.equals(this.used, RetainStats.used) &&
        Objects.equals(this.biggestFree, RetainStats.biggestFree) &&
        Objects.equals(this.syncCounter, RetainStats.syncCounter) &&
        Objects.equals(this.lastUsed, RetainStats.lastUsed) &&
        Objects.equals(this.info, RetainStats.info);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, free, used, biggestFree, syncCounter, lastUsed, info);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RetainStats {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    free: ").append(toIndentedString(free)).append("\n");
    sb.append("    used: ").append(toIndentedString(used)).append("\n");
    sb.append("    biggestFree: ").append(toIndentedString(biggestFree)).append("\n");
    sb.append("    syncCounter: ").append(toIndentedString(syncCounter)).append("\n");
    sb.append("    lastUsed: ").append(toIndentedString(lastUsed)).append("\n");
    sb.append("    info: ").append(toIndentedString(info)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `total` to the URL query string
    if (getTotal() != null) {
      try {
        joiner.add(String.format("%stotal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTotal()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `free` to the URL query string
    if (getFree() != null) {
      try {
        joiner.add(String.format("%sfree%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFree()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `used` to the URL query string
    if (getUsed() != null) {
      try {
        joiner.add(String.format("%sused%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUsed()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `biggestFree` to the URL query string
    if (getBiggestFree() != null) {
      try {
        joiner.add(String.format("%sbiggestFree%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBiggestFree()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `syncCounter` to the URL query string
    if (getSyncCounter() != null) {
      try {
        joiner.add(String.format("%ssyncCounter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSyncCounter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `lastUsed` to the URL query string
    if (getLastUsed() != null) {
      try {
        joiner.add(String.format("%slastUsed%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLastUsed()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `info` to the URL query string
    if (getInfo() != null) {
      try {
        joiner.add(String.format("%sinfo%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInfo()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

