/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * CommDatalayerChangeEvents
 */
@JsonPropertyOrder({
  CommDatalayerChangeEvents.JSON_PROPERTY_VALUE_CHANGE,
  CommDatalayerChangeEvents.JSON_PROPERTY_BROWSELIST_CHANGE,
  CommDatalayerChangeEvents.JSON_PROPERTY_METADATA_CHANGE
})
@JsonTypeName("comm_datalayer_ChangeEvents")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class CommDatalayerChangeEvents {
  public static final String JSON_PROPERTY_VALUE_CHANGE = "valueChange";
  private CommDatalayerDataChangeTrigger valueChange;

  public static final String JSON_PROPERTY_BROWSELIST_CHANGE = "browselistChange";
  private Boolean browselistChange;

  public static final String JSON_PROPERTY_METADATA_CHANGE = "metadataChange";
  private Boolean metadataChange;

  public CommDatalayerChangeEvents() {
  }

  public CommDatalayerChangeEvents valueChange(CommDatalayerDataChangeTrigger valueChange) {
    
    this.valueChange = valueChange;
    return this;
  }

   /**
   * Get valueChange
   * @return valueChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CommDatalayerDataChangeTrigger getValueChange() {
    return valueChange;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueChange(CommDatalayerDataChangeTrigger valueChange) {
    this.valueChange = valueChange;
  }


  public CommDatalayerChangeEvents browselistChange(Boolean browselistChange) {
    
    this.browselistChange = browselistChange;
    return this;
  }

   /**
   * Get browselistChange
   * @return browselistChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BROWSELIST_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBrowselistChange() {
    return browselistChange;
  }


  @JsonProperty(JSON_PROPERTY_BROWSELIST_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrowselistChange(Boolean browselistChange) {
    this.browselistChange = browselistChange;
  }


  public CommDatalayerChangeEvents metadataChange(Boolean metadataChange) {
    
    this.metadataChange = metadataChange;
    return this;
  }

   /**
   * Get metadataChange
   * @return metadataChange
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMetadataChange() {
    return metadataChange;
  }


  @JsonProperty(JSON_PROPERTY_METADATA_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadataChange(Boolean metadataChange) {
    this.metadataChange = metadataChange;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommDatalayerChangeEvents commDatalayerChangeEvents = (CommDatalayerChangeEvents) o;
    return Objects.equals(this.valueChange, commDatalayerChangeEvents.valueChange) &&
        Objects.equals(this.browselistChange, commDatalayerChangeEvents.browselistChange) &&
        Objects.equals(this.metadataChange, commDatalayerChangeEvents.metadataChange);
  }

  @Override
  public int hashCode() {
    return Objects.hash(valueChange, browselistChange, metadataChange);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommDatalayerChangeEvents {\n");
    sb.append("    valueChange: ").append(toIndentedString(valueChange)).append("\n");
    sb.append("    browselistChange: ").append(toIndentedString(browselistChange)).append("\n");
    sb.append("    metadataChange: ").append(toIndentedString(metadataChange)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `valueChange` to the URL query string
    if (getValueChange() != null) {
      try {
        joiner.add(String.format("%svalueChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValueChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `browselistChange` to the URL query string
    if (getBrowselistChange() != null) {
      try {
        joiner.add(String.format("%sbrowselistChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBrowselistChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `metadataChange` to the URL query string
    if (getMetadataChange() != null) {
      try {
        joiner.add(String.format("%smetadataChange%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMetadataChange()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

