/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IdentifyReplyCommandUnitSummary implements Message {

  // Properties.
  protected final boolean assertingNetworkBurden;
  protected final boolean restrikeTimingActive;
  protected final boolean remoteOFFInputAsserted;
  protected final boolean remoteONInputAsserted;
  protected final boolean localToggleEnabled;
  protected final boolean localToggleActiveState;
  protected final boolean clockGenerationEnabled;
  protected final boolean unitGeneratingClock;

  public IdentifyReplyCommandUnitSummary(
      boolean assertingNetworkBurden,
      boolean restrikeTimingActive,
      boolean remoteOFFInputAsserted,
      boolean remoteONInputAsserted,
      boolean localToggleEnabled,
      boolean localToggleActiveState,
      boolean clockGenerationEnabled,
      boolean unitGeneratingClock) {
    super();
    this.assertingNetworkBurden = assertingNetworkBurden;
    this.restrikeTimingActive = restrikeTimingActive;
    this.remoteOFFInputAsserted = remoteOFFInputAsserted;
    this.remoteONInputAsserted = remoteONInputAsserted;
    this.localToggleEnabled = localToggleEnabled;
    this.localToggleActiveState = localToggleActiveState;
    this.clockGenerationEnabled = clockGenerationEnabled;
    this.unitGeneratingClock = unitGeneratingClock;
  }

  public boolean getAssertingNetworkBurden() {
    return assertingNetworkBurden;
  }

  public boolean getRestrikeTimingActive() {
    return restrikeTimingActive;
  }

  public boolean getRemoteOFFInputAsserted() {
    return remoteOFFInputAsserted;
  }

  public boolean getRemoteONInputAsserted() {
    return remoteONInputAsserted;
  }

  public boolean getLocalToggleEnabled() {
    return localToggleEnabled;
  }

  public boolean getLocalToggleActiveState() {
    return localToggleActiveState;
  }

  public boolean getClockGenerationEnabled() {
    return clockGenerationEnabled;
  }

  public boolean getUnitGeneratingClock() {
    return unitGeneratingClock;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("IdentifyReplyCommandUnitSummary");

    // Simple Field (assertingNetworkBurden)
    writeSimpleField("assertingNetworkBurden", assertingNetworkBurden, writeBoolean(writeBuffer));

    // Simple Field (restrikeTimingActive)
    writeSimpleField("restrikeTimingActive", restrikeTimingActive, writeBoolean(writeBuffer));

    // Simple Field (remoteOFFInputAsserted)
    writeSimpleField("remoteOFFInputAsserted", remoteOFFInputAsserted, writeBoolean(writeBuffer));

    // Simple Field (remoteONInputAsserted)
    writeSimpleField("remoteONInputAsserted", remoteONInputAsserted, writeBoolean(writeBuffer));

    // Simple Field (localToggleEnabled)
    writeSimpleField("localToggleEnabled", localToggleEnabled, writeBoolean(writeBuffer));

    // Simple Field (localToggleActiveState)
    writeSimpleField("localToggleActiveState", localToggleActiveState, writeBoolean(writeBuffer));

    // Simple Field (clockGenerationEnabled)
    writeSimpleField("clockGenerationEnabled", clockGenerationEnabled, writeBoolean(writeBuffer));

    // Simple Field (unitGeneratingClock)
    writeSimpleField("unitGeneratingClock", unitGeneratingClock, writeBoolean(writeBuffer));

    writeBuffer.popContext("IdentifyReplyCommandUnitSummary");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    IdentifyReplyCommandUnitSummary _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (assertingNetworkBurden)
    lengthInBits += 1;

    // Simple field (restrikeTimingActive)
    lengthInBits += 1;

    // Simple field (remoteOFFInputAsserted)
    lengthInBits += 1;

    // Simple field (remoteONInputAsserted)
    lengthInBits += 1;

    // Simple field (localToggleEnabled)
    lengthInBits += 1;

    // Simple field (localToggleActiveState)
    lengthInBits += 1;

    // Simple field (clockGenerationEnabled)
    lengthInBits += 1;

    // Simple field (unitGeneratingClock)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static IdentifyReplyCommandUnitSummary staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("IdentifyReplyCommandUnitSummary");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean assertingNetworkBurden =
        readSimpleField("assertingNetworkBurden", readBoolean(readBuffer));

    boolean restrikeTimingActive = readSimpleField("restrikeTimingActive", readBoolean(readBuffer));

    boolean remoteOFFInputAsserted =
        readSimpleField("remoteOFFInputAsserted", readBoolean(readBuffer));

    boolean remoteONInputAsserted =
        readSimpleField("remoteONInputAsserted", readBoolean(readBuffer));

    boolean localToggleEnabled = readSimpleField("localToggleEnabled", readBoolean(readBuffer));

    boolean localToggleActiveState =
        readSimpleField("localToggleActiveState", readBoolean(readBuffer));

    boolean clockGenerationEnabled =
        readSimpleField("clockGenerationEnabled", readBoolean(readBuffer));

    boolean unitGeneratingClock = readSimpleField("unitGeneratingClock", readBoolean(readBuffer));

    readBuffer.closeContext("IdentifyReplyCommandUnitSummary");
    // Create the instance
    IdentifyReplyCommandUnitSummary _identifyReplyCommandUnitSummary;
    _identifyReplyCommandUnitSummary =
        new IdentifyReplyCommandUnitSummary(
            assertingNetworkBurden,
            restrikeTimingActive,
            remoteOFFInputAsserted,
            remoteONInputAsserted,
            localToggleEnabled,
            localToggleActiveState,
            clockGenerationEnabled,
            unitGeneratingClock);
    return _identifyReplyCommandUnitSummary;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IdentifyReplyCommandUnitSummary)) {
      return false;
    }
    IdentifyReplyCommandUnitSummary that = (IdentifyReplyCommandUnitSummary) o;
    return (getAssertingNetworkBurden() == that.getAssertingNetworkBurden())
        && (getRestrikeTimingActive() == that.getRestrikeTimingActive())
        && (getRemoteOFFInputAsserted() == that.getRemoteOFFInputAsserted())
        && (getRemoteONInputAsserted() == that.getRemoteONInputAsserted())
        && (getLocalToggleEnabled() == that.getLocalToggleEnabled())
        && (getLocalToggleActiveState() == that.getLocalToggleActiveState())
        && (getClockGenerationEnabled() == that.getClockGenerationEnabled())
        && (getUnitGeneratingClock() == that.getUnitGeneratingClock())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getAssertingNetworkBurden(),
        getRestrikeTimingActive(),
        getRemoteOFFInputAsserted(),
        getRemoteONInputAsserted(),
        getLocalToggleEnabled(),
        getLocalToggleActiveState(),
        getClockGenerationEnabled(),
        getUnitGeneratingClock());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
