/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetServiceAckReadPropertyConditional extends BACnetServiceAck implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.READ_PROPERTY_CONDITIONAL;
  }

  // Properties.
  protected final byte[] bytesOfRemovedService;

  // Arguments.
  protected final Long serviceAckPayloadLength;
  protected final Long serviceAckLength;

  public BACnetServiceAckReadPropertyConditional(
      byte[] bytesOfRemovedService, Long serviceAckPayloadLength, Long serviceAckLength) {
    super(serviceAckLength);
    this.bytesOfRemovedService = bytesOfRemovedService;
    this.serviceAckPayloadLength = serviceAckPayloadLength;
    this.serviceAckLength = serviceAckLength;
  }

  public byte[] getBytesOfRemovedService() {
    return bytesOfRemovedService;
  }

  @Override
  protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetServiceAckReadPropertyConditional");

    // Array Field (bytesOfRemovedService)
    writeByteArrayField(
        "bytesOfRemovedService", bytesOfRemovedService, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("BACnetServiceAckReadPropertyConditional");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetServiceAckReadPropertyConditional _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (bytesOfRemovedService != null) {
      lengthInBits += 8 * bytesOfRemovedService.length;
    }

    return lengthInBits;
  }

  public static BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(
      ReadBuffer readBuffer, Long serviceAckPayloadLength, Long serviceAckLength)
      throws ParseException {
    readBuffer.pullContext("BACnetServiceAckReadPropertyConditional");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte[] bytesOfRemovedService =
        readBuffer.readByteArray("bytesOfRemovedService", Math.toIntExact(serviceAckPayloadLength));

    readBuffer.closeContext("BACnetServiceAckReadPropertyConditional");
    // Create the instance
    return new BACnetServiceAckReadPropertyConditionalBuilderImpl(
        bytesOfRemovedService, serviceAckPayloadLength, serviceAckLength);
  }

  public static class BACnetServiceAckReadPropertyConditionalBuilderImpl
      implements BACnetServiceAck.BACnetServiceAckBuilder {
    private final byte[] bytesOfRemovedService;
    private final Long serviceAckPayloadLength;
    private final Long serviceAckLength;

    public BACnetServiceAckReadPropertyConditionalBuilderImpl(
        byte[] bytesOfRemovedService, Long serviceAckPayloadLength, Long serviceAckLength) {
      this.bytesOfRemovedService = bytesOfRemovedService;
      this.serviceAckPayloadLength = serviceAckPayloadLength;
      this.serviceAckLength = serviceAckLength;
    }

    public BACnetServiceAckReadPropertyConditional build(Long serviceAckLength) {

      BACnetServiceAckReadPropertyConditional bACnetServiceAckReadPropertyConditional =
          new BACnetServiceAckReadPropertyConditional(
              bytesOfRemovedService, serviceAckPayloadLength, serviceAckLength);
      return bACnetServiceAckReadPropertyConditional;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetServiceAckReadPropertyConditional)) {
      return false;
    }
    BACnetServiceAckReadPropertyConditional that = (BACnetServiceAckReadPropertyConditional) o;
    return (getBytesOfRemovedService() == that.getBytesOfRemovedService())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getBytesOfRemovedService());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
