/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantDateTime is the corresponding interface of VariantDateTime
type VariantDateTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []int64
	// IsVariantDateTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantDateTime()
	// CreateBuilder creates a VariantDateTimeBuilder
	CreateVariantDateTimeBuilder() VariantDateTimeBuilder
}

// _VariantDateTime is the data-structure of this message
type _VariantDateTime struct {
	VariantContract
	ArrayLength *int32
	Value       []int64
}

var _ VariantDateTime = (*_VariantDateTime)(nil)
var _ VariantRequirements = (*_VariantDateTime)(nil)

// NewVariantDateTime factory function for _VariantDateTime
func NewVariantDateTime(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []int64) *_VariantDateTime {
	_result := &_VariantDateTime{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantDateTimeBuilder is a builder for VariantDateTime
type VariantDateTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []int64) VariantDateTimeBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantDateTimeBuilder
	// WithValue adds Value (property field)
	WithValue(...int64) VariantDateTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantDateTime or returns an error if something is wrong
	Build() (VariantDateTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantDateTime
}

// NewVariantDateTimeBuilder() creates a VariantDateTimeBuilder
func NewVariantDateTimeBuilder() VariantDateTimeBuilder {
	return &_VariantDateTimeBuilder{_VariantDateTime: new(_VariantDateTime)}
}

type _VariantDateTimeBuilder struct {
	*_VariantDateTime

	parentBuilder *_VariantBuilder

	collectedErr []error
}

var _ (VariantDateTimeBuilder) = (*_VariantDateTimeBuilder)(nil)

func (b *_VariantDateTimeBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantDateTime
}

func (b *_VariantDateTimeBuilder) WithMandatoryFields(value []int64) VariantDateTimeBuilder {
	return b.WithValue(value...)
}

func (b *_VariantDateTimeBuilder) WithOptionalArrayLength(arrayLength int32) VariantDateTimeBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantDateTimeBuilder) WithValue(value ...int64) VariantDateTimeBuilder {
	b.Value = value
	return b
}

func (b *_VariantDateTimeBuilder) Build() (VariantDateTime, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VariantDateTime.deepCopy(), nil
}

func (b *_VariantDateTimeBuilder) MustBuild() VariantDateTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantDateTimeBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantDateTimeBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantDateTimeBuilder) DeepCopy() any {
	_copy := b.CreateVariantDateTimeBuilder().(*_VariantDateTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVariantDateTimeBuilder creates a VariantDateTimeBuilder
func (b *_VariantDateTime) CreateVariantDateTimeBuilder() VariantDateTimeBuilder {
	if b == nil {
		return NewVariantDateTimeBuilder()
	}
	return &_VariantDateTimeBuilder{_VariantDateTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantDateTime) GetVariantType() uint8 {
	return uint8(13)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantDateTime) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantDateTime) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantDateTime) GetValue() []int64 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantDateTime(structType any) VariantDateTime {
	if casted, ok := structType.(VariantDateTime); ok {
		return casted
	}
	if casted, ok := structType.(*VariantDateTime); ok {
		return *casted
	}
	return nil
}

func (m *_VariantDateTime) GetTypeName() string {
	return "VariantDateTime"
}

func (m *_VariantDateTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		lengthInBits += 64 * uint16(len(m.Value))
	}

	return lengthInBits
}

func (m *_VariantDateTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantDateTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantDateTime VariantDateTime, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantDateTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantDateTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[int64](ctx, "value", ReadSignedLong(readBuffer, uint8(64)), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantDateTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantDateTime")
	}

	return m, nil
}

func (m *_VariantDateTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantDateTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantDateTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantDateTime")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "value", m.GetValue(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantDateTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantDateTime")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantDateTime) IsVariantDateTime() {}

func (m *_VariantDateTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantDateTime) deepCopy() *_VariantDateTime {
	if m == nil {
		return nil
	}
	_VariantDateTimeCopy := &_VariantDateTime{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[int64, int64](m.Value),
	}
	_VariantDateTimeCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantDateTimeCopy
}

func (m *_VariantDateTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
