/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAction is an enum
type OpcuaNodeIdServicesVariableAction int32

type IOpcuaNodeIdServicesVariableAction interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAction_ActionState_EnumStrings OpcuaNodeIdServicesVariableAction = 18596
)

var OpcuaNodeIdServicesVariableActionValues []OpcuaNodeIdServicesVariableAction

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableActionValues = []OpcuaNodeIdServicesVariableAction{
		OpcuaNodeIdServicesVariableAction_ActionState_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableActionByValue(value int32) (enum OpcuaNodeIdServicesVariableAction, ok bool) {
	switch value {
	case 18596:
		return OpcuaNodeIdServicesVariableAction_ActionState_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableActionByName(value string) (enum OpcuaNodeIdServicesVariableAction, ok bool) {
	switch value {
	case "ActionState_EnumStrings":
		return OpcuaNodeIdServicesVariableAction_ActionState_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableActionKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableActionValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAction(structType any) OpcuaNodeIdServicesVariableAction {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAction {
		if sOpcuaNodeIdServicesVariableAction, ok := typ.(OpcuaNodeIdServicesVariableAction); ok {
			return sOpcuaNodeIdServicesVariableAction
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAction) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAction) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableActionParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAction, error) {
	return OpcuaNodeIdServicesVariableActionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableActionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAction, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAction", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAction")
	}
	if enum, ok := OpcuaNodeIdServicesVariableActionByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAction")
		return OpcuaNodeIdServicesVariableAction(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAction) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAction) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAction", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableAction) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAction) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAction_ActionState_EnumStrings:
		return "ActionState_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAction) String() string {
	return e.PLC4XEnumName()
}
