/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonActionRequestMessage is the corresponding interface of JsonActionRequestMessage
type JsonActionRequestMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetActionTargetId returns ActionTargetId (property field)
	GetActionTargetId() uint16
	// GetDataSetWriterName returns DataSetWriterName (property field)
	GetDataSetWriterName() PascalString
	// GetWriterGroupName returns WriterGroupName (property field)
	GetWriterGroupName() PascalString
	// GetMetaDataVersion returns MetaDataVersion (property field)
	GetMetaDataVersion() ConfigurationVersionDataType
	// GetMinorVersion returns MinorVersion (property field)
	GetMinorVersion() uint32
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetRequestId returns RequestId (property field)
	GetRequestId() uint16
	// GetActionState returns ActionState (property field)
	GetActionState() ActionState
	// GetPayload returns Payload (property field)
	GetPayload() ExtensionObject
	// IsJsonActionRequestMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonActionRequestMessage()
	// CreateBuilder creates a JsonActionRequestMessageBuilder
	CreateJsonActionRequestMessageBuilder() JsonActionRequestMessageBuilder
}

// _JsonActionRequestMessage is the data-structure of this message
type _JsonActionRequestMessage struct {
	ExtensionObjectDefinitionContract
	DataSetWriterId   uint16
	ActionTargetId    uint16
	DataSetWriterName PascalString
	WriterGroupName   PascalString
	MetaDataVersion   ConfigurationVersionDataType
	MinorVersion      uint32
	Timestamp         int64
	MessageType       PascalString
	RequestId         uint16
	ActionState       ActionState
	Payload           ExtensionObject
}

var _ JsonActionRequestMessage = (*_JsonActionRequestMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonActionRequestMessage)(nil)

// NewJsonActionRequestMessage factory function for _JsonActionRequestMessage
func NewJsonActionRequestMessage(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) *_JsonActionRequestMessage {
	if dataSetWriterName == nil {
		panic("dataSetWriterName of type PascalString for JsonActionRequestMessage must not be nil")
	}
	if writerGroupName == nil {
		panic("writerGroupName of type PascalString for JsonActionRequestMessage must not be nil")
	}
	if metaDataVersion == nil {
		panic("metaDataVersion of type ConfigurationVersionDataType for JsonActionRequestMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonActionRequestMessage must not be nil")
	}
	if payload == nil {
		panic("payload of type ExtensionObject for JsonActionRequestMessage must not be nil")
	}
	_result := &_JsonActionRequestMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetWriterId:                   dataSetWriterId,
		ActionTargetId:                    actionTargetId,
		DataSetWriterName:                 dataSetWriterName,
		WriterGroupName:                   writerGroupName,
		MetaDataVersion:                   metaDataVersion,
		MinorVersion:                      minorVersion,
		Timestamp:                         timestamp,
		MessageType:                       messageType,
		RequestId:                         requestId,
		ActionState:                       actionState,
		Payload:                           payload,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonActionRequestMessageBuilder is a builder for JsonActionRequestMessage
type JsonActionRequestMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) JsonActionRequestMessageBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) JsonActionRequestMessageBuilder
	// WithActionTargetId adds ActionTargetId (property field)
	WithActionTargetId(uint16) JsonActionRequestMessageBuilder
	// WithDataSetWriterName adds DataSetWriterName (property field)
	WithDataSetWriterName(PascalString) JsonActionRequestMessageBuilder
	// WithDataSetWriterNameBuilder adds DataSetWriterName (property field) which is build by the builder
	WithDataSetWriterNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder
	// WithWriterGroupName adds WriterGroupName (property field)
	WithWriterGroupName(PascalString) JsonActionRequestMessageBuilder
	// WithWriterGroupNameBuilder adds WriterGroupName (property field) which is build by the builder
	WithWriterGroupNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder
	// WithMetaDataVersion adds MetaDataVersion (property field)
	WithMetaDataVersion(ConfigurationVersionDataType) JsonActionRequestMessageBuilder
	// WithMetaDataVersionBuilder adds MetaDataVersion (property field) which is build by the builder
	WithMetaDataVersionBuilder(func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonActionRequestMessageBuilder
	// WithMinorVersion adds MinorVersion (property field)
	WithMinorVersion(uint32) JsonActionRequestMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonActionRequestMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonActionRequestMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder
	// WithRequestId adds RequestId (property field)
	WithRequestId(uint16) JsonActionRequestMessageBuilder
	// WithActionState adds ActionState (property field)
	WithActionState(ActionState) JsonActionRequestMessageBuilder
	// WithPayload adds Payload (property field)
	WithPayload(ExtensionObject) JsonActionRequestMessageBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonActionRequestMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonActionRequestMessage or returns an error if something is wrong
	Build() (JsonActionRequestMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonActionRequestMessage
}

// NewJsonActionRequestMessageBuilder() creates a JsonActionRequestMessageBuilder
func NewJsonActionRequestMessageBuilder() JsonActionRequestMessageBuilder {
	return &_JsonActionRequestMessageBuilder{_JsonActionRequestMessage: new(_JsonActionRequestMessage)}
}

type _JsonActionRequestMessageBuilder struct {
	*_JsonActionRequestMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonActionRequestMessageBuilder) = (*_JsonActionRequestMessageBuilder)(nil)

func (b *_JsonActionRequestMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonActionRequestMessage
}

func (b *_JsonActionRequestMessageBuilder) WithMandatoryFields(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) JsonActionRequestMessageBuilder {
	return b.WithDataSetWriterId(dataSetWriterId).WithActionTargetId(actionTargetId).WithDataSetWriterName(dataSetWriterName).WithWriterGroupName(writerGroupName).WithMetaDataVersion(metaDataVersion).WithMinorVersion(minorVersion).WithTimestamp(timestamp).WithMessageType(messageType).WithRequestId(requestId).WithActionState(actionState).WithPayload(payload)
}

func (b *_JsonActionRequestMessageBuilder) WithDataSetWriterId(dataSetWriterId uint16) JsonActionRequestMessageBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithActionTargetId(actionTargetId uint16) JsonActionRequestMessageBuilder {
	b.ActionTargetId = actionTargetId
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithDataSetWriterName(dataSetWriterName PascalString) JsonActionRequestMessageBuilder {
	b.DataSetWriterName = dataSetWriterName
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithDataSetWriterNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder {
	builder := builderSupplier(b.DataSetWriterName.CreatePascalStringBuilder())
	var err error
	b.DataSetWriterName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithWriterGroupName(writerGroupName PascalString) JsonActionRequestMessageBuilder {
	b.WriterGroupName = writerGroupName
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithWriterGroupNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder {
	builder := builderSupplier(b.WriterGroupName.CreatePascalStringBuilder())
	var err error
	b.WriterGroupName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithMetaDataVersion(metaDataVersion ConfigurationVersionDataType) JsonActionRequestMessageBuilder {
	b.MetaDataVersion = metaDataVersion
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithMetaDataVersionBuilder(builderSupplier func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonActionRequestMessageBuilder {
	builder := builderSupplier(b.MetaDataVersion.CreateConfigurationVersionDataTypeBuilder())
	var err error
	b.MetaDataVersion, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ConfigurationVersionDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithMinorVersion(minorVersion uint32) JsonActionRequestMessageBuilder {
	b.MinorVersion = minorVersion
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithTimestamp(timestamp int64) JsonActionRequestMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithMessageType(messageType PascalString) JsonActionRequestMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionRequestMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithRequestId(requestId uint16) JsonActionRequestMessageBuilder {
	b.RequestId = requestId
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithActionState(actionState ActionState) JsonActionRequestMessageBuilder {
	b.ActionState = actionState
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithPayload(payload ExtensionObject) JsonActionRequestMessageBuilder {
	b.Payload = payload
	return b
}

func (b *_JsonActionRequestMessageBuilder) WithPayloadBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonActionRequestMessageBuilder {
	builder := builderSupplier(b.Payload.CreateExtensionObjectBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_JsonActionRequestMessageBuilder) Build() (JsonActionRequestMessage, error) {
	if b.DataSetWriterName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataSetWriterName' not set"))
	}
	if b.WriterGroupName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'writerGroupName' not set"))
	}
	if b.MetaDataVersion == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'metaDataVersion' not set"))
	}
	if b.MessageType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageType' not set"))
	}
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonActionRequestMessage.deepCopy(), nil
}

func (b *_JsonActionRequestMessageBuilder) MustBuild() JsonActionRequestMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonActionRequestMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonActionRequestMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonActionRequestMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonActionRequestMessageBuilder().(*_JsonActionRequestMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonActionRequestMessageBuilder creates a JsonActionRequestMessageBuilder
func (b *_JsonActionRequestMessage) CreateJsonActionRequestMessageBuilder() JsonActionRequestMessageBuilder {
	if b == nil {
		return NewJsonActionRequestMessageBuilder()
	}
	return &_JsonActionRequestMessageBuilder{_JsonActionRequestMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonActionRequestMessage) GetExtensionId() int32 {
	return int32(19323)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonActionRequestMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonActionRequestMessage) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_JsonActionRequestMessage) GetActionTargetId() uint16 {
	return m.ActionTargetId
}

func (m *_JsonActionRequestMessage) GetDataSetWriterName() PascalString {
	return m.DataSetWriterName
}

func (m *_JsonActionRequestMessage) GetWriterGroupName() PascalString {
	return m.WriterGroupName
}

func (m *_JsonActionRequestMessage) GetMetaDataVersion() ConfigurationVersionDataType {
	return m.MetaDataVersion
}

func (m *_JsonActionRequestMessage) GetMinorVersion() uint32 {
	return m.MinorVersion
}

func (m *_JsonActionRequestMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonActionRequestMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonActionRequestMessage) GetRequestId() uint16 {
	return m.RequestId
}

func (m *_JsonActionRequestMessage) GetActionState() ActionState {
	return m.ActionState
}

func (m *_JsonActionRequestMessage) GetPayload() ExtensionObject {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonActionRequestMessage(structType any) JsonActionRequestMessage {
	if casted, ok := structType.(JsonActionRequestMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonActionRequestMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonActionRequestMessage) GetTypeName() string {
	return "JsonActionRequestMessage"
}

func (m *_JsonActionRequestMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (actionTargetId)
	lengthInBits += 16

	// Simple field (dataSetWriterName)
	lengthInBits += m.DataSetWriterName.GetLengthInBits(ctx)

	// Simple field (writerGroupName)
	lengthInBits += m.WriterGroupName.GetLengthInBits(ctx)

	// Simple field (metaDataVersion)
	lengthInBits += m.MetaDataVersion.GetLengthInBits(ctx)

	// Simple field (minorVersion)
	lengthInBits += 32

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (requestId)
	lengthInBits += 16

	// Simple field (actionState)
	lengthInBits += 32

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_JsonActionRequestMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonActionRequestMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonActionRequestMessage JsonActionRequestMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonActionRequestMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonActionRequestMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	actionTargetId, err := ReadSimpleField(ctx, "actionTargetId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargetId' field"))
	}
	m.ActionTargetId = actionTargetId

	dataSetWriterName, err := ReadSimpleField[PascalString](ctx, "dataSetWriterName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterName' field"))
	}
	m.DataSetWriterName = dataSetWriterName

	writerGroupName, err := ReadSimpleField[PascalString](ctx, "writerGroupName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupName' field"))
	}
	m.WriterGroupName = writerGroupName

	metaDataVersion, err := ReadSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", ReadComplex[ConfigurationVersionDataType](ExtensionObjectDefinitionParseWithBufferProducer[ConfigurationVersionDataType]((int32)(int32(14595))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'metaDataVersion' field"))
	}
	m.MetaDataVersion = metaDataVersion

	minorVersion, err := ReadSimpleField(ctx, "minorVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minorVersion' field"))
	}
	m.MinorVersion = minorVersion

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	requestId, err := ReadSimpleField(ctx, "requestId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestId' field"))
	}
	m.RequestId = requestId

	actionState, err := ReadEnumField[ActionState](ctx, "actionState", "ActionState", ReadEnum(ActionStateByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionState' field"))
	}
	m.ActionState = actionState

	payload, err := ReadSimpleField[ExtensionObject](ctx, "payload", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	if closeErr := readBuffer.CloseContext("JsonActionRequestMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonActionRequestMessage")
	}

	return m, nil
}

func (m *_JsonActionRequestMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonActionRequestMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonActionRequestMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonActionRequestMessage")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "actionTargetId", m.GetActionTargetId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargetId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetWriterName", m.GetDataSetWriterName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "writerGroupName", m.GetWriterGroupName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupName' field")
		}

		if err := WriteSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", m.GetMetaDataVersion(), WriteComplex[ConfigurationVersionDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'metaDataVersion' field")
		}

		if err := WriteSimpleField[uint32](ctx, "minorVersion", m.GetMinorVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'minorVersion' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[uint16](ctx, "requestId", m.GetRequestId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestId' field")
		}

		if err := WriteSimpleEnumField[ActionState](ctx, "actionState", "ActionState", m.GetActionState(), WriteEnum[ActionState, uint32](ActionState.GetValue, ActionState.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'actionState' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "payload", m.GetPayload(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("JsonActionRequestMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonActionRequestMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonActionRequestMessage) IsJsonActionRequestMessage() {}

func (m *_JsonActionRequestMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonActionRequestMessage) deepCopy() *_JsonActionRequestMessage {
	if m == nil {
		return nil
	}
	_JsonActionRequestMessageCopy := &_JsonActionRequestMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.DataSetWriterId,
		m.ActionTargetId,
		utils.DeepCopy[PascalString](m.DataSetWriterName),
		utils.DeepCopy[PascalString](m.WriterGroupName),
		utils.DeepCopy[ConfigurationVersionDataType](m.MetaDataVersion),
		m.MinorVersion,
		m.Timestamp,
		utils.DeepCopy[PascalString](m.MessageType),
		m.RequestId,
		m.ActionState,
		utils.DeepCopy[ExtensionObject](m.Payload),
	}
	_JsonActionRequestMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonActionRequestMessageCopy
}

func (m *_JsonActionRequestMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
