/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CreateSubscriptionResponse is the corresponding interface of CreateSubscriptionResponse
type CreateSubscriptionResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ResponseHeader
	// GetSubscriptionId returns SubscriptionId (property field)
	GetSubscriptionId() uint32
	// GetRevisedPublishingInterval returns RevisedPublishingInterval (property field)
	GetRevisedPublishingInterval() float64
	// GetRevisedLifetimeCount returns RevisedLifetimeCount (property field)
	GetRevisedLifetimeCount() uint32
	// GetRevisedMaxKeepAliveCount returns RevisedMaxKeepAliveCount (property field)
	GetRevisedMaxKeepAliveCount() uint32
	// IsCreateSubscriptionResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCreateSubscriptionResponse()
	// CreateBuilder creates a CreateSubscriptionResponseBuilder
	CreateCreateSubscriptionResponseBuilder() CreateSubscriptionResponseBuilder
}

// _CreateSubscriptionResponse is the data-structure of this message
type _CreateSubscriptionResponse struct {
	ExtensionObjectDefinitionContract
	ResponseHeader            ResponseHeader
	SubscriptionId            uint32
	RevisedPublishingInterval float64
	RevisedLifetimeCount      uint32
	RevisedMaxKeepAliveCount  uint32
}

var _ CreateSubscriptionResponse = (*_CreateSubscriptionResponse)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_CreateSubscriptionResponse)(nil)

// NewCreateSubscriptionResponse factory function for _CreateSubscriptionResponse
func NewCreateSubscriptionResponse(responseHeader ResponseHeader, subscriptionId uint32, revisedPublishingInterval float64, revisedLifetimeCount uint32, revisedMaxKeepAliveCount uint32) *_CreateSubscriptionResponse {
	if responseHeader == nil {
		panic("responseHeader of type ResponseHeader for CreateSubscriptionResponse must not be nil")
	}
	_result := &_CreateSubscriptionResponse{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ResponseHeader:                    responseHeader,
		SubscriptionId:                    subscriptionId,
		RevisedPublishingInterval:         revisedPublishingInterval,
		RevisedLifetimeCount:              revisedLifetimeCount,
		RevisedMaxKeepAliveCount:          revisedMaxKeepAliveCount,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CreateSubscriptionResponseBuilder is a builder for CreateSubscriptionResponse
type CreateSubscriptionResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(responseHeader ResponseHeader, subscriptionId uint32, revisedPublishingInterval float64, revisedLifetimeCount uint32, revisedMaxKeepAliveCount uint32) CreateSubscriptionResponseBuilder
	// WithResponseHeader adds ResponseHeader (property field)
	WithResponseHeader(ResponseHeader) CreateSubscriptionResponseBuilder
	// WithResponseHeaderBuilder adds ResponseHeader (property field) which is build by the builder
	WithResponseHeaderBuilder(func(ResponseHeaderBuilder) ResponseHeaderBuilder) CreateSubscriptionResponseBuilder
	// WithSubscriptionId adds SubscriptionId (property field)
	WithSubscriptionId(uint32) CreateSubscriptionResponseBuilder
	// WithRevisedPublishingInterval adds RevisedPublishingInterval (property field)
	WithRevisedPublishingInterval(float64) CreateSubscriptionResponseBuilder
	// WithRevisedLifetimeCount adds RevisedLifetimeCount (property field)
	WithRevisedLifetimeCount(uint32) CreateSubscriptionResponseBuilder
	// WithRevisedMaxKeepAliveCount adds RevisedMaxKeepAliveCount (property field)
	WithRevisedMaxKeepAliveCount(uint32) CreateSubscriptionResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the CreateSubscriptionResponse or returns an error if something is wrong
	Build() (CreateSubscriptionResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CreateSubscriptionResponse
}

// NewCreateSubscriptionResponseBuilder() creates a CreateSubscriptionResponseBuilder
func NewCreateSubscriptionResponseBuilder() CreateSubscriptionResponseBuilder {
	return &_CreateSubscriptionResponseBuilder{_CreateSubscriptionResponse: new(_CreateSubscriptionResponse)}
}

type _CreateSubscriptionResponseBuilder struct {
	*_CreateSubscriptionResponse

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (CreateSubscriptionResponseBuilder) = (*_CreateSubscriptionResponseBuilder)(nil)

func (b *_CreateSubscriptionResponseBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._CreateSubscriptionResponse
}

func (b *_CreateSubscriptionResponseBuilder) WithMandatoryFields(responseHeader ResponseHeader, subscriptionId uint32, revisedPublishingInterval float64, revisedLifetimeCount uint32, revisedMaxKeepAliveCount uint32) CreateSubscriptionResponseBuilder {
	return b.WithResponseHeader(responseHeader).WithSubscriptionId(subscriptionId).WithRevisedPublishingInterval(revisedPublishingInterval).WithRevisedLifetimeCount(revisedLifetimeCount).WithRevisedMaxKeepAliveCount(revisedMaxKeepAliveCount)
}

func (b *_CreateSubscriptionResponseBuilder) WithResponseHeader(responseHeader ResponseHeader) CreateSubscriptionResponseBuilder {
	b.ResponseHeader = responseHeader
	return b
}

func (b *_CreateSubscriptionResponseBuilder) WithResponseHeaderBuilder(builderSupplier func(ResponseHeaderBuilder) ResponseHeaderBuilder) CreateSubscriptionResponseBuilder {
	builder := builderSupplier(b.ResponseHeader.CreateResponseHeaderBuilder())
	var err error
	b.ResponseHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ResponseHeaderBuilder failed"))
	}
	return b
}

func (b *_CreateSubscriptionResponseBuilder) WithSubscriptionId(subscriptionId uint32) CreateSubscriptionResponseBuilder {
	b.SubscriptionId = subscriptionId
	return b
}

func (b *_CreateSubscriptionResponseBuilder) WithRevisedPublishingInterval(revisedPublishingInterval float64) CreateSubscriptionResponseBuilder {
	b.RevisedPublishingInterval = revisedPublishingInterval
	return b
}

func (b *_CreateSubscriptionResponseBuilder) WithRevisedLifetimeCount(revisedLifetimeCount uint32) CreateSubscriptionResponseBuilder {
	b.RevisedLifetimeCount = revisedLifetimeCount
	return b
}

func (b *_CreateSubscriptionResponseBuilder) WithRevisedMaxKeepAliveCount(revisedMaxKeepAliveCount uint32) CreateSubscriptionResponseBuilder {
	b.RevisedMaxKeepAliveCount = revisedMaxKeepAliveCount
	return b
}

func (b *_CreateSubscriptionResponseBuilder) Build() (CreateSubscriptionResponse, error) {
	if b.ResponseHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'responseHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CreateSubscriptionResponse.deepCopy(), nil
}

func (b *_CreateSubscriptionResponseBuilder) MustBuild() CreateSubscriptionResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CreateSubscriptionResponseBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_CreateSubscriptionResponseBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_CreateSubscriptionResponseBuilder) DeepCopy() any {
	_copy := b.CreateCreateSubscriptionResponseBuilder().(*_CreateSubscriptionResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCreateSubscriptionResponseBuilder creates a CreateSubscriptionResponseBuilder
func (b *_CreateSubscriptionResponse) CreateCreateSubscriptionResponseBuilder() CreateSubscriptionResponseBuilder {
	if b == nil {
		return NewCreateSubscriptionResponseBuilder()
	}
	return &_CreateSubscriptionResponseBuilder{_CreateSubscriptionResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CreateSubscriptionResponse) GetExtensionId() int32 {
	return int32(790)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CreateSubscriptionResponse) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CreateSubscriptionResponse) GetResponseHeader() ResponseHeader {
	return m.ResponseHeader
}

func (m *_CreateSubscriptionResponse) GetSubscriptionId() uint32 {
	return m.SubscriptionId
}

func (m *_CreateSubscriptionResponse) GetRevisedPublishingInterval() float64 {
	return m.RevisedPublishingInterval
}

func (m *_CreateSubscriptionResponse) GetRevisedLifetimeCount() uint32 {
	return m.RevisedLifetimeCount
}

func (m *_CreateSubscriptionResponse) GetRevisedMaxKeepAliveCount() uint32 {
	return m.RevisedMaxKeepAliveCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCreateSubscriptionResponse(structType any) CreateSubscriptionResponse {
	if casted, ok := structType.(CreateSubscriptionResponse); ok {
		return casted
	}
	if casted, ok := structType.(*CreateSubscriptionResponse); ok {
		return *casted
	}
	return nil
}

func (m *_CreateSubscriptionResponse) GetTypeName() string {
	return "CreateSubscriptionResponse"
}

func (m *_CreateSubscriptionResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	// Simple field (subscriptionId)
	lengthInBits += 32

	// Simple field (revisedPublishingInterval)
	lengthInBits += 64

	// Simple field (revisedLifetimeCount)
	lengthInBits += 32

	// Simple field (revisedMaxKeepAliveCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_CreateSubscriptionResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CreateSubscriptionResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__createSubscriptionResponse CreateSubscriptionResponse, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CreateSubscriptionResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CreateSubscriptionResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	responseHeader, err := ReadSimpleField[ResponseHeader](ctx, "responseHeader", ReadComplex[ResponseHeader](ExtensionObjectDefinitionParseWithBufferProducer[ResponseHeader]((int32)(int32(394))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'responseHeader' field"))
	}
	m.ResponseHeader = responseHeader

	subscriptionId, err := ReadSimpleField(ctx, "subscriptionId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subscriptionId' field"))
	}
	m.SubscriptionId = subscriptionId

	revisedPublishingInterval, err := ReadSimpleField(ctx, "revisedPublishingInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'revisedPublishingInterval' field"))
	}
	m.RevisedPublishingInterval = revisedPublishingInterval

	revisedLifetimeCount, err := ReadSimpleField(ctx, "revisedLifetimeCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'revisedLifetimeCount' field"))
	}
	m.RevisedLifetimeCount = revisedLifetimeCount

	revisedMaxKeepAliveCount, err := ReadSimpleField(ctx, "revisedMaxKeepAliveCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'revisedMaxKeepAliveCount' field"))
	}
	m.RevisedMaxKeepAliveCount = revisedMaxKeepAliveCount

	if closeErr := readBuffer.CloseContext("CreateSubscriptionResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CreateSubscriptionResponse")
	}

	return m, nil
}

func (m *_CreateSubscriptionResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CreateSubscriptionResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CreateSubscriptionResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CreateSubscriptionResponse")
		}

		if err := WriteSimpleField[ResponseHeader](ctx, "responseHeader", m.GetResponseHeader(), WriteComplex[ResponseHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'responseHeader' field")
		}

		if err := WriteSimpleField[uint32](ctx, "subscriptionId", m.GetSubscriptionId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'subscriptionId' field")
		}

		if err := WriteSimpleField[float64](ctx, "revisedPublishingInterval", m.GetRevisedPublishingInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'revisedPublishingInterval' field")
		}

		if err := WriteSimpleField[uint32](ctx, "revisedLifetimeCount", m.GetRevisedLifetimeCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'revisedLifetimeCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "revisedMaxKeepAliveCount", m.GetRevisedMaxKeepAliveCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'revisedMaxKeepAliveCount' field")
		}

		if popErr := writeBuffer.PopContext("CreateSubscriptionResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CreateSubscriptionResponse")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CreateSubscriptionResponse) IsCreateSubscriptionResponse() {}

func (m *_CreateSubscriptionResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CreateSubscriptionResponse) deepCopy() *_CreateSubscriptionResponse {
	if m == nil {
		return nil
	}
	_CreateSubscriptionResponseCopy := &_CreateSubscriptionResponse{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[ResponseHeader](m.ResponseHeader),
		m.SubscriptionId,
		m.RevisedPublishingInterval,
		m.RevisedLifetimeCount,
		m.RevisedMaxKeepAliveCount,
	}
	_CreateSubscriptionResponseCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _CreateSubscriptionResponseCopy
}

func (m *_CreateSubscriptionResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
