/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AddReferencesRequest is the corresponding interface of AddReferencesRequest
type AddReferencesRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() RequestHeader
	// GetReferencesToAdd returns ReferencesToAdd (property field)
	GetReferencesToAdd() []AddReferencesItem
	// IsAddReferencesRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAddReferencesRequest()
	// CreateBuilder creates a AddReferencesRequestBuilder
	CreateAddReferencesRequestBuilder() AddReferencesRequestBuilder
}

// _AddReferencesRequest is the data-structure of this message
type _AddReferencesRequest struct {
	ExtensionObjectDefinitionContract
	RequestHeader   RequestHeader
	ReferencesToAdd []AddReferencesItem
}

var _ AddReferencesRequest = (*_AddReferencesRequest)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_AddReferencesRequest)(nil)

// NewAddReferencesRequest factory function for _AddReferencesRequest
func NewAddReferencesRequest(requestHeader RequestHeader, referencesToAdd []AddReferencesItem) *_AddReferencesRequest {
	if requestHeader == nil {
		panic("requestHeader of type RequestHeader for AddReferencesRequest must not be nil")
	}
	_result := &_AddReferencesRequest{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RequestHeader:                     requestHeader,
		ReferencesToAdd:                   referencesToAdd,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AddReferencesRequestBuilder is a builder for AddReferencesRequest
type AddReferencesRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestHeader RequestHeader, referencesToAdd []AddReferencesItem) AddReferencesRequestBuilder
	// WithRequestHeader adds RequestHeader (property field)
	WithRequestHeader(RequestHeader) AddReferencesRequestBuilder
	// WithRequestHeaderBuilder adds RequestHeader (property field) which is build by the builder
	WithRequestHeaderBuilder(func(RequestHeaderBuilder) RequestHeaderBuilder) AddReferencesRequestBuilder
	// WithReferencesToAdd adds ReferencesToAdd (property field)
	WithReferencesToAdd(...AddReferencesItem) AddReferencesRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the AddReferencesRequest or returns an error if something is wrong
	Build() (AddReferencesRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AddReferencesRequest
}

// NewAddReferencesRequestBuilder() creates a AddReferencesRequestBuilder
func NewAddReferencesRequestBuilder() AddReferencesRequestBuilder {
	return &_AddReferencesRequestBuilder{_AddReferencesRequest: new(_AddReferencesRequest)}
}

type _AddReferencesRequestBuilder struct {
	*_AddReferencesRequest

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (AddReferencesRequestBuilder) = (*_AddReferencesRequestBuilder)(nil)

func (b *_AddReferencesRequestBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._AddReferencesRequest
}

func (b *_AddReferencesRequestBuilder) WithMandatoryFields(requestHeader RequestHeader, referencesToAdd []AddReferencesItem) AddReferencesRequestBuilder {
	return b.WithRequestHeader(requestHeader).WithReferencesToAdd(referencesToAdd...)
}

func (b *_AddReferencesRequestBuilder) WithRequestHeader(requestHeader RequestHeader) AddReferencesRequestBuilder {
	b.RequestHeader = requestHeader
	return b
}

func (b *_AddReferencesRequestBuilder) WithRequestHeaderBuilder(builderSupplier func(RequestHeaderBuilder) RequestHeaderBuilder) AddReferencesRequestBuilder {
	builder := builderSupplier(b.RequestHeader.CreateRequestHeaderBuilder())
	var err error
	b.RequestHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "RequestHeaderBuilder failed"))
	}
	return b
}

func (b *_AddReferencesRequestBuilder) WithReferencesToAdd(referencesToAdd ...AddReferencesItem) AddReferencesRequestBuilder {
	b.ReferencesToAdd = referencesToAdd
	return b
}

func (b *_AddReferencesRequestBuilder) Build() (AddReferencesRequest, error) {
	if b.RequestHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AddReferencesRequest.deepCopy(), nil
}

func (b *_AddReferencesRequestBuilder) MustBuild() AddReferencesRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AddReferencesRequestBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_AddReferencesRequestBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_AddReferencesRequestBuilder) DeepCopy() any {
	_copy := b.CreateAddReferencesRequestBuilder().(*_AddReferencesRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAddReferencesRequestBuilder creates a AddReferencesRequestBuilder
func (b *_AddReferencesRequest) CreateAddReferencesRequestBuilder() AddReferencesRequestBuilder {
	if b == nil {
		return NewAddReferencesRequestBuilder()
	}
	return &_AddReferencesRequestBuilder{_AddReferencesRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AddReferencesRequest) GetExtensionId() int32 {
	return int32(494)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AddReferencesRequest) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AddReferencesRequest) GetRequestHeader() RequestHeader {
	return m.RequestHeader
}

func (m *_AddReferencesRequest) GetReferencesToAdd() []AddReferencesItem {
	return m.ReferencesToAdd
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAddReferencesRequest(structType any) AddReferencesRequest {
	if casted, ok := structType.(AddReferencesRequest); ok {
		return casted
	}
	if casted, ok := structType.(*AddReferencesRequest); ok {
		return *casted
	}
	return nil
}

func (m *_AddReferencesRequest) GetTypeName() string {
	return "AddReferencesRequest"
}

func (m *_AddReferencesRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Implicit Field (noOfReferencesToAdd)
	lengthInBits += 32

	// Array field
	if len(m.ReferencesToAdd) > 0 {
		for _curItem, element := range m.ReferencesToAdd {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ReferencesToAdd), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_AddReferencesRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AddReferencesRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__addReferencesRequest AddReferencesRequest, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AddReferencesRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AddReferencesRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestHeader, err := ReadSimpleField[RequestHeader](ctx, "requestHeader", ReadComplex[RequestHeader](ExtensionObjectDefinitionParseWithBufferProducer[RequestHeader]((int32)(int32(391))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestHeader' field"))
	}
	m.RequestHeader = requestHeader

	noOfReferencesToAdd, err := ReadImplicitField[int32](ctx, "noOfReferencesToAdd", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfReferencesToAdd' field"))
	}
	_ = noOfReferencesToAdd

	referencesToAdd, err := ReadCountArrayField[AddReferencesItem](ctx, "referencesToAdd", ReadComplex[AddReferencesItem](ExtensionObjectDefinitionParseWithBufferProducer[AddReferencesItem]((int32)(int32(381))), readBuffer), uint64(noOfReferencesToAdd))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'referencesToAdd' field"))
	}
	m.ReferencesToAdd = referencesToAdd

	if closeErr := readBuffer.CloseContext("AddReferencesRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AddReferencesRequest")
	}

	return m, nil
}

func (m *_AddReferencesRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AddReferencesRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AddReferencesRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AddReferencesRequest")
		}

		if err := WriteSimpleField[RequestHeader](ctx, "requestHeader", m.GetRequestHeader(), WriteComplex[RequestHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestHeader' field")
		}
		noOfReferencesToAdd := int32(utils.InlineIf(bool((m.GetReferencesToAdd()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetReferencesToAdd()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfReferencesToAdd", noOfReferencesToAdd, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfReferencesToAdd' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "referencesToAdd", m.GetReferencesToAdd(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'referencesToAdd' field")
		}

		if popErr := writeBuffer.PopContext("AddReferencesRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AddReferencesRequest")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AddReferencesRequest) IsAddReferencesRequest() {}

func (m *_AddReferencesRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AddReferencesRequest) deepCopy() *_AddReferencesRequest {
	if m == nil {
		return nil
	}
	_AddReferencesRequestCopy := &_AddReferencesRequest{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[RequestHeader](m.RequestHeader),
		utils.DeepCopySlice[AddReferencesItem, AddReferencesItem](m.ReferencesToAdd),
	}
	_AddReferencesRequestCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _AddReferencesRequestCopy
}

func (m *_AddReferencesRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
