/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtReadRouterStatusResponse is the corresponding interface of ApduDataExtReadRouterStatusResponse
type ApduDataExtReadRouterStatusResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtReadRouterStatusResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtReadRouterStatusResponse()
	// CreateBuilder creates a ApduDataExtReadRouterStatusResponseBuilder
	CreateApduDataExtReadRouterStatusResponseBuilder() ApduDataExtReadRouterStatusResponseBuilder
}

// _ApduDataExtReadRouterStatusResponse is the data-structure of this message
type _ApduDataExtReadRouterStatusResponse struct {
	ApduDataExtContract
}

var _ ApduDataExtReadRouterStatusResponse = (*_ApduDataExtReadRouterStatusResponse)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtReadRouterStatusResponse)(nil)

// NewApduDataExtReadRouterStatusResponse factory function for _ApduDataExtReadRouterStatusResponse
func NewApduDataExtReadRouterStatusResponse(length uint8) *_ApduDataExtReadRouterStatusResponse {
	_result := &_ApduDataExtReadRouterStatusResponse{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtReadRouterStatusResponseBuilder is a builder for ApduDataExtReadRouterStatusResponse
type ApduDataExtReadRouterStatusResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtReadRouterStatusResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtReadRouterStatusResponse or returns an error if something is wrong
	Build() (ApduDataExtReadRouterStatusResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtReadRouterStatusResponse
}

// NewApduDataExtReadRouterStatusResponseBuilder() creates a ApduDataExtReadRouterStatusResponseBuilder
func NewApduDataExtReadRouterStatusResponseBuilder() ApduDataExtReadRouterStatusResponseBuilder {
	return &_ApduDataExtReadRouterStatusResponseBuilder{_ApduDataExtReadRouterStatusResponse: new(_ApduDataExtReadRouterStatusResponse)}
}

type _ApduDataExtReadRouterStatusResponseBuilder struct {
	*_ApduDataExtReadRouterStatusResponse

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtReadRouterStatusResponseBuilder) = (*_ApduDataExtReadRouterStatusResponseBuilder)(nil)

func (b *_ApduDataExtReadRouterStatusResponseBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtReadRouterStatusResponse
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) WithMandatoryFields() ApduDataExtReadRouterStatusResponseBuilder {
	return b
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) Build() (ApduDataExtReadRouterStatusResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtReadRouterStatusResponse.deepCopy(), nil
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) MustBuild() ApduDataExtReadRouterStatusResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtReadRouterStatusResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtReadRouterStatusResponseBuilder().(*_ApduDataExtReadRouterStatusResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtReadRouterStatusResponseBuilder creates a ApduDataExtReadRouterStatusResponseBuilder
func (b *_ApduDataExtReadRouterStatusResponse) CreateApduDataExtReadRouterStatusResponseBuilder() ApduDataExtReadRouterStatusResponseBuilder {
	if b == nil {
		return NewApduDataExtReadRouterStatusResponseBuilder()
	}
	return &_ApduDataExtReadRouterStatusResponseBuilder{_ApduDataExtReadRouterStatusResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtReadRouterStatusResponse) GetExtApciType() uint8 {
	return 0x0E
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtReadRouterStatusResponse) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtReadRouterStatusResponse(structType any) ApduDataExtReadRouterStatusResponse {
	if casted, ok := structType.(ApduDataExtReadRouterStatusResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtReadRouterStatusResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtReadRouterStatusResponse) GetTypeName() string {
	return "ApduDataExtReadRouterStatusResponse"
}

func (m *_ApduDataExtReadRouterStatusResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtReadRouterStatusResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtReadRouterStatusResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtReadRouterStatusResponse ApduDataExtReadRouterStatusResponse, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtReadRouterStatusResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtReadRouterStatusResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtReadRouterStatusResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtReadRouterStatusResponse")
	}

	return m, nil
}

func (m *_ApduDataExtReadRouterStatusResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtReadRouterStatusResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtReadRouterStatusResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtReadRouterStatusResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtReadRouterStatusResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtReadRouterStatusResponse")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtReadRouterStatusResponse) IsApduDataExtReadRouterStatusResponse() {}

func (m *_ApduDataExtReadRouterStatusResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtReadRouterStatusResponse) deepCopy() *_ApduDataExtReadRouterStatusResponse {
	if m == nil {
		return nil
	}
	_ApduDataExtReadRouterStatusResponseCopy := &_ApduDataExtReadRouterStatusResponse{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtReadRouterStatusResponseCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtReadRouterStatusResponseCopy
}

func (m *_ApduDataExtReadRouterStatusResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
