/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PathSegment is the corresponding interface of PathSegment
type PathSegment interface {
	PathSegmentContract
	PathSegmentRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsPathSegment is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPathSegment()
	// CreateBuilder creates a PathSegmentBuilder
	CreatePathSegmentBuilder() PathSegmentBuilder
}

// PathSegmentContract provides a set of functions which can be overwritten by a sub struct
type PathSegmentContract interface {
	// IsPathSegment is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPathSegment()
	// CreateBuilder creates a PathSegmentBuilder
	CreatePathSegmentBuilder() PathSegmentBuilder
}

// PathSegmentRequirements provides a set of functions which need to be implemented by a sub struct
type PathSegmentRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPathSegment returns PathSegment (discriminator field)
	GetPathSegment() uint8
}

// _PathSegment is the data-structure of this message
type _PathSegment struct {
	_SubType interface {
		PathSegmentContract
		PathSegmentRequirements
	}
}

var _ PathSegmentContract = (*_PathSegment)(nil)

// NewPathSegment factory function for _PathSegment
func NewPathSegment() *_PathSegment {
	return &_PathSegment{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PathSegmentBuilder is a builder for PathSegment
type PathSegmentBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() PathSegmentBuilder
	// AsPortSegment converts this build to a subType of PathSegment. It is always possible to return to current builder using Done()
	AsPortSegment() PortSegmentBuilder
	// AsLogicalSegment converts this build to a subType of PathSegment. It is always possible to return to current builder using Done()
	AsLogicalSegment() LogicalSegmentBuilder
	// AsDataSegment converts this build to a subType of PathSegment. It is always possible to return to current builder using Done()
	AsDataSegment() DataSegmentBuilder
	// Build builds the PathSegment or returns an error if something is wrong
	PartialBuild() (PathSegmentContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() PathSegmentContract
	// Build builds the PathSegment or returns an error if something is wrong
	Build() (PathSegment, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PathSegment
}

// NewPathSegmentBuilder() creates a PathSegmentBuilder
func NewPathSegmentBuilder() PathSegmentBuilder {
	return &_PathSegmentBuilder{_PathSegment: new(_PathSegment)}
}

type _PathSegmentChildBuilder interface {
	utils.Copyable
	setParent(PathSegmentContract)
	buildForPathSegment() (PathSegment, error)
}

type _PathSegmentBuilder struct {
	*_PathSegment

	childBuilder _PathSegmentChildBuilder

	collectedErr []error
}

var _ (PathSegmentBuilder) = (*_PathSegmentBuilder)(nil)

func (b *_PathSegmentBuilder) WithMandatoryFields() PathSegmentBuilder {
	return b
}

func (b *_PathSegmentBuilder) PartialBuild() (PathSegmentContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._PathSegment.deepCopy(), nil
}

func (b *_PathSegmentBuilder) PartialMustBuild() PathSegmentContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PathSegmentBuilder) AsPortSegment() PortSegmentBuilder {
	if cb, ok := b.childBuilder.(PortSegmentBuilder); ok {
		return cb
	}
	cb := NewPortSegmentBuilder().(*_PortSegmentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_PathSegmentBuilder) AsLogicalSegment() LogicalSegmentBuilder {
	if cb, ok := b.childBuilder.(LogicalSegmentBuilder); ok {
		return cb
	}
	cb := NewLogicalSegmentBuilder().(*_LogicalSegmentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_PathSegmentBuilder) AsDataSegment() DataSegmentBuilder {
	if cb, ok := b.childBuilder.(DataSegmentBuilder); ok {
		return cb
	}
	cb := NewDataSegmentBuilder().(*_DataSegmentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_PathSegmentBuilder) Build() (PathSegment, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForPathSegment()
}

func (b *_PathSegmentBuilder) MustBuild() PathSegment {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PathSegmentBuilder) DeepCopy() any {
	_copy := b.CreatePathSegmentBuilder().(*_PathSegmentBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_PathSegmentChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreatePathSegmentBuilder creates a PathSegmentBuilder
func (b *_PathSegment) CreatePathSegmentBuilder() PathSegmentBuilder {
	if b == nil {
		return NewPathSegmentBuilder()
	}
	return &_PathSegmentBuilder{_PathSegment: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPathSegment(structType any) PathSegment {
	if casted, ok := structType.(PathSegment); ok {
		return casted
	}
	if casted, ok := structType.(*PathSegment); ok {
		return *casted
	}
	return nil
}

func (m *_PathSegment) GetTypeName() string {
	return "PathSegment"
}

func (m *_PathSegment) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (pathSegment)
	lengthInBits += 3

	return lengthInBits
}

func (m *_PathSegment) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_PathSegment) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func PathSegmentParse[T PathSegment](ctx context.Context, theBytes []byte) (T, error) {
	return PathSegmentParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func PathSegmentParseWithBufferProducer[T PathSegment]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := PathSegmentParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func PathSegmentParseWithBuffer[T PathSegment](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_PathSegment{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_PathSegment) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__pathSegment PathSegment, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PathSegment"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PathSegment")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	pathSegment, err := ReadDiscriminatorField[uint8](ctx, "pathSegment", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pathSegment' field"))
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child PathSegment
	switch {
	case pathSegment == 0x00: // PortSegment
		if _child, err = new(_PortSegment).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PortSegment for type-switch of PathSegment")
		}
	case pathSegment == 0x01: // LogicalSegment
		if _child, err = new(_LogicalSegment).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LogicalSegment for type-switch of PathSegment")
		}
	case pathSegment == 0x04: // DataSegment
		if _child, err = new(_DataSegment).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSegment for type-switch of PathSegment")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [pathSegment=%v]", pathSegment)
	}

	if closeErr := readBuffer.CloseContext("PathSegment"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PathSegment")
	}

	return _child, nil
}

func (pm *_PathSegment) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child PathSegment, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("PathSegment"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for PathSegment")
	}

	if err := WriteDiscriminatorField(ctx, "pathSegment", m.GetPathSegment(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
		return errors.Wrap(err, "Error serializing 'pathSegment' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("PathSegment"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for PathSegment")
	}
	return nil
}

func (m *_PathSegment) IsPathSegment() {}

func (m *_PathSegment) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PathSegment) deepCopy() *_PathSegment {
	if m == nil {
		return nil
	}
	_PathSegmentCopy := &_PathSegment{
		nil, // will be set by child
	}
	return _PathSegmentCopy
}
