/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataRoomControlSystem is the corresponding interface of SALDataRoomControlSystem
type SALDataRoomControlSystem interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// IsSALDataRoomControlSystem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataRoomControlSystem()
	// CreateBuilder creates a SALDataRoomControlSystemBuilder
	CreateSALDataRoomControlSystemBuilder() SALDataRoomControlSystemBuilder
}

// _SALDataRoomControlSystem is the data-structure of this message
type _SALDataRoomControlSystem struct {
	SALDataContract
}

var _ SALDataRoomControlSystem = (*_SALDataRoomControlSystem)(nil)
var _ SALDataRequirements = (*_SALDataRoomControlSystem)(nil)

// NewSALDataRoomControlSystem factory function for _SALDataRoomControlSystem
func NewSALDataRoomControlSystem(salData SALData) *_SALDataRoomControlSystem {
	_result := &_SALDataRoomControlSystem{
		SALDataContract: NewSALData(salData),
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataRoomControlSystemBuilder is a builder for SALDataRoomControlSystem
type SALDataRoomControlSystemBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SALDataRoomControlSystemBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataRoomControlSystem or returns an error if something is wrong
	Build() (SALDataRoomControlSystem, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataRoomControlSystem
}

// NewSALDataRoomControlSystemBuilder() creates a SALDataRoomControlSystemBuilder
func NewSALDataRoomControlSystemBuilder() SALDataRoomControlSystemBuilder {
	return &_SALDataRoomControlSystemBuilder{_SALDataRoomControlSystem: new(_SALDataRoomControlSystem)}
}

type _SALDataRoomControlSystemBuilder struct {
	*_SALDataRoomControlSystem

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataRoomControlSystemBuilder) = (*_SALDataRoomControlSystemBuilder)(nil)

func (b *_SALDataRoomControlSystemBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataRoomControlSystem
}

func (b *_SALDataRoomControlSystemBuilder) WithMandatoryFields() SALDataRoomControlSystemBuilder {
	return b
}

func (b *_SALDataRoomControlSystemBuilder) Build() (SALDataRoomControlSystem, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataRoomControlSystem.deepCopy(), nil
}

func (b *_SALDataRoomControlSystemBuilder) MustBuild() SALDataRoomControlSystem {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataRoomControlSystemBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataRoomControlSystemBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataRoomControlSystemBuilder) DeepCopy() any {
	_copy := b.CreateSALDataRoomControlSystemBuilder().(*_SALDataRoomControlSystemBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataRoomControlSystemBuilder creates a SALDataRoomControlSystemBuilder
func (b *_SALDataRoomControlSystem) CreateSALDataRoomControlSystemBuilder() SALDataRoomControlSystemBuilder {
	if b == nil {
		return NewSALDataRoomControlSystemBuilder()
	}
	return &_SALDataRoomControlSystemBuilder{_SALDataRoomControlSystem: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataRoomControlSystem) GetApplicationId() ApplicationId {
	return ApplicationId_ROOM_CONTROL_SYSTEM
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataRoomControlSystem) GetParent() SALDataContract {
	return m.SALDataContract
}

// Deprecated: use the interface for direct cast
func CastSALDataRoomControlSystem(structType any) SALDataRoomControlSystem {
	if casted, ok := structType.(SALDataRoomControlSystem); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataRoomControlSystem); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataRoomControlSystem) GetTypeName() string {
	return "SALDataRoomControlSystem"
}

func (m *_SALDataRoomControlSystem) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SALDataRoomControlSystem) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataRoomControlSystem) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataRoomControlSystem SALDataRoomControlSystem, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataRoomControlSystem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataRoomControlSystem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "ROOM_CONTROL_SYSTEM Not yet implemented"})
	}

	if closeErr := readBuffer.CloseContext("SALDataRoomControlSystem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataRoomControlSystem")
	}

	return m, nil
}

func (m *_SALDataRoomControlSystem) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataRoomControlSystem) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataRoomControlSystem"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataRoomControlSystem")
		}

		if popErr := writeBuffer.PopContext("SALDataRoomControlSystem"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataRoomControlSystem")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataRoomControlSystem) IsSALDataRoomControlSystem() {}

func (m *_SALDataRoomControlSystem) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataRoomControlSystem) deepCopy() *_SALDataRoomControlSystem {
	if m == nil {
		return nil
	}
	_SALDataRoomControlSystemCopy := &_SALDataRoomControlSystem{
		m.SALDataContract.(*_SALData).deepCopy(),
	}
	_SALDataRoomControlSystemCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataRoomControlSystemCopy
}

func (m *_SALDataRoomControlSystem) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
