/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPolarity is an enum
type BACnetPolarity uint8

type IBACnetPolarity interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	BACnetPolarity_NORMAL  BACnetPolarity = 0
	BACnetPolarity_REVERSE BACnetPolarity = 1
)

var BACnetPolarityValues []BACnetPolarity

func init() {
	_ = errors.New
	BACnetPolarityValues = []BACnetPolarity{
		BACnetPolarity_NORMAL,
		BACnetPolarity_REVERSE,
	}
}

func BACnetPolarityByValue(value uint8) (enum BACnetPolarity, ok bool) {
	switch value {
	case 0:
		return BACnetPolarity_NORMAL, true
	case 1:
		return BACnetPolarity_REVERSE, true
	}
	return 0, false
}

func BACnetPolarityByName(value string) (enum BACnetPolarity, ok bool) {
	switch value {
	case "NORMAL":
		return BACnetPolarity_NORMAL, true
	case "REVERSE":
		return BACnetPolarity_REVERSE, true
	}
	return 0, false
}

func BACnetPolarityKnows(value uint8) bool {
	for _, typeValue := range BACnetPolarityValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetPolarity(structType any) BACnetPolarity {
	castFunc := func(typ any) BACnetPolarity {
		if sBACnetPolarity, ok := typ.(BACnetPolarity); ok {
			return sBACnetPolarity
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetPolarity) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m BACnetPolarity) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetPolarityParse(ctx context.Context, theBytes []byte) (BACnetPolarity, error) {
	return BACnetPolarityParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetPolarityParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPolarity, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("BACnetPolarity", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetPolarity")
	}
	if enum, ok := BACnetPolarityByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetPolarity")
		return BACnetPolarity(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetPolarity) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetPolarity) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint8("BACnetPolarity", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e BACnetPolarity) GetValue() uint8 {
	return uint8(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetPolarity) PLC4XEnumName() string {
	switch e {
	case BACnetPolarity_NORMAL:
		return "NORMAL"
	case BACnetPolarity_REVERSE:
		return "REVERSE"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e BACnetPolarity) String() string {
	return e.PLC4XEnumName()
}
