/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataWindowInterval is the corresponding interface of BACnetConstructedDataWindowInterval
type BACnetConstructedDataWindowInterval interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetWindowInterval returns WindowInterval (property field)
	GetWindowInterval() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataWindowInterval is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataWindowInterval()
	// CreateBuilder creates a BACnetConstructedDataWindowIntervalBuilder
	CreateBACnetConstructedDataWindowIntervalBuilder() BACnetConstructedDataWindowIntervalBuilder
}

// _BACnetConstructedDataWindowInterval is the data-structure of this message
type _BACnetConstructedDataWindowInterval struct {
	BACnetConstructedDataContract
	WindowInterval BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataWindowInterval = (*_BACnetConstructedDataWindowInterval)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataWindowInterval)(nil)

// NewBACnetConstructedDataWindowInterval factory function for _BACnetConstructedDataWindowInterval
func NewBACnetConstructedDataWindowInterval(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, windowInterval BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataWindowInterval {
	if windowInterval == nil {
		panic("windowInterval of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataWindowInterval must not be nil")
	}
	_result := &_BACnetConstructedDataWindowInterval{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		WindowInterval:                windowInterval,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataWindowIntervalBuilder is a builder for BACnetConstructedDataWindowInterval
type BACnetConstructedDataWindowIntervalBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(windowInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataWindowIntervalBuilder
	// WithWindowInterval adds WindowInterval (property field)
	WithWindowInterval(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataWindowIntervalBuilder
	// WithWindowIntervalBuilder adds WindowInterval (property field) which is build by the builder
	WithWindowIntervalBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataWindowIntervalBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataWindowInterval or returns an error if something is wrong
	Build() (BACnetConstructedDataWindowInterval, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataWindowInterval
}

// NewBACnetConstructedDataWindowIntervalBuilder() creates a BACnetConstructedDataWindowIntervalBuilder
func NewBACnetConstructedDataWindowIntervalBuilder() BACnetConstructedDataWindowIntervalBuilder {
	return &_BACnetConstructedDataWindowIntervalBuilder{_BACnetConstructedDataWindowInterval: new(_BACnetConstructedDataWindowInterval)}
}

type _BACnetConstructedDataWindowIntervalBuilder struct {
	*_BACnetConstructedDataWindowInterval

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataWindowIntervalBuilder) = (*_BACnetConstructedDataWindowIntervalBuilder)(nil)

func (b *_BACnetConstructedDataWindowIntervalBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataWindowInterval
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) WithMandatoryFields(windowInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataWindowIntervalBuilder {
	return b.WithWindowInterval(windowInterval)
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) WithWindowInterval(windowInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataWindowIntervalBuilder {
	b.WindowInterval = windowInterval
	return b
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) WithWindowIntervalBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataWindowIntervalBuilder {
	builder := builderSupplier(b.WindowInterval.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.WindowInterval, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) Build() (BACnetConstructedDataWindowInterval, error) {
	if b.WindowInterval == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'windowInterval' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataWindowInterval.deepCopy(), nil
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) MustBuild() BACnetConstructedDataWindowInterval {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataWindowIntervalBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataWindowIntervalBuilder().(*_BACnetConstructedDataWindowIntervalBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataWindowIntervalBuilder creates a BACnetConstructedDataWindowIntervalBuilder
func (b *_BACnetConstructedDataWindowInterval) CreateBACnetConstructedDataWindowIntervalBuilder() BACnetConstructedDataWindowIntervalBuilder {
	if b == nil {
		return NewBACnetConstructedDataWindowIntervalBuilder()
	}
	return &_BACnetConstructedDataWindowIntervalBuilder{_BACnetConstructedDataWindowInterval: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataWindowInterval) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataWindowInterval) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_WINDOW_INTERVAL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataWindowInterval) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataWindowInterval) GetWindowInterval() BACnetApplicationTagUnsignedInteger {
	return m.WindowInterval
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataWindowInterval) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetWindowInterval())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataWindowInterval(structType any) BACnetConstructedDataWindowInterval {
	if casted, ok := structType.(BACnetConstructedDataWindowInterval); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataWindowInterval); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataWindowInterval) GetTypeName() string {
	return "BACnetConstructedDataWindowInterval"
}

func (m *_BACnetConstructedDataWindowInterval) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (windowInterval)
	lengthInBits += m.WindowInterval.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataWindowInterval) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataWindowInterval) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataWindowInterval BACnetConstructedDataWindowInterval, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataWindowInterval"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataWindowInterval")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	windowInterval, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "windowInterval", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'windowInterval' field"))
	}
	m.WindowInterval = windowInterval

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), windowInterval)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataWindowInterval"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataWindowInterval")
	}

	return m, nil
}

func (m *_BACnetConstructedDataWindowInterval) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataWindowInterval) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataWindowInterval"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataWindowInterval")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "windowInterval", m.GetWindowInterval(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'windowInterval' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataWindowInterval"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataWindowInterval")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataWindowInterval) IsBACnetConstructedDataWindowInterval() {}

func (m *_BACnetConstructedDataWindowInterval) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataWindowInterval) deepCopy() *_BACnetConstructedDataWindowInterval {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataWindowIntervalCopy := &_BACnetConstructedDataWindowInterval{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.WindowInterval),
	}
	_BACnetConstructedDataWindowIntervalCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataWindowIntervalCopy
}

func (m *_BACnetConstructedDataWindowInterval) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
