/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTimeSynchronizationRecipients is the corresponding interface of BACnetConstructedDataTimeSynchronizationRecipients
type BACnetConstructedDataTimeSynchronizationRecipients interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetTimeSynchronizationRecipients returns TimeSynchronizationRecipients (property field)
	GetTimeSynchronizationRecipients() []BACnetRecipient
	// IsBACnetConstructedDataTimeSynchronizationRecipients is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataTimeSynchronizationRecipients()
	// CreateBuilder creates a BACnetConstructedDataTimeSynchronizationRecipientsBuilder
	CreateBACnetConstructedDataTimeSynchronizationRecipientsBuilder() BACnetConstructedDataTimeSynchronizationRecipientsBuilder
}

// _BACnetConstructedDataTimeSynchronizationRecipients is the data-structure of this message
type _BACnetConstructedDataTimeSynchronizationRecipients struct {
	BACnetConstructedDataContract
	TimeSynchronizationRecipients []BACnetRecipient
}

var _ BACnetConstructedDataTimeSynchronizationRecipients = (*_BACnetConstructedDataTimeSynchronizationRecipients)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataTimeSynchronizationRecipients)(nil)

// NewBACnetConstructedDataTimeSynchronizationRecipients factory function for _BACnetConstructedDataTimeSynchronizationRecipients
func NewBACnetConstructedDataTimeSynchronizationRecipients(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, timeSynchronizationRecipients []BACnetRecipient, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTimeSynchronizationRecipients {
	_result := &_BACnetConstructedDataTimeSynchronizationRecipients{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		TimeSynchronizationRecipients: timeSynchronizationRecipients,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataTimeSynchronizationRecipientsBuilder is a builder for BACnetConstructedDataTimeSynchronizationRecipients
type BACnetConstructedDataTimeSynchronizationRecipientsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timeSynchronizationRecipients []BACnetRecipient) BACnetConstructedDataTimeSynchronizationRecipientsBuilder
	// WithTimeSynchronizationRecipients adds TimeSynchronizationRecipients (property field)
	WithTimeSynchronizationRecipients(...BACnetRecipient) BACnetConstructedDataTimeSynchronizationRecipientsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataTimeSynchronizationRecipients or returns an error if something is wrong
	Build() (BACnetConstructedDataTimeSynchronizationRecipients, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataTimeSynchronizationRecipients
}

// NewBACnetConstructedDataTimeSynchronizationRecipientsBuilder() creates a BACnetConstructedDataTimeSynchronizationRecipientsBuilder
func NewBACnetConstructedDataTimeSynchronizationRecipientsBuilder() BACnetConstructedDataTimeSynchronizationRecipientsBuilder {
	return &_BACnetConstructedDataTimeSynchronizationRecipientsBuilder{_BACnetConstructedDataTimeSynchronizationRecipients: new(_BACnetConstructedDataTimeSynchronizationRecipients)}
}

type _BACnetConstructedDataTimeSynchronizationRecipientsBuilder struct {
	*_BACnetConstructedDataTimeSynchronizationRecipients

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataTimeSynchronizationRecipientsBuilder) = (*_BACnetConstructedDataTimeSynchronizationRecipientsBuilder)(nil)

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataTimeSynchronizationRecipients
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) WithMandatoryFields(timeSynchronizationRecipients []BACnetRecipient) BACnetConstructedDataTimeSynchronizationRecipientsBuilder {
	return b.WithTimeSynchronizationRecipients(timeSynchronizationRecipients...)
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) WithTimeSynchronizationRecipients(timeSynchronizationRecipients ...BACnetRecipient) BACnetConstructedDataTimeSynchronizationRecipientsBuilder {
	b.TimeSynchronizationRecipients = timeSynchronizationRecipients
	return b
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) Build() (BACnetConstructedDataTimeSynchronizationRecipients, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataTimeSynchronizationRecipients.deepCopy(), nil
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) MustBuild() BACnetConstructedDataTimeSynchronizationRecipients {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataTimeSynchronizationRecipientsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataTimeSynchronizationRecipientsBuilder().(*_BACnetConstructedDataTimeSynchronizationRecipientsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataTimeSynchronizationRecipientsBuilder creates a BACnetConstructedDataTimeSynchronizationRecipientsBuilder
func (b *_BACnetConstructedDataTimeSynchronizationRecipients) CreateBACnetConstructedDataTimeSynchronizationRecipientsBuilder() BACnetConstructedDataTimeSynchronizationRecipientsBuilder {
	if b == nil {
		return NewBACnetConstructedDataTimeSynchronizationRecipientsBuilder()
	}
	return &_BACnetConstructedDataTimeSynchronizationRecipientsBuilder{_BACnetConstructedDataTimeSynchronizationRecipients: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetTimeSynchronizationRecipients() []BACnetRecipient {
	return m.TimeSynchronizationRecipients
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTimeSynchronizationRecipients(structType any) BACnetConstructedDataTimeSynchronizationRecipients {
	if casted, ok := structType.(BACnetConstructedDataTimeSynchronizationRecipients); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTimeSynchronizationRecipients); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetTypeName() string {
	return "BACnetConstructedDataTimeSynchronizationRecipients"
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.TimeSynchronizationRecipients) > 0 {
		for _, element := range m.TimeSynchronizationRecipients {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataTimeSynchronizationRecipients BACnetConstructedDataTimeSynchronizationRecipients, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTimeSynchronizationRecipients"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTimeSynchronizationRecipients")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timeSynchronizationRecipients, err := ReadTerminatedArrayField[BACnetRecipient](ctx, "timeSynchronizationRecipients", ReadComplex[BACnetRecipient](BACnetRecipientParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeSynchronizationRecipients' field"))
	}
	m.TimeSynchronizationRecipients = timeSynchronizationRecipients

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTimeSynchronizationRecipients"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTimeSynchronizationRecipients")
	}

	return m, nil
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTimeSynchronizationRecipients"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTimeSynchronizationRecipients")
		}

		if err := WriteComplexTypeArrayField(ctx, "timeSynchronizationRecipients", m.GetTimeSynchronizationRecipients(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'timeSynchronizationRecipients' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTimeSynchronizationRecipients"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTimeSynchronizationRecipients")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) IsBACnetConstructedDataTimeSynchronizationRecipients() {
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) deepCopy() *_BACnetConstructedDataTimeSynchronizationRecipients {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataTimeSynchronizationRecipientsCopy := &_BACnetConstructedDataTimeSynchronizationRecipients{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetRecipient, BACnetRecipient](m.TimeSynchronizationRecipients),
	}
	_BACnetConstructedDataTimeSynchronizationRecipientsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataTimeSynchronizationRecipientsCopy
}

func (m *_BACnetConstructedDataTimeSynchronizationRecipients) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
