/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataRequestedShedLevel is the corresponding interface of BACnetConstructedDataRequestedShedLevel
type BACnetConstructedDataRequestedShedLevel interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetRequestedShedLevel returns RequestedShedLevel (property field)
	GetRequestedShedLevel() BACnetShedLevel
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetShedLevel
	// IsBACnetConstructedDataRequestedShedLevel is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataRequestedShedLevel()
	// CreateBuilder creates a BACnetConstructedDataRequestedShedLevelBuilder
	CreateBACnetConstructedDataRequestedShedLevelBuilder() BACnetConstructedDataRequestedShedLevelBuilder
}

// _BACnetConstructedDataRequestedShedLevel is the data-structure of this message
type _BACnetConstructedDataRequestedShedLevel struct {
	BACnetConstructedDataContract
	RequestedShedLevel BACnetShedLevel
}

var _ BACnetConstructedDataRequestedShedLevel = (*_BACnetConstructedDataRequestedShedLevel)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataRequestedShedLevel)(nil)

// NewBACnetConstructedDataRequestedShedLevel factory function for _BACnetConstructedDataRequestedShedLevel
func NewBACnetConstructedDataRequestedShedLevel(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, requestedShedLevel BACnetShedLevel, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataRequestedShedLevel {
	if requestedShedLevel == nil {
		panic("requestedShedLevel of type BACnetShedLevel for BACnetConstructedDataRequestedShedLevel must not be nil")
	}
	_result := &_BACnetConstructedDataRequestedShedLevel{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		RequestedShedLevel:            requestedShedLevel,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataRequestedShedLevelBuilder is a builder for BACnetConstructedDataRequestedShedLevel
type BACnetConstructedDataRequestedShedLevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestedShedLevel BACnetShedLevel) BACnetConstructedDataRequestedShedLevelBuilder
	// WithRequestedShedLevel adds RequestedShedLevel (property field)
	WithRequestedShedLevel(BACnetShedLevel) BACnetConstructedDataRequestedShedLevelBuilder
	// WithRequestedShedLevelBuilder adds RequestedShedLevel (property field) which is build by the builder
	WithRequestedShedLevelBuilder(func(BACnetShedLevelBuilder) BACnetShedLevelBuilder) BACnetConstructedDataRequestedShedLevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataRequestedShedLevel or returns an error if something is wrong
	Build() (BACnetConstructedDataRequestedShedLevel, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataRequestedShedLevel
}

// NewBACnetConstructedDataRequestedShedLevelBuilder() creates a BACnetConstructedDataRequestedShedLevelBuilder
func NewBACnetConstructedDataRequestedShedLevelBuilder() BACnetConstructedDataRequestedShedLevelBuilder {
	return &_BACnetConstructedDataRequestedShedLevelBuilder{_BACnetConstructedDataRequestedShedLevel: new(_BACnetConstructedDataRequestedShedLevel)}
}

type _BACnetConstructedDataRequestedShedLevelBuilder struct {
	*_BACnetConstructedDataRequestedShedLevel

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataRequestedShedLevelBuilder) = (*_BACnetConstructedDataRequestedShedLevelBuilder)(nil)

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataRequestedShedLevel
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) WithMandatoryFields(requestedShedLevel BACnetShedLevel) BACnetConstructedDataRequestedShedLevelBuilder {
	return b.WithRequestedShedLevel(requestedShedLevel)
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) WithRequestedShedLevel(requestedShedLevel BACnetShedLevel) BACnetConstructedDataRequestedShedLevelBuilder {
	b.RequestedShedLevel = requestedShedLevel
	return b
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) WithRequestedShedLevelBuilder(builderSupplier func(BACnetShedLevelBuilder) BACnetShedLevelBuilder) BACnetConstructedDataRequestedShedLevelBuilder {
	builder := builderSupplier(b.RequestedShedLevel.CreateBACnetShedLevelBuilder())
	var err error
	b.RequestedShedLevel, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetShedLevelBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) Build() (BACnetConstructedDataRequestedShedLevel, error) {
	if b.RequestedShedLevel == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestedShedLevel' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataRequestedShedLevel.deepCopy(), nil
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) MustBuild() BACnetConstructedDataRequestedShedLevel {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataRequestedShedLevelBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataRequestedShedLevelBuilder().(*_BACnetConstructedDataRequestedShedLevelBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataRequestedShedLevelBuilder creates a BACnetConstructedDataRequestedShedLevelBuilder
func (b *_BACnetConstructedDataRequestedShedLevel) CreateBACnetConstructedDataRequestedShedLevelBuilder() BACnetConstructedDataRequestedShedLevelBuilder {
	if b == nil {
		return NewBACnetConstructedDataRequestedShedLevelBuilder()
	}
	return &_BACnetConstructedDataRequestedShedLevelBuilder{_BACnetConstructedDataRequestedShedLevel: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataRequestedShedLevel) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataRequestedShedLevel) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataRequestedShedLevel) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataRequestedShedLevel) GetRequestedShedLevel() BACnetShedLevel {
	return m.RequestedShedLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataRequestedShedLevel) GetActualValue() BACnetShedLevel {
	ctx := context.Background()
	_ = ctx
	return CastBACnetShedLevel(m.GetRequestedShedLevel())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataRequestedShedLevel(structType any) BACnetConstructedDataRequestedShedLevel {
	if casted, ok := structType.(BACnetConstructedDataRequestedShedLevel); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataRequestedShedLevel); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataRequestedShedLevel) GetTypeName() string {
	return "BACnetConstructedDataRequestedShedLevel"
}

func (m *_BACnetConstructedDataRequestedShedLevel) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (requestedShedLevel)
	lengthInBits += m.RequestedShedLevel.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataRequestedShedLevel) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataRequestedShedLevel) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataRequestedShedLevel BACnetConstructedDataRequestedShedLevel, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataRequestedShedLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataRequestedShedLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestedShedLevel, err := ReadSimpleField[BACnetShedLevel](ctx, "requestedShedLevel", ReadComplex[BACnetShedLevel](BACnetShedLevelParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestedShedLevel' field"))
	}
	m.RequestedShedLevel = requestedShedLevel

	actualValue, err := ReadVirtualField[BACnetShedLevel](ctx, "actualValue", (*BACnetShedLevel)(nil), requestedShedLevel)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataRequestedShedLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataRequestedShedLevel")
	}

	return m, nil
}

func (m *_BACnetConstructedDataRequestedShedLevel) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataRequestedShedLevel) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataRequestedShedLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataRequestedShedLevel")
		}

		if err := WriteSimpleField[BACnetShedLevel](ctx, "requestedShedLevel", m.GetRequestedShedLevel(), WriteComplex[BACnetShedLevel](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestedShedLevel' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataRequestedShedLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataRequestedShedLevel")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataRequestedShedLevel) IsBACnetConstructedDataRequestedShedLevel() {}

func (m *_BACnetConstructedDataRequestedShedLevel) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataRequestedShedLevel) deepCopy() *_BACnetConstructedDataRequestedShedLevel {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataRequestedShedLevelCopy := &_BACnetConstructedDataRequestedShedLevel{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetShedLevel](m.RequestedShedLevel),
	}
	_BACnetConstructedDataRequestedShedLevelCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataRequestedShedLevelCopy
}

func (m *_BACnetConstructedDataRequestedShedLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
