/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_PLC4X_READ_WRITE_PLC4X_MESSAGE_H_
#define PLC4C_PLC4X_READ_WRITE_PLC4X_MESSAGE_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "plc4x_response_code.h"
#include "plc4x_tag_value_response.h"
#include "plc4x_tag_response.h"
#include "plc4x_tag_value_request.h"
#include "plc4x_tag_request.h"
#include "plc4x_request_type.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_plc4x_read_write_plc4x_message_discriminator {
  enum plc4c_plc4x_read_write_plc4x_request_type requestType;
};
typedef struct plc4c_plc4x_read_write_plc4x_message_discriminator plc4c_plc4x_read_write_plc4x_message_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_plc4x_read_write_plc4x_message_type {
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_connect_request = 0,
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_connect_response = 1,
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_read_request = 2,
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_read_response = 3,
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_write_request = 4,
  plc4c_plc4x_read_write_plc4x_message_type_plc4c_plc4x_read_write_plc4x_write_response = 5};
typedef enum plc4c_plc4x_read_write_plc4x_message_type plc4c_plc4x_read_write_plc4x_message_type;

// Function to get the discriminator values for a given type.
plc4c_plc4x_read_write_plc4x_message_discriminator plc4c_plc4x_read_write_plc4x_message_get_discriminator(plc4c_plc4x_read_write_plc4x_message_type type);

// Constant values.
uint8_t PLC4C_PLC4X_READ_WRITE_PLC4X_MESSAGE_VERSION();

struct plc4c_plc4x_read_write_plc4x_message {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_plc4x_read_write_plc4x_message_type _type;
  /* Properties */
  uint8_t version;
  uint16_t request_id;
  union {
    struct { /* Plc4xConnectRequest */
      char* plc4x_connect_request_connection_string;
    };
    struct { /* Plc4xConnectResponse */
      uint16_t plc4x_connect_response_connection_id;
      plc4c_plc4x_read_write_plc4x_response_code plc4x_connect_response_response_code;
    };
    struct { /* Plc4xReadRequest */
      uint16_t plc4x_read_request_connection_id;
      plc4c_list* plc4x_read_request_tags;
    };
    struct { /* Plc4xReadResponse */
      uint16_t plc4x_read_response_connection_id;
      plc4c_plc4x_read_write_plc4x_response_code plc4x_read_response_response_code;
      plc4c_list* plc4x_read_response_tags;
    };
    struct { /* Plc4xWriteRequest */
      uint16_t plc4x_write_request_connection_id;
      plc4c_list* plc4x_write_request_tags;
    };
    struct { /* Plc4xWriteResponse */
      uint16_t plc4x_write_response_connection_id;
      plc4c_plc4x_read_write_plc4x_response_code plc4x_write_response_response_code;
      plc4c_list* plc4x_write_response_tags;
    };
  };
};
typedef struct plc4c_plc4x_read_write_plc4x_message plc4c_plc4x_read_write_plc4x_message;

// Create an empty NULL-struct
plc4c_plc4x_read_write_plc4x_message plc4c_plc4x_read_write_plc4x_message_null();

plc4c_return_code plc4c_plc4x_read_write_plc4x_message_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_plc4x_read_write_plc4x_message** message);

plc4c_return_code plc4c_plc4x_read_write_plc4x_message_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_plc4x_read_write_plc4x_message* message);

uint16_t plc4c_plc4x_read_write_plc4x_message_length_in_bytes(plc4x_spi_context ctx, plc4c_plc4x_read_write_plc4x_message* message);

uint16_t plc4c_plc4x_read_write_plc4x_message_length_in_bits(plc4x_spi_context ctx, plc4c_plc4x_read_write_plc4x_message* message);

#endif  // PLC4C_PLC4X_READ_WRITE_PLC4X_MESSAGE_H_
