/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.asm;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import org.apache.openjpa.enhance.asm.AsmSpi;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.ClassWriter;
import serp.bytecode.BCClass;

public class AsmSpi9
implements AsmSpi {
    private static final int Java7_MajorVersion = 51;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BCClass bc) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write();
        } else {
            String name = bc.getName();
            int dotIndex = name.lastIndexOf(46) + 1;
            name = name.substring(dotIndex);
            Class type = bc.getType();
            FileOutputStream out = new FileOutputStream(URLDecoder.decode(type.getResource(name + ".class").getFile()));
            try {
                this.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BCClass bc, File outFile) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write(outFile);
        } else {
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                this.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    public void write(BCClass bc, OutputStream os) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write(os);
        } else {
            try {
                this.writeJava7(bc, os);
            }
            finally {
                os.flush();
                os.close();
            }
        }
    }

    @Override
    public byte[] toByteArray(BCClass bc, byte[] returnBytes) throws IOException {
        if (bc.getMajorVersion() >= 51) {
            returnBytes = this.toJava7ByteArray(bc, returnBytes);
        }
        return returnBytes;
    }

    private void writeJava7(BCClass bc, OutputStream out) throws IOException {
        byte[] java7Bytes = this.toJava7ByteArray(bc, bc.toByteArray());
        out.write(java7Bytes);
    }

    private byte[] toJava7ByteArray(BCClass bc, byte[] classBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(classBytes);
        BufferedInputStream bis = new BufferedInputStream(bais);
        BCClassWriter cw = new BCClassWriter(2, bc.getClassLoader());
        ClassReader cr = new ClassReader(bis);
        cr.accept(cw, 0);
        return cw.toByteArray();
    }

    @Override
    public boolean isEnhanced(byte[] b) {
        if (b == null) {
            return false;
        }
        ClassReader cr = new ClassReader(b);
        try {
            cr.accept(new ClassVisitor(524288){

                @Override
                public void visit(int i, int i1, String name, String s, String parent, String[] interfaces) {
                    boolean enhanced;
                    boolean bl = enhanced = interfaces != null && interfaces.length > 0 && Arrays.asList(interfaces).contains("org/apache/openjpa/enhance/PersistenceCapable");
                    if (!(enhanced || name == null || parent == null || "java/lang/Object".equals(parent) || name.equals(parent))) {
                        enhanced = AsmSpi9.this.isEnhanced(AsmSpi9.this.bytes(parent));
                    }
                    throw new EnhancedStatusException(enhanced);
                }
            }, 0);
            return false;
        }
        catch (EnhancedStatusException e) {
            return e.status;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] bytes(String type) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(type + ".class");
        if (stream == null) {
            return null;
        }
        try {
            int c;
            byte[] buffer = new byte[1024];
            while ((c = stream.read(buffer)) >= 0) {
                baos.write(buffer, 0, c);
            }
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    private static class EnhancedStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean status;

        private EnhancedStatusException(boolean status) {
            this.status = status;
        }
    }

    private static class BCClassWriter
    extends ClassWriter {
        private final ClassLoader _loader;

        BCClassWriter(int flags, ClassLoader loader) {
            super(flags);
            this._loader = loader;
        }

        @Override
        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> class2;
            Class<?> class1;
            try {
                class1 = this._loader.loadClass(type1.replace('/', '.'));
                class2 = this._loader.loadClass(type2.replace('/', '.'));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

