/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.bval.model.Features;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaProperty;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBean
extends FeaturesCapable
implements Cloneable,
Features.Bean {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private Class<?> beanClass;
    private MetaProperty[] properties = new MetaProperty[0];

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public MetaProperty[] getProperties() {
        return (MetaProperty[])ArrayUtils.clone((Object[])this.properties);
    }

    public void setProperties(MetaProperty[] properties) {
        this.properties = (MetaProperty[])ArrayUtils.clone((Object[])properties);
        Arrays.sort(this.properties, PropertyNameComparator.INSTANCE);
    }

    public MetaProperty getProperty(String name) {
        MetaProperty[] props = this.properties;
        int pos = Arrays.binarySearch(props, name, PropertyNameComparator.INSTANCE);
        return pos < 0 ? null : props[pos];
    }

    public boolean hasRelationships() {
        for (MetaProperty p : this.properties) {
            if (!p.isRelationship()) continue;
            return true;
        }
        return false;
    }

    public boolean hasProperties() {
        return this.properties.length > 0;
    }

    public void putProperty(String name, MetaProperty property) {
        Object key;
        Object[] props;
        int pos;
        if (property != null) {
            property.setParentMetaBean(this);
        }
        if ((pos = Arrays.binarySearch(props = this.properties, key = property == null ? name : property, PropertyNameComparator.INSTANCE)) < 0) {
            if (property == null) {
                return;
            }
            props = (MetaProperty[])ArrayUtils.add((Object[])props, (int)(0 - pos - 1), (Object)property);
        } else if (property == null) {
            props = (MetaProperty[])ArrayUtils.remove((Object[])props, (int)pos);
        } else {
            props[pos] = property;
        }
        this.properties = props;
    }

    public String toString() {
        return "MetaBean{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", beanClass=" + this.beanClass + '}';
    }

    @Override
    protected void copyInto(FeaturesCapable target) {
        super.copyInto(target);
        MetaBean copy = (MetaBean)target;
        if (this.properties != null) {
            copy.properties = (MetaProperty[])this.properties.clone();
            for (int i = copy.properties.length - 1; i >= 0; --i) {
                copy.properties[i] = (MetaProperty)copy.properties[i].copy();
            }
        }
    }

    public MetaBean resolveMetaBean(Object bean) {
        return bean == null || bean == this.beanClass || this.beanClass.isInstance(bean) ? this : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyNameComparator
    implements Comparator<Object> {
        static final PropertyNameComparator INSTANCE = new PropertyNameComparator();

        private PropertyNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.getName(o1).compareTo(this.getName(o2));
        }

        private String getName(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return o instanceof MetaProperty ? ((MetaProperty)o).getName() : String.valueOf(o);
        }
    }
}

