/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.util.IOUtils;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.PropertyType;
import org.apache.bval.jsr303.xml.ValidationConfigType;
import org.apache.bval.util.PrivilegedActions;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";
    private static final Logger log = Logger.getLogger(ValidationParser.class.getName());
    protected final String validationXmlFile;

    public ValidationParser(String file) {
        this.validationXmlFile = file == null ? DEFAULT_VALIDATION_XML_FILE : file;
    }

    public void processValidationConfig(ConfigurationImpl targetConfig) {
        ValidationConfigType xmlConfig = this.parseXmlConfig();
        if (xmlConfig != null) {
            this.applyConfig(xmlConfig, targetConfig);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationConfigType parseXmlConfig() {
        ValidationConfigType validationConfigType;
        InputStream inputStream;
        block6: {
            inputStream = null;
            inputStream = this.getInputStream(this.validationXmlFile);
            if (inputStream != null) break block6;
            log.log(Level.FINEST, String.format("No %s found. Using annotation based configuration only.", this.validationXmlFile));
            ValidationConfigType validationConfigType2 = null;
            IOUtils.closeQuietly(inputStream);
            return validationConfigType2;
        }
        try {
            log.log(Level.FINEST, String.format("%s found.", this.validationXmlFile));
            Schema schema = this.getSchema();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            validationConfigType = (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            try {
                throw new ValidationException("Unable to parse " + this.validationXmlFile, (Throwable)e);
                catch (IOException e2) {
                    throw new ValidationException("Unable to parse " + this.validationXmlFile, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return validationConfigType;
    }

    protected InputStream getInputStream(String path) throws IOException {
        Enumeration<URL> urls;
        ClassLoader loader = PrivilegedActions.getClassLoader(this.getClass());
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream != null && (urls = loader.getResources(path)).hasMoreElements()) {
            String url = urls.nextElement().toString();
            while (urls.hasMoreElements()) {
                if (url.equals(urls.nextElement().toString())) continue;
                throw new ValidationException("More than one " + path + " is found in the classpath");
            }
        }
        return inputStream;
    }

    private Schema getSchema() {
        return ValidationParser.getSchema(VALIDATION_CONFIGURATION_XSD);
    }

    static Schema getSchema(String xsd) {
        ClassLoader loader = PrivilegedActions.getClassLoader(ValidationParser.class);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = loader.getResource(xsd);
        try {
            return sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.log(Level.WARNING, String.format("Unable to parse schema: %s", xsd), e);
            return null;
        }
    }

    private void applyConfig(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        this.applyProviderClass(xmlConfig, targetConfig);
        this.applyMessageInterpolator(xmlConfig, targetConfig);
        this.applyTraversableResolver(xmlConfig, targetConfig);
        this.applyConstraintFactory(xmlConfig, targetConfig);
        this.applyMappingStreams(xmlConfig, targetConfig);
        this.applyProperties(xmlConfig, targetConfig);
    }

    private void applyProperties(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (PropertyType property : xmlConfig.getProperty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, String.format("Found property '%s' with value '%s' in %s", property.getName(), property.getValue(), this.validationXmlFile));
            }
            target.addProperty(property.getName(), property.getValue());
        }
    }

    private void applyProviderClass(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String providerClassName = xmlConfig.getDefaultProvider();
        if (providerClassName != null) {
            Class<?> clazz = this.loadClass(providerClassName);
            target.setProviderClass(clazz);
            log.log(Level.INFO, String.format("Using %s as validation provider.", providerClassName));
        }
    }

    private void applyMessageInterpolator(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String messageInterpolatorClass = xmlConfig.getMessageInterpolator();
        if (target.getMessageInterpolator() == null && messageInterpolatorClass != null) {
            Class<?> clazz = this.loadClass(messageInterpolatorClass);
            target.messageInterpolator((MessageInterpolator)this.newInstance(clazz));
            log.log(Level.INFO, String.format("Using %s as message interpolator.", messageInterpolatorClass));
        }
    }

    private void applyTraversableResolver(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String traversableResolverClass = xmlConfig.getTraversableResolver();
        if (target.getTraversableResolver() == null && traversableResolverClass != null) {
            Class<?> clazz = this.loadClass(traversableResolverClass);
            target.traversableResolver((TraversableResolver)this.newInstance(clazz));
            log.log(Level.INFO, String.format("Using %s as traversable resolver.", traversableResolverClass));
        }
    }

    private <T> T newInstance(final Class<T> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return cls.newInstance();
                }
                catch (Exception ex) {
                    throw new ValidationException("Cannot instantiate : " + cls, (Throwable)ex);
                }
            }
        });
    }

    private void applyConstraintFactory(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String constraintFactoryClass = xmlConfig.getConstraintValidatorFactory();
        if (target.getConstraintValidatorFactory() == null && constraintFactoryClass != null) {
            Class<?> clazz = this.loadClass(constraintFactoryClass);
            target.constraintValidatorFactory((ConstraintValidatorFactory)this.newInstance(clazz));
            log.log(Level.INFO, String.format("Using %s as constraint factory.", constraintFactoryClass));
        }
    }

    private void applyMappingStreams(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (JAXBElement<String> mappingFileNameElement : xmlConfig.getConstraintMapping()) {
            String mappingFileName = (String)mappingFileNameElement.getValue();
            if (mappingFileName.startsWith("/")) {
                mappingFileName = mappingFileName.substring(1);
            }
            log.log(Level.FINEST, String.format("Trying to open input stream for %s", mappingFileName));
            InputStream in = null;
            try {
                in = this.getInputStream(mappingFileName);
                if (in == null) {
                    throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName);
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName, (Throwable)e);
            }
            target.addMapping(in);
        }
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = ValidationParser.doPrivileged(SecureActions.getContextClassLoader());
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ValidationException("Unable to load class: " + className, (Throwable)ex);
        }
    }
}

