/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.jpql.JPQLExpressionBuilder;
import org.apache.openjpa.meta.ClassMetaData;

public class Context
implements Serializable {
    public final JPQLExpressionBuilder.ParsedJPQL parsed;
    public ClassMetaData meta;
    public String schemaAlias;
    public Subquery subquery;
    public Expression from = null;
    public Context cloneFrom = null;
    private final Context parent;
    private List<Context> subsels = null;
    private Object select = null;
    protected int aliasCount = -1;
    private Map<String, Value> variables = new HashMap<String, Value>();
    private Map<String, ClassMetaData> schemas = new HashMap<String, ClassMetaData>();

    public Context(JPQLExpressionBuilder.ParsedJPQL parsed, Subquery subquery, Context parent) {
        this.parsed = parsed;
        this.subquery = subquery;
        this.parent = parent;
        if (subquery != null) {
            this.select = subquery.getSelect();
            parent.addSubselContext(this);
        }
    }

    public void setSubquery(Subquery subquery) {
        this.subquery = subquery;
        this.select = subquery.getSelect();
        this.parent.addSubselContext(this);
    }

    public ClassMetaData meta() {
        return this.meta;
    }

    public String schemaAlias() {
        return this.schemaAlias;
    }

    public Subquery subquery() {
        return this.subquery;
    }

    public int nextAlias() {
        Context p = this;
        while (p.subquery != null) {
            p = p.parent;
        }
        ++p.aliasCount;
        return p.aliasCount;
    }

    public void resetAliasCount() {
        Context p = this;
        while (p.subquery != null) {
            p = p.parent;
        }
        p.aliasCount = -1;
    }

    public void setSelect(Object select) {
        this.select = select;
    }

    public Object getSelect() {
        return this.select;
    }

    public void addSubselContext(Context sub) {
        if (sub == null) {
            return;
        }
        if (this.subsels == null) {
            this.subsels = new ArrayList<Context>();
        }
        this.subsels.add(sub);
    }

    public List<Context> getSubselContexts() {
        return this.subsels;
    }

    public Subquery getSubquery() {
        return this.subquery;
    }

    public Context getParent() {
        return this.parent;
    }

    public void addVariable(String id, Value var) {
        this.variables.put(id.toLowerCase(), var);
    }

    public Map<String, Value> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Value> variables) {
        this.variables = variables;
    }

    public void addSchema(String id, ClassMetaData meta) {
        this.schemas.put(id.toLowerCase(), meta);
    }

    public ClassMetaData getSchema(String id) {
        if (id != null) {
            return this.schemas.get(id.toLowerCase());
        }
        return null;
    }

    public Map<String, ClassMetaData> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Map<String, ClassMetaData> schemas) {
        this.schemas = schemas;
    }

    public Value getVariable(String alias) {
        Value variable = alias == null ? null : this.variables.get(alias.toLowerCase());
        return variable;
    }

    public Context findContext(String alias) {
        Value var = this.getVariable(alias);
        if (var != null) {
            return this;
        }
        Context p = this.parent;
        while (p != null) {
            var = p.getVariable(alias);
            if (var != null) {
                return p;
            }
            p = p.parent;
        }
        if (this.subsels != null) {
            for (Context subsel : this.subsels) {
                if (subsel == null || (var = subsel.getVariable(alias)) == null) continue;
                return subsel;
            }
        }
        return null;
    }

    public Value findVariable(String alias) {
        Value var = this.getVariable(alias);
        if (var != null) {
            return var;
        }
        Context p = this.parent;
        while (p != null) {
            var = p.getVariable(alias);
            if (var != null) {
                return var;
            }
            p = p.parent;
        }
        return null;
    }
}

